/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ASN1;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.util.ByteArray;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class ASN1Object {
    public abstract byte getTag() throws ASN1Exception;

    public abstract byte getExplicitTag(int var1) throws ASN1Exception;

    public abstract byte getImplicitTag(int var1) throws ASN1Exception;

    public abstract boolean checkTag(int var1) throws ASN1Exception;

    public abstract boolean checkExplicitTag(int var1, int var2) throws ASN1Exception;

    public abstract boolean checkImplicitTag(int var1, int var2) throws ASN1Exception;

    public abstract void encodeValue(OutputStream var1) throws ASN1Exception, IOException;

    public abstract void decodeValue(int var1, byte[] var2) throws ASN1Exception;

    public abstract void decodeValueIndefiniteLength(int var1, InputStream var2) throws ASN1Exception;

    public static final int getLength(InputStream in) throws ASN1Exception, IOException {
        int r = in.read();
        if (r == -1) {
            throw new ASN1Exception("Unexpected end of length info");
        }
        if (r == 128) {
            return -1;
        }
        if ((r & 0x80) == 128) {
            int num = r & 0x7F;
            if (num > 4) {
                throw new ASN1Exception("Can not handle that large sizes");
            }
            byte[] lengtharray = new byte[num];
            int res = in.read(lengtharray);
            if (res != num) {
                throw new ASN1Exception("Unexpected end of length info");
            }
            int length = 0;
            for (int i = 0; i < num; ++i) {
                length <<= 8;
                length += lengtharray[i] & 0xFF;
            }
            return length;
        }
        return r & 0x7F;
    }

    protected ASN1Object() {
    }

    public void decode(InputStream in) throws ASN1Exception, IOException {
        int tag = in.read();
        if (tag == -1) {
            throw new ASN1Exception("Unexpected end of encoding in " + this.getClass().getName());
        }
        boolean ok = this.checkTag(tag);
        if (!ok) {
            throw new ASN1Exception("Bad tag in " + this.getClass().getName());
        }
        int length = ASN1Object.getLength(in);
        if (length == -1) {
            this.decodeValueIndefiniteLength(tag, in);
        } else {
            int res;
            byte[] encodedvalue = new byte[length];
            if (length != 0 && (res = in.read(encodedvalue)) != length) {
                throw new ASN1Exception("Invalid value length in " + this.getClass().getName());
            }
            this.decodeValue(tag, encodedvalue);
        }
    }

    public void decode(byte[] enc, int expectedtag, boolean explicit) throws ASN1Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(enc);
        try {
            this.decode(in);
        }
        catch (IOException e) {
            throw new ASN1Exception("Could not read from ByteArrayInputStream: " + e.getMessage());
        }
    }

    public void decode(byte[] enc) throws ASN1Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(enc);
        try {
            this.decode(in);
        }
        catch (IOException e) {
            throw new ASN1Exception("Could not read from ByteArrayInputStream : " + e.getMessage());
        }
    }

    public static void encode_length_octets(OutputStream out, int length) throws ASN1Exception, IOException {
        if (length < 0) {
            throw new ASN1Exception("Negative length.");
        }
        if (length <= 127) {
            out.write((byte)length);
        } else {
            int i = 4;
            int testmask = -16777216;
            while ((length & testmask) == 0) {
                i = (char)(i - 1);
                testmask >>= 8;
                testmask &= 0xFFFFFF;
            }
            out.write((byte)(0x80 | i));
            while (i > 0) {
                int temp = length & testmask;
                out.write((byte)((temp >>= 8 * (i - 1)) & 0xFF));
                testmask >>= 8;
                i = (char)(i - 1);
            }
        }
    }

    public void encode(OutputStream out) throws ASN1Exception, IOException {
        ByteArrayOutputStream encodedvalue = new ByteArrayOutputStream();
        this.encodeValue(encodedvalue);
        out.write(this.getTag());
        ASN1Object.encode_length_octets(out, encodedvalue.size());
        out.write(encodedvalue.toByteArray());
    }

    public byte[] encode() throws ASN1Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.encode(out);
        }
        catch (IOException e) {
            throw new ASN1Exception("Could not write to ByteArrayOuputStream : " + e.getMessage());
        }
        return out.toByteArray();
    }

    public byte[] encodeValue() throws ASN1Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.encodeValue(out);
        }
        catch (IOException e) {
            throw new ASN1Exception("Could not write to ByteArrayOuputStream : " + e.getMessage());
        }
        return out.toByteArray();
    }

    public String toString() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1, name.length());
    }

    public boolean equals(ASN1Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        try {
            return ByteArray.equals(this.encodeValue(), obj.encodeValue());
        }
        catch (ASN1Exception ignore) {
            return false;
        }
    }
}

