/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ASN1;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Object;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class ASN1StringObject
extends ASN1Object {
    public boolean checkTag(int tag) throws ASN1Exception {
        return (tag & 0x1F) == this.getTag();
    }

    public boolean checkExplicitTag(int tag, int number) throws ASN1Exception {
        return tag == (0xA0 | number);
    }

    public boolean checkImplicitTag(int tag, int number) throws ASN1Exception {
        return (0x8F & tag) == (0x80 | number);
    }

    public byte getExplicitTag(int number) throws ASN1Exception {
        return (byte)(0xA0 | number);
    }

    public byte getImplicitTag(int number) throws ASN1Exception {
        return (byte)(0x80 | number);
    }

    public void decodeValue(int tag, byte[] enc) throws ASN1Exception {
        if ((tag & 0x20) == 0) {
            this.appendValue(enc);
        } else {
            ByteArrayInputStream thisinput = new ByteArrayInputStream(enc);
            while (thisinput.available() > 0) {
                try {
                    this.decode(thisinput);
                }
                catch (IOException e) {
                    throw new ASN1Exception("Could not read from ByteArrayInputStream: " + e.getMessage());
                }
            }
        }
    }

    public abstract void appendValue(byte[] var1) throws ASN1Exception;

    public void decodeValueIndefiniteLength(int tag, InputStream in) throws ASN1Exception {
        try {
            int readtag = in.read();
            while (readtag != 0) {
                if (!this.checkTag(readtag)) {
                    throw new ASN1Exception("Invalid tag (expected " + this.getTag() + " got " + readtag + ")");
                }
                int length = ASN1StringObject.getLength(in);
                if (length == -1) {
                    this.decodeValueIndefiniteLength(readtag, in);
                } else {
                    int res;
                    byte[] encodedvalue = new byte[length];
                    if (length != 0 && (res = in.read(encodedvalue)) != length) {
                        throw new ASN1Exception("Invalid value length in " + this.getClass().getName());
                    }
                    this.appendValue(encodedvalue);
                }
                readtag = in.read();
            }
            readtag = in.read();
            if (readtag != 0) {
                throw new ASN1Exception("Indefinite encodign did not end with double 0x00");
            }
        }
        catch (IOException e1) {
            throw new ASN1Exception("IOException" + e1.getMessage());
        }
    }
}

