/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ASN1;

import com.cryptomathic.ASN1.ASN1ConstructedObject;
import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.ChoiceTemplate;
import com.cryptomathic.ASN1.ChoiceTemplateMember;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Choice
extends ASN1Object {
    public byte getTag() throws ASN1Exception {
        Enumeration enumerator = this.getTemplate().getTemplate().elements();
        Enumeration enumObjs = this.getMembers().elements();
        byte tag = -1;
        while (enumerator.hasMoreElements() && enumObjs.hasMoreElements()) {
            ChoiceTemplateMember member = (ChoiceTemplateMember)enumerator.nextElement();
            ASN1Object obj = (ASN1Object)enumObjs.nextElement();
            if (obj == null) continue;
            if (member.isExplicit()) {
                tag = this.getExplicitTag(member.getTag());
                break;
            }
            if (member.isImplicit()) {
                tag = this.getImplicitTag(member.getTag());
                if (!(obj instanceof ASN1ConstructedObject)) break;
                tag = (byte)(tag | 0x20);
                break;
            }
            tag = obj.getTag();
            break;
        }
        if (tag == -1) {
            throw new ASN1Exception("Could not getTag on " + this.getClass().getName() + ". Choice is empty.");
        }
        while (enumerator.hasMoreElements() && enumObjs.hasMoreElements()) {
            enumerator.nextElement();
            ASN1Object obj = (ASN1Object)enumObjs.nextElement();
            if (obj == null) continue;
            throw new ASN1Exception("Could not getTag on " + this.getClass().getName() + ". Choice contains multiple elements.");
        }
        return tag;
    }

    public boolean checkTag(int tag) throws ASN1Exception {
        Enumeration enumeration = this.getTemplate().getTemplate().elements();
        while (enumeration.hasMoreElements()) {
            ChoiceTemplateMember member = (ChoiceTemplateMember)enumeration.nextElement();
            if (tag != member.getTag()) continue;
            return true;
        }
        return false;
    }

    public boolean checkExplicitTag(int tag, int number) throws ASN1Exception {
        return tag != -1;
    }

    public boolean checkImplicitTag(int tag, int number) throws ASN1Exception {
        return tag != -1;
    }

    public byte getExplicitTag(int number) throws ASN1Exception {
        return (byte)(0xA0 | number);
    }

    public byte getImplicitTag(int number) throws ASN1Exception {
        return (byte)(0x80 | number);
    }

    protected abstract void setMembers(Vector var1) throws ASN1Exception;

    protected abstract Vector getMembers() throws ASN1Exception;

    protected abstract ChoiceTemplate getTemplate() throws ASN1Exception;

    public void decodeValue(int tag, byte[] in) throws ASN1Exception {
        boolean found = false;
        Enumeration enumeration = this.getTemplate().getTemplate().elements();
        Vector<ASN1Object> v = new Vector<ASN1Object>();
        while (enumeration.hasMoreElements()) {
            ASN1Object obj;
            ChoiceTemplateMember member = (ChoiceTemplateMember)enumeration.nextElement();
            Class clazz = member.getClazz();
            try {
                obj = (ASN1Object)clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new ASN1Exception("Choice contained invalid submember (" + e.getMessage() + ")");
            }
            catch (IllegalAccessException e) {
                throw new ASN1Exception("Choice contained invalid submember (" + e.getMessage() + ")");
            }
            boolean ok = member.isExplicit() ? obj.checkExplicitTag(tag, member.getTag()) : (member.isImplicit() ? obj.checkImplicitTag(tag, member.getTag()) : obj.checkTag(tag));
            if (ok) {
                if (member.isExplicit()) {
                    ByteArrayInputStream thisinput = new ByteArrayInputStream(in);
                    try {
                        obj.decode(thisinput);
                    }
                    catch (IOException e) {
                        throw new ASN1Exception("Could not read from ByteArrayInputStream: " + e.getMessage());
                    }
                } else if (member.isImplicit()) {
                    obj.decodeValue(tag, in);
                } else {
                    obj.decodeValue(tag, in);
                }
                v.add(obj);
                found = true;
                break;
            }
            v.add(null);
        }
        if (!found) {
            throw new ASN1Exception("Could not decode " + this.getClass().getName() + ". No choice matches tags.");
        }
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            v.add(null);
        }
        this.setMembers(v);
    }

    public void decodeValueIndefiniteLength(int tag, InputStream in) throws ASN1Exception {
        throw new ASN1Exception("Indefinite length not supported for Choice");
    }

    public void encodeValue(OutputStream out) throws ASN1Exception, IOException {
        boolean found = false;
        Enumeration enumeration = this.getTemplate().getTemplate().elements();
        Enumeration enumObjs = this.getMembers().elements();
        while (enumeration.hasMoreElements() && enumObjs.hasMoreElements()) {
            ChoiceTemplateMember member = (ChoiceTemplateMember)enumeration.nextElement();
            ASN1Object obj = (ASN1Object)enumObjs.nextElement();
            if (obj == null) continue;
            ByteArrayOutputStream encodedvalue = new ByteArrayOutputStream();
            try {
                obj.encodeValue(encodedvalue);
            }
            catch (IOException e) {
                throw new ASN1Exception("Could not write to ByteArrayOuputStream : " + e.getMessage());
            }
            if (member.isExplicit()) {
                ByteArrayOutputStream innerencodedvalue = new ByteArrayOutputStream();
                innerencodedvalue.write(obj.getTag());
                Choice.encode_length_octets(innerencodedvalue, encodedvalue.size());
                innerencodedvalue.write(encodedvalue.toByteArray());
                encodedvalue = innerencodedvalue;
            }
            out.write(encodedvalue.toByteArray());
            found = true;
            break;
        }
        if (!found) {
            throw new ASN1Exception("Could not encode " + this.getClass().getName() + ". Choice is empty.");
        }
        while (enumeration.hasMoreElements() && enumObjs.hasMoreElements()) {
            enumeration.nextElement();
            ASN1Object obj = (ASN1Object)enumObjs.nextElement();
            if (obj == null) continue;
            throw new ASN1Exception("Could not encode " + this.getClass().getName() + ". Choice contains multiple elements.");
        }
    }

    public ASN1Object getValue() throws ASN1Exception {
        ASN1Object obj;
        ASN1Object result = null;
        Enumeration enumObjs = this.getMembers().elements();
        while (enumObjs.hasMoreElements()) {
            obj = (ASN1Object)enumObjs.nextElement();
            if (obj == null) continue;
            result = obj;
            break;
        }
        if (result == null) {
            throw new ASN1Exception("Could not getValue : Choice contains no values");
        }
        while (enumObjs.hasMoreElements()) {
            obj = (ASN1Object)enumObjs.nextElement();
            if (obj == null) continue;
            throw new ASN1Exception("Could not getValue : Choice contains multiple values");
        }
        return result;
    }

    public String toString() {
        try {
            return this.getValue().toString();
        }
        catch (ASN1Exception ignore) {
            return "error";
        }
    }
}

