/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ASN1;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1NonStringObject;
import com.cryptomathic.util.ByteArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;

public class ObjectIdentifier
extends ASN1NonStringObject {
    public byte[] value;

    public byte getTag() {
        return 6;
    }

    public ObjectIdentifier() {
    }

    public ObjectIdentifier(byte[] val) {
        this.value = val;
    }

    public ObjectIdentifier(String val) throws ASN1Exception {
        this.value = ObjectIdentifier.toBytes(val);
    }

    public void decodeValue(int tag, byte[] enc) throws ASN1Exception {
        this.value = new byte[enc.length];
        System.arraycopy(enc, 0, this.value, 0, enc.length);
    }

    public void encodeValue(OutputStream out) throws ASN1Exception, IOException {
        out.write(this.value);
    }

    public static final String toString(byte[] bytes) {
        if (bytes.length == 0) {
            return "";
        }
        int first = bytes[0] & 0x7F;
        String result = first >= 80 ? "2." + (first - 80) : (first >= 40 ? "1." + (first - 40) : "0." + first);
        int i = 0;
        while (i < bytes.length - 1) {
            int subid = bytes[++i] & 0x7F;
            while ((bytes[i] & 0x80) != 0) {
                subid *= 128;
                subid += bytes[++i] & 0x7F;
            }
            result = result + "." + subid;
        }
        return result;
    }

    public String toString() {
        return ObjectIdentifier.toString(this.value);
    }

    public static final byte[] toBytes(String str) throws ASN1Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StringTokenizer tokenizer = new StringTokenizer(str, ".");
        if (tokenizer.countTokens() < 2) {
            throw new ASN1Exception("ObjectIdentifier must have at least two components");
        }
        int first = Integer.parseInt(tokenizer.nextToken());
        if (first < 0 || first > 2) {
            throw new ASN1Exception("First component of ObjectIdentifier must be 0, 1 or 2");
        }
        int second = Integer.parseInt(tokenizer.nextToken());
        if (first != 2 && (second < 0 || second > 39)) {
            throw new ASN1Exception("Second component of ObjectIdentifier must be between 0 and 39");
        }
        ObjectIdentifier.encode_subidentifier(first * 40 + second, out);
        while (tokenizer.hasMoreTokens()) {
            int val = Integer.parseInt(tokenizer.nextToken());
            ObjectIdentifier.encode_subidentifier(val, out);
        }
        return out.toByteArray();
    }

    private static void encode_subidentifier(int val, ByteArrayOutputStream out) {
        long encoded = 0L;
        int count = 0;
        while (val > 0) {
            int part = val & 0x7F;
            if (count != 0) {
                part |= 0x80;
            }
            encoded |= (long)(part << count * 8);
            val >>>= 7;
            ++count;
        }
        for (int i = count - 1; i >= 0; --i) {
            byte b = (byte)(encoded >> i * 8 & 0xFFL);
            out.write(b);
        }
    }

    public boolean equals(byte[] oid) {
        return ByteArray.equals(this.value, oid);
    }
}

