/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ASN1;

import com.cryptomathic.ASN1.ASN1ConstructedObject;
import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.AnyDefinedBy;
import com.cryptomathic.ASN1.ObjectIdentifier;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.ASN1.SequenceTemplateMember;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Sequence
extends ASN1ConstructedObject {
    public byte getTag() {
        return 48;
    }

    protected abstract void setMembers(Vector var1) throws ASN1Exception;

    protected abstract Vector getMembers();

    protected abstract SequenceTemplate getTemplate() throws ASN1Exception;

    public void decodeValue(int tag, byte[] in) throws ASN1Exception {
        Enumeration enumerator = this.getTemplate().getTemplate().elements();
        Vector<ASN1Object> v = new Vector<ASN1Object>();
        ByteArrayInputStream thisinput = new ByteArrayInputStream(in);
        try {
            int readtag = thisinput.read();
            while (enumerator.hasMoreElements()) {
                int res;
                byte[] subobject;
                int length;
                boolean ok;
                ASN1Object obj;
                SequenceTemplateMember member = (SequenceTemplateMember)enumerator.nextElement();
                Class clazz = member.getClazz();
                try {
                    obj = (ASN1Object)clazz.newInstance();
                }
                catch (InstantiationException e) {
                    throw new ASN1Exception("Could not instantiate submember (" + e.getMessage() + ")");
                }
                catch (IllegalAccessException e) {
                    throw new ASN1Exception("Illegal access while instantiating submember (" + e.getMessage() + ")");
                }
                if (member.isAnyDefinedBy()) {
                    Object objid = v.get(member.getDefinedBy());
                    if (!(objid instanceof ObjectIdentifier)) {
                        throw new ASN1Exception(this.getClass().getName() + ": " + obj.getClass().getName() + " was defined by " + objid.getClass().getName() + ", which is not an ObjectIdentifier");
                    }
                    ((AnyDefinedBy)obj).setAnyDefinedBy(((ObjectIdentifier)objid).value);
                }
                if (member.isExplicit()) {
                    if (!obj.checkExplicitTag(readtag, member.getTag())) {
                        ok = false;
                    } else {
                        length = Sequence.getLength(thisinput);
                        if (length == -1) {
                            obj.decode(thisinput);
                            if (thisinput.read() != 0) {
                                throw new ASN1Exception("Indefinite encoding did not end with double 0x00");
                            }
                            if (thisinput.read() != 0) {
                                throw new ASN1Exception("Indefinite encoding did not end with double 0x00");
                            }
                        } else {
                            subobject = new byte[length];
                            if (length != 0 && (res = thisinput.read(subobject)) != length) {
                                throw new ASN1Exception("Invalid value length in " + this.getClass().getName());
                            }
                            obj.decode(subobject);
                        }
                        ok = true;
                    }
                } else {
                    ok = member.isImplicit() ? obj.checkImplicitTag(readtag, member.getTag()) : obj.checkTag(readtag);
                    if (ok) {
                        length = Sequence.getLength(thisinput);
                        subobject = new byte[length];
                        if (length != 0 && (res = thisinput.read(subobject)) != length) {
                            throw new ASN1Exception("Invalid value length in " + this.getClass().getName());
                        }
                        obj.decodeValue(readtag, subobject);
                    }
                }
                if (ok) {
                    v.add(obj);
                    readtag = thisinput.read();
                    continue;
                }
                if (member.isOptional()) {
                    v.add(null);
                    continue;
                }
                if (member.hasDefault()) {
                    v.add(member.getDefaultValue());
                    continue;
                }
                throw new ASN1Exception("Mandatory element \"" + obj.getClass().getName() + "\" was not present in " + this.getClass().getName());
            }
        }
        catch (IOException e) {
            throw new ASN1Exception("Could not read from ByteArrayInputStream: " + e.getMessage());
        }
        this.setMembers(v);
    }

    public void decodeValueIndefiniteLength(int tag, InputStream in) throws ASN1Exception {
        Enumeration enumerator = this.getTemplate().getTemplate().elements();
        Vector<ASN1Object> v = new Vector<ASN1Object>();
        try {
            int readtag = in.read();
            while (enumerator.hasMoreElements() && readtag != 0) {
                int res;
                byte[] subobject;
                int length;
                boolean ok;
                ASN1Object obj;
                SequenceTemplateMember member = (SequenceTemplateMember)enumerator.nextElement();
                Class clazz = member.getClazz();
                try {
                    obj = (ASN1Object)clazz.newInstance();
                }
                catch (InstantiationException e) {
                    throw new ASN1Exception("Could not instantiate submember (" + e.getMessage() + ")");
                }
                catch (IllegalAccessException e) {
                    throw new ASN1Exception("Illegal access while instantiating submember (" + e.getMessage() + ")");
                }
                if (member.isAnyDefinedBy()) {
                    Object objid = v.get(member.getDefinedBy());
                    if (!(objid instanceof ObjectIdentifier)) {
                        throw new ASN1Exception(this.getClass().getName() + ": " + obj.getClass().getName() + " was defined by " + objid.getClass().getName() + ", which is not an ObjectIdentifier");
                    }
                    ((AnyDefinedBy)obj).setAnyDefinedBy(((ObjectIdentifier)objid).value);
                }
                if (member.isExplicit()) {
                    if (!obj.checkExplicitTag(readtag, member.getTag())) {
                        ok = false;
                    } else {
                        length = Sequence.getLength(in);
                        if (length == -1) {
                            obj.decode(in);
                            if (in.read() != 0) {
                                throw new ASN1Exception("Indefinite encoding did not end with double 0x00");
                            }
                            if (in.read() != 0) {
                                throw new ASN1Exception("Indefinite encoding did not end with double 0x00");
                            }
                        } else {
                            subobject = new byte[length];
                            if (length != 0 && (res = in.read(subobject)) != length) {
                                throw new ASN1Exception("Invalid value length in " + this.getClass().getName());
                            }
                            obj.decode(subobject);
                        }
                        ok = true;
                    }
                } else {
                    ok = member.isImplicit() ? obj.checkImplicitTag(readtag, member.getTag()) : obj.checkTag(readtag);
                    if (ok) {
                        length = Sequence.getLength(in);
                        if (length == -1) {
                            obj.decodeValueIndefiniteLength(readtag, in);
                        } else {
                            subobject = new byte[length];
                            if (length != 0 && (res = in.read(subobject)) != length) {
                                throw new ASN1Exception("Invalid value length in " + this.getClass().getName());
                            }
                            obj.decodeValue(readtag, subobject);
                        }
                    }
                }
                if (ok) {
                    v.add(obj);
                    readtag = in.read();
                    continue;
                }
                if (member.isOptional()) {
                    v.add(null);
                    continue;
                }
                if (member.hasDefault()) {
                    v.add(member.getDefaultValue());
                    continue;
                }
                throw new ASN1Exception("Mandatory element \"" + obj.getClass().getName() + "\" was not present in " + this.getClass().getName());
            }
            readtag = in.read();
            if (readtag != 0) {
                throw new ASN1Exception("Indefinite encoding did not end with double 0x00");
            }
        }
        catch (IOException e) {
            throw new ASN1Exception("Could not read from ByteArrayInputStream: " + e.getMessage());
        }
        while (enumerator.hasMoreElements()) {
            SequenceTemplateMember member = (SequenceTemplateMember)enumerator.nextElement();
            if (!member.isOptional()) {
                throw new ASN1Exception("Mandatory element \"" + member.getClazz().getName() + "\" was not present in " + this.getClass().getName());
            }
            v.add(null);
        }
        this.setMembers(v);
    }

    public void encodeValue(OutputStream out) throws ASN1Exception, IOException {
        Enumeration enumerator = this.getTemplate().getTemplate().elements();
        Enumeration enumObjs = this.getMembers().elements();
        while (enumerator.hasMoreElements() && enumObjs.hasMoreElements()) {
            SequenceTemplateMember member = (SequenceTemplateMember)enumerator.nextElement();
            ASN1Object obj = (ASN1Object)enumObjs.nextElement();
            if (member.hasDefault() && obj != null && obj.equals(member.getDefaultValue())) {
                obj = null;
            }
            if (obj != null) {
                ByteArrayOutputStream encodedvalue = new ByteArrayOutputStream();
                try {
                    obj.encodeValue(encodedvalue);
                }
                catch (IOException e) {
                    throw new ASN1Exception("Could not write to ByteArrayOuputStream : " + e.getMessage());
                }
                if (member.isExplicit()) {
                    ByteArrayOutputStream innerencodedvalue = new ByteArrayOutputStream();
                    innerencodedvalue.write(obj.getTag());
                    Sequence.encode_length_octets(innerencodedvalue, encodedvalue.size());
                    innerencodedvalue.write(encodedvalue.toByteArray());
                    encodedvalue = innerencodedvalue;
                }
                if (member.isExplicit()) {
                    out.write(obj.getExplicitTag(member.getTag()));
                } else if (member.isImplicit()) {
                    out.write(obj.getImplicitTag(member.getTag()));
                } else {
                    out.write(obj.getTag());
                }
                Sequence.encode_length_octets(out, encodedvalue.size());
                out.write(encodedvalue.toByteArray());
                continue;
            }
            if (member.isOptional() || member.hasDefault()) continue;
            throw new ASN1Exception("Mandatory element \"" + member.getClazz().getName() + "\" was not present in " + this.getClass().getName());
        }
    }

    public String toString() {
        String result = "{";
        Enumeration enumObjs = this.getMembers().elements();
        Object obj = enumObjs.nextElement();
        result = result + (obj != null ? obj.toString() : "--empty--");
        while (enumObjs.hasMoreElements()) {
            result = result + ", ";
            obj = enumObjs.nextElement();
            result = result + (obj != null ? obj.toString() : "--empty--");
        }
        result = result + "}";
        return result;
    }
}

