/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.CMS;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Integer;
import com.cryptomathic.ASN1.OIDs;
import com.cryptomathic.ASN1.ObjectIdentifier;
import com.cryptomathic.CMS.Content;
import com.cryptomathic.CMS.ContentInfo;
import com.cryptomathic.CMS.SignedData;
import com.cryptomathic.CMS.SignerInfo;
import com.cryptomathic.PKCS12.PFX;
import com.cryptomathic.X509.X509Certificate;
import com.cryptomathic.crypto.hash.HashException;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class CMS {
    private CMS() {
    }

    public static byte[] makeSignedMessage(byte[] message, PrivateKey privateKey, X509Certificate keyCert, X509Certificate[] otherCerts, String algorithm) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, ASN1Exception, HashException {
        SignedData signedData = new SignedData();
        signedData.Sign(privateKey, keyCert, algorithm, new ObjectIdentifier(OIDs.pkcs7_data), message);
        signedData.version = new ASN1Integer(1);
        signedData.addCertificates(otherCerts);
        ContentInfo contentInfo = new ContentInfo();
        contentInfo.contentType = new ObjectIdentifier(OIDs.pkcs7_signedData);
        contentInfo.content = new Content();
        contentInfo.content.value = signedData;
        return contentInfo.encode();
    }

    public static byte[] makeSignedMessage(byte[] message, String pfxFile, String password, String algorithm) throws IOException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, HashException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, ASN1Exception {
        FileInputStream input = new FileInputStream(pfxFile);
        PFX pfx = new PFX();
        pfx.decode(input);
        pfx.decrypt(password);
        PrivateKey privateKey = pfx.getPrivateKey();
        X509Certificate cert = pfx.getKeyCert();
        X509Certificate[] otherCerts = pfx.getOtherCertificates();
        return CMS.makeSignedMessage(message, privateKey, cert, otherCerts, algorithm);
    }

    public static byte[] verifyAndGetContentFromSignedMessage(byte[] message, byte[] signerCertificate) throws ASN1Exception, GeneralSecurityException, HashException {
        ContentInfo contentInfo = new ContentInfo();
        contentInfo.decode(message);
        X509Certificate certificate = new X509Certificate();
        certificate.decode(signerCertificate);
        if (!contentInfo.contentType.equals(OIDs.pkcs7_signedData)) {
            throw new IllegalArgumentException("Message was not signed data");
        }
        SignedData signedData = (SignedData)contentInfo.content.value;
        if (signedData.encapContentInfo.eContent == null) {
            throw new IllegalArgumentException("Detached content is not supported");
        }
        byte[] innerContent = signedData.encapContentInfo.eContent.value;
        if (signedData.signerInfos.size() != 1) {
            throw new IllegalArgumentException("Expected exactly one signer");
        }
        SignerInfo signerInfo = signedData.signerInfos.get(0);
        boolean verified = signerInfo.verify(certificate.getPublicKey(), signedData.encapContentInfo.eContentType, innerContent);
        if (!verified) {
            throw new ASN1Exception("Verification failed");
        }
        return innerContent;
    }
}

