/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.CMS;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.ObjectIdentifier;
import com.cryptomathic.ASN1.OctetString;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.misc.AlgorithmIdentifier;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;

public class EncryptedContentInfo
extends Sequence {
    public ObjectIdentifier contentType;
    public AlgorithmIdentifier contentEncryptionAlgorithmIdentifier;
    public OctetString encryptedContent;

    protected void setMembers(Vector v) throws ASN1Exception {
        this.contentType = (ObjectIdentifier)v.get(0);
        this.contentEncryptionAlgorithmIdentifier = (AlgorithmIdentifier)v.get(1);
        this.encryptedContent = (OctetString)v.get(2);
    }

    protected Vector getMembers() {
        Vector<ASN1Object> v = new Vector<ASN1Object>(3);
        v.add(this.contentType);
        v.add(this.contentEncryptionAlgorithmIdentifier);
        v.add(this.encryptedContent);
        return v;
    }

    public SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(ObjectIdentifier.class);
        template.addMember(AlgorithmIdentifier.class);
        template.addImplicitOptionalMember(OctetString.class, 0);
        return template;
    }

    public void encrypt(byte[] key, String alg, AlgorithmParameterSpec params, byte[] data) throws NoSuchPaddingException, InvalidKeySpecException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        SecretKeySpec keyspec = new SecretKeySpec(key, alg);
        SecretKey secretKey = SecretKeyFactory.getInstance(alg).generateSecret(keyspec);
        Cipher cipher = Cipher.getInstance(alg);
        cipher.init(1, (Key)secretKey, params);
        this.encrypt(secretKey, cipher, data);
    }

    public static EncryptedContentInfo makeEncrypted(byte[] content, ObjectIdentifier contentType, String contentEncryptionAlg, SecretKey contentEncryptionKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, InvalidKeySpecException, IllegalBlockSizeException, BadPaddingException, ASN1Exception, InvalidParameterSpecException {
        EncryptedContentInfo res = new EncryptedContentInfo();
        res.contentType = contentType;
        Cipher contentEncryptionCipher = Cipher.getInstance(contentEncryptionAlg);
        contentEncryptionCipher.init(1, (Key)contentEncryptionKey, (AlgorithmParameterSpec)null);
        res.encrypt(contentEncryptionKey, contentEncryptionCipher, content);
        res.contentEncryptionAlgorithmIdentifier = AlgorithmIdentifier.makeAlgorithm(contentEncryptionCipher);
        return res;
    }

    public void encrypt(SecretKey secretKey, Cipher cipher, byte[] data) throws NoSuchPaddingException, InvalidKeySpecException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        byte[] encrypteddata = cipher.doFinal(data);
        this.encryptedContent = new OctetString(encrypteddata);
    }

    public byte[] decrypt(String password) throws NoSuchPaddingException, InvalidKeySpecException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, ASN1Exception {
        return this.contentEncryptionAlgorithmIdentifier.decrypt(password, this.encryptedContent.value);
    }

    public byte[] decrypt(byte[] contentEncryptionKeyValue) throws ASN1Exception, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        String contentEncryptionAlg = this.contentEncryptionAlgorithmIdentifier.toAlgString();
        String contentEncryptionKeyAlg = contentEncryptionAlg.split("/")[0];
        SecretKeySpec contentEncryptionKey = new SecretKeySpec(contentEncryptionKeyValue, contentEncryptionKeyAlg);
        AlgorithmParameterSpec contentEncryptionAlgParams = this.contentEncryptionAlgorithmIdentifier.toAlgParams();
        Cipher contentEncryptionCipher = Cipher.getInstance(contentEncryptionAlg + "/PKCS5Padding");
        contentEncryptionCipher.init(2, (Key)contentEncryptionKey, contentEncryptionAlgParams);
        byte[] decrypteddata = contentEncryptionCipher.doFinal(this.encryptedContent.value);
        return decrypteddata;
    }
}

