/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.CMS;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Integer;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.OIDs;
import com.cryptomathic.ASN1.ObjectIdentifier;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.CMS.EncryptedContentInfo;
import com.cryptomathic.CMS.KeyTransRecipientInfo;
import com.cryptomathic.CMS.OriginatorInfo;
import com.cryptomathic.CMS.RecipientInfo;
import com.cryptomathic.CMS.RecipientInfos;
import com.cryptomathic.CMS.SignedData;
import com.cryptomathic.PKCS9.Attributes;
import com.cryptomathic.X509.X509Certificate;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class EnvelopedData
extends Sequence {
    public ASN1Integer version;
    public OriginatorInfo originatorInfo;
    public RecipientInfos recipientInfos;
    public EncryptedContentInfo encryptedContentInfo;
    public Attributes unprotectedAttrs;

    protected void setMembers(Vector v) throws ASN1Exception {
        this.version = (ASN1Integer)v.get(0);
        this.originatorInfo = (OriginatorInfo)v.get(1);
        this.recipientInfos = (RecipientInfos)v.get(2);
        this.encryptedContentInfo = (EncryptedContentInfo)v.get(3);
        this.unprotectedAttrs = (Attributes)v.get(4);
    }

    protected Vector getMembers() {
        Vector<ASN1Object> v = new Vector<ASN1Object>(5);
        v.add(this.version);
        v.add(this.originatorInfo);
        v.add(this.recipientInfos);
        v.add(this.encryptedContentInfo);
        v.add(this.unprotectedAttrs);
        return v;
    }

    public SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(ASN1Integer.class);
        template.addImplicitOptionalMember(OriginatorInfo.class, 0);
        template.addMember(RecipientInfos.class);
        template.addMember(EncryptedContentInfo.class);
        template.addImplicitOptionalMember(Attributes.class, 1);
        return template;
    }

    public void encrypt(X509Certificate cert, String contentEncryptionKeyGenerationAlg, String contentEncryptionAlg, String keyEncryptionAlg, byte[] content, ObjectIdentifier contentType) throws NoSuchPaddingException, InvalidKeySpecException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, ASN1Exception, InvalidParameterSpecException {
        this.recipientInfos = new RecipientInfos();
        KeyGenerator keyGenerator = KeyGenerator.getInstance(contentEncryptionKeyGenerationAlg);
        SecretKey contentEncryptionKey = keyGenerator.generateKey();
        KeyTransRecipientInfo ktri = KeyTransRecipientInfo.make(cert, keyEncryptionAlg, contentEncryptionKey);
        this.recipientInfos.add(ktri);
        this.encryptedContentInfo = EncryptedContentInfo.makeEncrypted(content, contentType, contentEncryptionAlg, contentEncryptionKey);
    }

    public void encrypt(X509Certificate cert, String contentEncryptionKeyGenerationAlg, String contentEncryptionAlg, String keyEncryptionAlg, byte[] data) throws NoSuchPaddingException, InvalidKeySpecException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, ASN1Exception, InvalidParameterSpecException {
        this.encrypt(cert, contentEncryptionKeyGenerationAlg, contentEncryptionAlg, keyEncryptionAlg, data, new ObjectIdentifier(OIDs.pkcs7_data));
    }

    public void encrypt(X509Certificate cert, String contentEncryptionKeyGenerationAlg, String contentEncryptionAlg, String keyEncryptionAlg, SignedData signedData) throws NoSuchPaddingException, InvalidKeySpecException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, ASN1Exception, InvalidParameterSpecException {
        this.encrypt(cert, contentEncryptionKeyGenerationAlg, contentEncryptionAlg, keyEncryptionAlg, signedData.encode(), new ObjectIdentifier(OIDs.pkcs7_signedData));
    }

    public byte[] decrypt(PrivateKey key) throws NoSuchPaddingException, InvalidKeySpecException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, ASN1Exception {
        if (this.recipientInfos == null || this.recipientInfos.size() != 1) {
            throw new IllegalStateException("This method expects exactly one RecipientInfo");
        }
        RecipientInfo recipientInfo = this.recipientInfos.get(0);
        if (recipientInfo.getValue().getClass() != KeyTransRecipientInfo.class) {
            throw new IllegalStateException("This method only supports RecipientInfo of type KeyTransrecipientInfo");
        }
        KeyTransRecipientInfo ktri = recipientInfo.ktri;
        byte[] contentEncryptionKeyValue = ktri.decryptContentEncryptionKey(key);
        byte[] decrypteddata = this.encryptedContentInfo.decrypt(contentEncryptionKeyValue);
        return decrypteddata;
    }
}

