/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.CMS;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Integer;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.X509.Name;
import com.cryptomathic.X509.X509Certificate;
import java.util.Vector;

public class IssuerAndSerialNumber
extends Sequence {
    public Name issuer;
    public ASN1Integer serialNumber;

    protected void setMembers(Vector v) throws ASN1Exception {
        this.issuer = (Name)v.get(0);
        this.serialNumber = (ASN1Integer)v.get(1);
    }

    protected Vector getMembers() {
        Vector<ASN1Object> v = new Vector<ASN1Object>(2);
        v.add(this.issuer);
        v.add(this.serialNumber);
        return v;
    }

    public SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(Name.class);
        template.addMember(ASN1Integer.class);
        return template;
    }

    public void set(X509Certificate cert) {
        this.issuer = cert.tbsCertificate.issuer;
        this.serialNumber = cert.tbsCertificate.serialNumber;
    }

    public static IssuerAndSerialNumber fromCertificate(X509Certificate cert) {
        IssuerAndSerialNumber res = new IssuerAndSerialNumber();
        res.set(cert);
        return res;
    }
}

