/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.CMS;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Integer;
import com.cryptomathic.ASN1.ASN1Null;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.OIDs;
import com.cryptomathic.ASN1.OctetString;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.CMS.IssuerAndSerialNumber;
import com.cryptomathic.CMS.RecipientIdentifier;
import com.cryptomathic.X509.X509Certificate;
import com.cryptomathic.misc.AlgorithmIdentifier;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class KeyTransRecipientInfo
extends Sequence {
    public ASN1Integer version;
    public RecipientIdentifier rid;
    public AlgorithmIdentifier keyEncryptionAlgorithm;
    public OctetString encryptedKey;

    protected void setMembers(Vector v) throws ASN1Exception {
        this.version = (ASN1Integer)v.get(0);
        this.rid = (RecipientIdentifier)v.get(1);
        this.keyEncryptionAlgorithm = (AlgorithmIdentifier)v.get(2);
        this.encryptedKey = (OctetString)v.get(3);
    }

    protected Vector getMembers() {
        Vector<ASN1Object> v = new Vector<ASN1Object>(4);
        v.add(this.version);
        v.add(this.rid);
        v.add(this.keyEncryptionAlgorithm);
        v.add(this.encryptedKey);
        return v;
    }

    public SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(ASN1Integer.class);
        template.addMember(RecipientIdentifier.class);
        template.addMember(AlgorithmIdentifier.class);
        template.addMember(OctetString.class);
        return template;
    }

    public byte[] decryptContentEncryptionKey(PrivateKey key) throws InvalidKeyException, ASN1Exception, NoSuchAlgorithmException, NoSuchPaddingException, IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        String keyEncryptionAlg = this.keyEncryptionAlgorithm.toAlgString();
        Cipher keyEncryptionCipher = Cipher.getInstance(keyEncryptionAlg);
        keyEncryptionCipher.init(2, key);
        byte[] contentEncryptionKeyValue = keyEncryptionCipher.doFinal(this.encryptedKey.value);
        return contentEncryptionKeyValue;
    }

    public static KeyTransRecipientInfo make(X509Certificate cert, String keyEncryptionAlg, SecretKey contentEncryptionKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, ASN1Exception {
        PublicKey publicKey = cert.getPublicKey();
        Cipher keyEncryptionCipher = Cipher.getInstance(keyEncryptionAlg);
        keyEncryptionCipher.init(1, publicKey);
        byte[] encryptedContentEncryptionKey = keyEncryptionCipher.doFinal(contentEncryptionKey.getEncoded());
        KeyTransRecipientInfo ktri = new KeyTransRecipientInfo();
        ktri.version = new ASN1Integer(0);
        ktri.rid = new RecipientIdentifier(IssuerAndSerialNumber.fromCertificate(cert));
        ktri.keyEncryptionAlgorithm = AlgorithmIdentifier.makeAlgorithm(OIDs.rsaEncryption, new ASN1Null());
        ktri.encryptedKey = new OctetString(encryptedContentEncryptionKey);
        return ktri;
    }
}

