/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.OCSP;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.BitString;
import com.cryptomathic.ASN1.OIDs;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.OCSP.ResponseData;
import com.cryptomathic.OCSP.SOCertificate;
import com.cryptomathic.crypto.rsa.Pkcs1v1;
import com.cryptomathic.misc.AlgorithmIdentifier;
import com.cryptomathic.security.RSAPublicKey;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;

public class BasicOCSPResponse
extends Sequence {
    public ResponseData tbsResponseData;
    public AlgorithmIdentifier signatureAlgorithm;
    public BitString signature;
    public SOCertificate certs;

    public boolean checkSignature(RSAPublicKey verifyKey) throws ASN1Exception, NoSuchAlgorithmException {
        if (!this.signatureAlgorithm.algorithm.equals(OIDs.sha1withRSAEncryption)) {
            throw new NoSuchAlgorithmException("OCSPResponse signed by use of unsupported algorithm");
        }
        byte[] tbs = this.tbsResponseData.encode();
        return Pkcs1v1.verify(verifyKey, tbs, this.signature.value);
    }

    protected void setMembers(Vector v) throws ASN1Exception {
        this.tbsResponseData = (ResponseData)v.get(0);
        this.signatureAlgorithm = (AlgorithmIdentifier)v.get(1);
        this.signature = (BitString)v.get(2);
        this.certs = (SOCertificate)v.get(3);
    }

    protected Vector getMembers() {
        Vector<ASN1Object> v = new Vector<ASN1Object>(4);
        v.add(this.tbsResponseData);
        v.add(this.signatureAlgorithm);
        v.add(this.signature);
        v.add(this.certs);
        return v;
    }

    protected SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(ResponseData.class);
        template.addMember(AlgorithmIdentifier.class);
        template.addMember(BitString.class);
        template.addExplicitOptionalMember(SOCertificate.class, 0);
        return template;
    }
}

