/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.OCSP;

import com.cryptomathic.ASN1.ASN1Boolean;
import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.OIDs;
import com.cryptomathic.ASN1.ObjectIdentifier;
import com.cryptomathic.ASN1.OctetString;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.OCSP.CertID;
import com.cryptomathic.OCSP.OCSPSignature;
import com.cryptomathic.OCSP.Request;
import com.cryptomathic.OCSP.SORequest;
import com.cryptomathic.OCSP.TBSRequest;
import com.cryptomathic.X509.Extension;
import com.cryptomathic.X509.Extensions;
import com.cryptomathic.X509.X509Certificate;
import com.cryptomathic.crypto.hash.HashException;
import com.cryptomathic.crypto.hash.HashType;
import java.util.Vector;

public class OCSPRequest
extends Sequence {
    public TBSRequest tbsRequest;
    public OCSPSignature optionalSignature;

    public byte[] makeOCSPRequest(X509Certificate X509Cert, HashType hashAlg, byte[] issuerKeyHash, byte[] nonce) throws ASN1Exception, HashException {
        CertID reqCert = new CertID();
        reqCert.setFromCertificates(X509Cert, hashAlg, issuerKeyHash);
        Request request = new Request();
        request.reqCert = reqCert;
        this.tbsRequest = new TBSRequest();
        this.tbsRequest.requestList = new SORequest();
        this.tbsRequest.requestList.add(request);
        if (nonce != null) {
            Extension nonceext = new Extension();
            nonceext.critical = new ASN1Boolean(false);
            nonceext.extnId = new ObjectIdentifier(OIDs.RFC2560_ocspNonce);
            nonceext.extnValue = new OctetString(nonce);
            if (this.tbsRequest.requestExtensions == null) {
                this.tbsRequest.requestExtensions = new Extensions();
            }
            this.tbsRequest.requestExtensions.add(nonceext);
        }
        return this.encode();
    }

    protected void setMembers(Vector v) throws ASN1Exception {
        this.tbsRequest = (TBSRequest)v.get(0);
        this.optionalSignature = (OCSPSignature)v.get(1);
    }

    protected Vector getMembers() {
        Vector<Sequence> v = new Vector<Sequence>(2);
        v.add(this.tbsRequest);
        v.add(this.optionalSignature);
        return v;
    }

    protected SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(TBSRequest.class);
        template.addExplicitOptionalMember(OCSPSignature.class, 0);
        return template;
    }
}

