/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.PKCS12;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.OIDs;
import com.cryptomathic.ASN1.ObjectIdentifier;
import com.cryptomathic.ASN1.OctetString;
import com.cryptomathic.ASN1.SequenceOf;
import com.cryptomathic.CMS.Content;
import com.cryptomathic.CMS.ContentInfo;
import com.cryptomathic.CMS.EncryptedData;
import com.cryptomathic.PKCS12.PBKDFsha;
import com.cryptomathic.PKCS12.SafeBag;
import com.cryptomathic.PKCS12.SafeContents;
import com.cryptomathic.PKCS8.EncryptedPrivateKeyInfo;
import com.cryptomathic.PKCS8.PrivateKeyInfo;
import com.cryptomathic.X509.X509Certificate;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class AuthenticatedSafe
extends SequenceOf {
    protected Class getMemberClass() {
        return ContentInfo.class;
    }

    public ContentInfo get(int index) {
        return (ContentInfo)this.V.get(index);
    }

    public void add(ContentInfo obj) {
        this.V.add(obj);
    }

    public void add(SafeContents data) throws ASN1Exception {
        ContentInfo contentInfo = new ContentInfo();
        contentInfo.contentType = new ObjectIdentifier();
        contentInfo.content = new Content();
        contentInfo.content.value = new OctetString(data.encode());
        contentInfo.contentType = new ObjectIdentifier(OIDs.pkcs7_data);
    }

    public void add(SafeContents data, byte[] password, String alg, int iterations, SecureRandom random) throws InvalidKeyException, NoSuchPaddingException, InvalidKeySpecException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, ASN1Exception {
        ContentInfo contentInfo = new ContentInfo();
        contentInfo.contentType = new ObjectIdentifier();
        byte[] salt = random.generateSeed(20);
        byte[] key = PBKDFsha.PBKDF(password, salt, 0, iterations, 20);
        EncryptedData encryptedData = new EncryptedData();
        encryptedData.encrypt(key, alg, null, data.encode());
        contentInfo.content = new Content();
        contentInfo.content.value = encryptedData;
        contentInfo.contentType = new ObjectIdentifier(OIDs.pkcs7_encryptedData);
    }

    public void add(PrivateKeyInfo privateKeyInfo, byte[] password, String alg, int iterations, SecureRandom random) throws ASN1Exception, InvalidKeyException, NoSuchPaddingException, InvalidKeySpecException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        SafeContents safeContents = new SafeContents();
        SafeBag safeBag = new SafeBag();
        safeBag.set(privateKeyInfo);
        safeContents.add(safeBag);
        this.add(safeContents, password, alg, iterations, random);
    }

    public void add(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo) throws ASN1Exception {
        SafeContents safeContents = new SafeContents();
        SafeBag safeBag = new SafeBag();
        safeBag.set(encryptedPrivateKeyInfo);
        safeContents.add(safeBag);
        this.add(safeContents);
    }

    public void add(X509Certificate cert, byte[] password, String alg, int iterations, SecureRandom random) throws InvalidKeyException, NoSuchPaddingException, InvalidKeySpecException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, ASN1Exception {
        SafeContents safeContents = new SafeContents();
        SafeBag safeBag = new SafeBag();
        safeBag.set(cert);
        safeContents.add(safeBag);
        this.add(safeContents, password, alg, iterations, random);
    }
}

