/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.PKCS12;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Integer;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.OIDs;
import com.cryptomathic.ASN1.OctetString;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.CMS.ContentInfo;
import com.cryptomathic.CMS.EncryptedData;
import com.cryptomathic.PKCS12.AuthenticatedSafe;
import com.cryptomathic.PKCS12.CertBag;
import com.cryptomathic.PKCS12.MacData;
import com.cryptomathic.PKCS12.SafeBag;
import com.cryptomathic.PKCS12.SafeContents;
import com.cryptomathic.PKCS8.EncryptedPrivateKeyInfo;
import com.cryptomathic.X509.X509Certificate;
import com.cryptomathic.crypto.hash.HashException;
import com.cryptomathic.util.ByteArray;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class PFX
extends Sequence {
    public ASN1Integer version;
    public ContentInfo authSafe;
    public MacData macData;
    protected PrivateKey privateKey;
    protected X509Certificate keyCert;
    protected Vector certificates;
    protected Vector otherCertificates;
    protected byte[] localKeyId;

    protected void setMembers(Vector v) throws ASN1Exception {
        this.version = (ASN1Integer)v.get(0);
        this.authSafe = (ContentInfo)v.get(1);
        this.macData = (MacData)v.get(2);
    }

    protected Vector getMembers() {
        Vector<ASN1Object> v = new Vector<ASN1Object>(3);
        v.add(this.version);
        v.add(this.authSafe);
        v.add(this.macData);
        return v;
    }

    public SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(ASN1Integer.class);
        template.addMember(ContentInfo.class);
        template.addOptionalMember(MacData.class);
        return template;
    }

    public void decrypt(String password) throws HashException, InvalidKeyException, InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, ASN1Exception {
        SafeContents safeContents;
        ContentInfo contentInfo;
        int i;
        if (!this.authSafe.contentType.equals(OIDs.pkcs7_data)) {
            throw new ASN1Exception("authSafe was not of type 'data'");
        }
        OctetString data = (OctetString)this.authSafe.content.value;
        this.macData.verify(data.value, password);
        AuthenticatedSafe authenticatedSafe = new AuthenticatedSafe();
        authenticatedSafe.decode(data.value);
        for (i = 0; i < authenticatedSafe.size(); ++i) {
            contentInfo = authenticatedSafe.get(i);
            if (!contentInfo.contentType.equals(OIDs.pkcs7_data)) continue;
            OctetString octetString = (OctetString)contentInfo.content.value;
            safeContents = new SafeContents();
            safeContents.decode(octetString.value);
            if (safeContents.size() != 1) {
                throw new ASN1Exception("safeContents contained none or multiple SafeBags");
            }
            SafeBag safeBag = safeContents.get(0);
            if (!safeBag.bagId.equals(OIDs.pkcs12_PKCS8ShroudedKeyBag)) {
                throw new ASN1Exception("plaintext SafeBag did not contain PKCS8ShroudedKeyBag");
            }
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = (EncryptedPrivateKeyInfo)safeBag.bagValue.value;
            this.privateKey = encryptedPrivateKeyInfo.getPrivateKey(password);
            this.localKeyId = safeBag.getLocalKeyID();
        }
        for (i = 0; i < authenticatedSafe.size(); ++i) {
            contentInfo = authenticatedSafe.get(i);
            if (!contentInfo.contentType.equals(OIDs.pkcs7_encryptedData)) continue;
            EncryptedData encryptedData = (EncryptedData)contentInfo.content.value;
            safeContents = new SafeContents();
            safeContents.decode(encryptedData.decrypt(password));
            this.certificates = new Vector();
            this.otherCertificates = new Vector();
            for (int j = 0; j < safeContents.size(); ++j) {
                SafeBag safeBag = safeContents.get(j);
                if (!safeBag.bagId.equals(OIDs.pkcs12_certBag)) {
                    throw new ASN1Exception("encryptedData SafeBag did not contain certBag");
                }
                CertBag certBag = (CertBag)safeBag.bagValue.value;
                if (!certBag.certId.equals(OIDs.pkcs12_x509Certificate)) {
                    throw new ASN1Exception("CertBag did not contain X509Certificate");
                }
                X509Certificate cert = new X509Certificate();
                OctetString certValue = (OctetString)certBag.certValue.value;
                cert.decode(certValue.value);
                this.certificates.add(cert);
                if (ByteArray.equals(this.localKeyId, safeBag.getLocalKeyID())) {
                    this.keyCert = cert;
                    continue;
                }
                this.otherCertificates.add(cert);
            }
        }
    }

    public PrivateKey getPrivateKey() throws ASN1Exception {
        if (this.privateKey == null) {
            throw new ASN1Exception("Not decrypted");
        }
        return this.privateKey;
    }

    public X509Certificate getKeyCert() throws ASN1Exception {
        if (this.keyCert == null) {
            throw new ASN1Exception("Not decrypted");
        }
        return this.keyCert;
    }

    public X509Certificate[] getCertificates() throws ASN1Exception {
        if (this.certificates == null) {
            throw new ASN1Exception("Not decrypted");
        }
        X509Certificate[] res = new X509Certificate[this.certificates.size()];
        return this.certificates.toArray(res);
    }

    public X509Certificate[] getOtherCertificates() throws ASN1Exception {
        if (this.certificates == null) {
            throw new ASN1Exception("Not decrypted");
        }
        X509Certificate[] res = new X509Certificate[this.otherCertificates.size()];
        return this.otherCertificates.toArray(res);
    }
}

