/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.PKCS12;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.PKCS12.PFX;
import com.cryptomathic.crypto.hash.HashException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class PKCS12KeyStore
extends KeyStoreSpi {
    private Hashtable certs;
    private Hashtable keys;

    public Enumeration engineAliases() {
        Hashtable table = new Hashtable();
        Enumeration enumerator = this.certs.keys();
        while (enumerator.hasMoreElements()) {
            table.put(enumerator.nextElement(), "Certificate");
        }
        enumerator = this.keys.keys();
        while (enumerator.hasMoreElements()) {
            String a = (String)enumerator.nextElement();
            if (table.get(a) != null) continue;
            table.put(a, "Key");
        }
        return table.keys();
    }

    public boolean engineContainsAlias(String alias) {
        return this.certs.get(alias) != null || this.keys.get(alias) != null;
    }

    public void engineDeleteEntry(String alias) throws KeyStoreException {
    }

    public Certificate engineGetCertificate(String alias) {
        return (Certificate)this.certs.get(alias);
    }

    public String engineGetCertificateAlias(Certificate cert) {
        return null;
    }

    public Certificate[] engineGetCertificateChain(String alias) {
        return null;
    }

    public Date engineGetCreationDate(String alias) {
        return null;
    }

    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        return (Key)this.keys.get(alias);
    }

    public boolean engineIsCertificateEntry(String alias) {
        return this.certs.get(alias) != null;
    }

    public boolean engineIsKeyEntry(String alias) {
        return this.keys.get(alias) != null;
    }

    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        PFX pfx = new PFX();
        try {
            pfx.decode(stream);
            pfx.decrypt(new String(password));
            PrivateKey privateKey = pfx.getPrivateKey();
            this.keys = new Hashtable();
            this.keys.put("key", privateKey);
        }
        catch (InvalidKeyException e1) {
            throw new IOException(e1.getMessage());
        }
        catch (InvalidKeySpecException e1) {
            throw new IOException(e1.getMessage());
        }
        catch (NoSuchAlgorithmException e1) {
            throw new IOException(e1.getMessage());
        }
        catch (NoSuchPaddingException e1) {
            throw new IOException(e1.getMessage());
        }
        catch (InvalidAlgorithmParameterException e1) {
            throw new IOException(e1.getMessage());
        }
        catch (IllegalStateException e1) {
            throw new IOException(e1.getMessage());
        }
        catch (IllegalBlockSizeException e1) {
            throw new IOException(e1.getMessage());
        }
        catch (BadPaddingException e1) {
            throw new IOException(e1.getMessage());
        }
        catch (HashException e1) {
            throw new IOException(e1.getMessage());
        }
        catch (ASN1Exception e1) {
            throw new IOException(e1.getMessage());
        }
    }

    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
    }

    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
    }

    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
    }

    public int engineSize() {
        return 0;
    }

    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
    }
}

