/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.PKCS12;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.OIDs;
import com.cryptomathic.ASN1.ObjectIdentifier;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.ASN1.SequenceTemplateMember;
import com.cryptomathic.PKCS12.BagValue;
import com.cryptomathic.PKCS8.EncryptedPrivateKeyInfo;
import com.cryptomathic.PKCS8.PrivateKeyInfo;
import com.cryptomathic.PKCS9.Attribute;
import com.cryptomathic.PKCS9.Attributes;
import com.cryptomathic.PKCS9.SetOfOctetString;
import com.cryptomathic.X509.X509Certificate;
import java.util.Vector;

public class SafeBag
extends Sequence {
    public ObjectIdentifier bagId;
    public BagValue bagValue;
    public Attributes bagAttributes;

    protected void setMembers(Vector v) throws ASN1Exception {
        this.bagId = (ObjectIdentifier)v.get(0);
        this.bagValue = (BagValue)v.get(1);
        this.bagAttributes = (Attributes)v.get(2);
    }

    protected Vector getMembers() {
        Vector<ASN1Object> v = new Vector<ASN1Object>(3);
        v.add(this.bagId);
        v.add(this.bagValue);
        v.add(this.bagAttributes);
        return v;
    }

    public SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(ObjectIdentifier.class);
        SequenceTemplateMember member = new SequenceTemplateMember(BagValue.class, 0, true, false);
        member.setAnyDefinedBy(0);
        template.addMember(member);
        template.addOptionalMember(Attributes.class);
        return template;
    }

    public void set(PrivateKeyInfo privateKeyInfo) {
        this.bagId = new ObjectIdentifier(OIDs.pkcs12_keyBag);
        this.bagValue.set(privateKeyInfo);
    }

    public void set(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo) {
        this.bagId = new ObjectIdentifier(OIDs.pkcs12_PKCS8ShroudedKeyBag);
        this.bagValue.set(encryptedPrivateKeyInfo);
    }

    public void set(X509Certificate cert) {
        this.bagId = new ObjectIdentifier(OIDs.pkcs12_certBag);
        this.bagValue.set(cert);
    }

    public byte[] getLocalKeyID() throws ASN1Exception {
        if (this.bagAttributes == null) {
            return null;
        }
        Attribute localKeyIdAttr = this.bagAttributes.findFirst(OIDs.pkcs12_localKeyId);
        if (localKeyIdAttr == null) {
            return null;
        }
        SetOfOctetString IDs = (SetOfOctetString)localKeyIdAttr.attrValues.value;
        if (IDs.size() != 1) {
            throw new ASN1Exception("SetOfOctetString contained zero or multiple values");
        }
        return IDs.get((int)0).value;
    }
}

