/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.PKCS8;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.OctetString;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.PKCS8.PrivateKeyInfo;
import com.cryptomathic.misc.AlgorithmIdentifier;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class EncryptedPrivateKeyInfo
extends Sequence {
    public AlgorithmIdentifier encryptionAlgorithm;
    public OctetString encryptedData;

    protected void setMembers(Vector v) throws ASN1Exception {
        this.encryptionAlgorithm = (AlgorithmIdentifier)v.get(0);
        this.encryptedData = (OctetString)v.get(1);
    }

    protected Vector getMembers() {
        Vector<ASN1Object> v = new Vector<ASN1Object>(2);
        v.add(this.encryptionAlgorithm);
        v.add(this.encryptedData);
        return v;
    }

    public SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(AlgorithmIdentifier.class);
        template.addMember(OctetString.class);
        return template;
    }

    public PrivateKey getPrivateKey(String password) throws InvalidKeyException, InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, ASN1Exception {
        byte[] privateKeyInfoValue = this.encryptionAlgorithm.decrypt(password, this.encryptedData.value);
        PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo();
        privateKeyInfo.decode(privateKeyInfoValue);
        return privateKeyInfo.getPrivateKey();
    }
}

