/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.TST;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.GeneralizedTime;
import com.cryptomathic.ASN1.OIDs;
import com.cryptomathic.ASN1.ObjectIdentifier;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.CMS.ContentInfo;
import com.cryptomathic.CMS.SignedData;
import com.cryptomathic.TST.PKIStatusInfo;
import com.cryptomathic.TST.TSTInfo;
import com.cryptomathic.TST.TimeStampReq;
import com.cryptomathic.X509.X509Certificate;
import com.cryptomathic.crypto.hash.HashException;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.util.Vector;

public class TimeStampResp
extends Sequence {
    public PKIStatusInfo status;
    public ContentInfo timeStampToken;

    protected Vector getMembers() {
        Vector<Sequence> v = new Vector<Sequence>(2);
        v.add(this.status);
        v.add(this.timeStampToken);
        return v;
    }

    protected SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(PKIStatusInfo.class);
        template.addOptionalMember(ContentInfo.class);
        return template;
    }

    protected void setMembers(Vector v) throws ASN1Exception {
        this.status = (PKIStatusInfo)v.get(0);
        this.timeStampToken = (ContentInfo)v.get(1);
    }

    public ResponseCheck checkWith(TimeStampReq request, GeneralizedTime maxToleratedTime, X509Certificate tsaCert, ObjectIdentifier[] acceptedPolicies) throws ASN1Exception, GeneralSecurityException, ParseException, HashException {
        if (request == null) {
            throw new ASN1Exception("TimeStampReq is missing");
        }
        if (maxToleratedTime == null) {
            throw new ASN1Exception("maxToleratedTime is missing");
        }
        int status = this.status.status.getInteger();
        if (status != 0 && status != 1) {
            return ResponseCheck.CHECK_NOT_GRANTED;
        }
        if (this.timeStampToken == null) {
            throw new ASN1Exception("TimeStampToken is missing in response");
        }
        if (!this.timeStampToken.contentType.equals(OIDs.pkcs7_signedData)) {
            throw new ASN1Exception("TimeStampToken doesn't contains SignedData. Instead it conatins:" + this.timeStampToken.contentType);
        }
        SignedData signedData = (SignedData)this.timeStampToken.content.value;
        if (!signedData.encapContentInfo.eContentType.equals(OIDs.id_smime_ct_tstinfo)) {
            throw new ASN1Exception("SignedData doesn't contain TimeStampInfo");
        }
        TSTInfo tstInfo = new TSTInfo();
        tstInfo.decode(signedData.encapContentInfo.eContent.value);
        if (!request.messageImprint.equals(tstInfo.messageImprint)) {
            return ResponseCheck.CHECK_WRONG_HASH;
        }
        if (request.nonce != null) {
            if (tstInfo.nonce == null) {
                return ResponseCheck.CHECK_WRONG_NONCE;
            }
            if (!request.nonce.equals(tstInfo.nonce)) {
                return ResponseCheck.CHECK_WRONG_NONCE;
            }
        }
        if (request.certReq != null) {
            if (request.certReq.value) {
                if (signedData.certificates.size() == 0) {
                    return ResponseCheck.CHECK_NO_TSACERT;
                }
                if (signedData.certificates.size() != 1) {
                    return ResponseCheck.CHECK_UNEXPECTED_TSACERT;
                }
            } else if (signedData.certificates != null && signedData.certificates.size() != 0) {
                return ResponseCheck.CHECK_UNEXPECTED_TSACERT;
            }
        }
        if (request.extensions != null) {
            if (tstInfo.extensions != null) {
                return ResponseCheck.CHECK_UNEXPECTED_EXT;
            }
            if (!request.extensions.equals(tstInfo.extensions)) {
                return ResponseCheck.CHECK_UNEXPECTED_EXT;
            }
        }
        if (request.reqPolicy != null) {
            if (tstInfo.policy == null) {
                return ResponseCheck.CHECK_WRONG_POLICY;
            }
            if (!request.reqPolicy.equals(tstInfo.policy)) {
                return ResponseCheck.CHECK_WRONG_POLICY;
            }
        }
        if (acceptedPolicies != null) {
            if (tstInfo.policy == null) {
                return ResponseCheck.CHECK_UNACCEPTED_POLICY;
            }
            boolean isPolicyAccepted = false;
            for (int i = 0; i < acceptedPolicies.length; ++i) {
                if (!acceptedPolicies[i].equals(tstInfo.policy)) continue;
                isPolicyAccepted = true;
                break;
            }
            if (!isPolicyAccepted) {
                return ResponseCheck.CHECK_UNACCEPTED_POLICY;
            }
        }
        tstInfo.genTime.checkDER();
        if (!tstInfo.genTime.before(maxToleratedTime)) {
            return ResponseCheck.CHECK_TOO_LATE_TIME;
        }
        if (!signedData.signerInfos.get(0).verify(tsaCert.getPublicKey(), signedData.encapContentInfo.eContentType, signedData.encapContentInfo.eContent.value)) {
            return ResponseCheck.CHECK_INVALID_SIGNATURE;
        }
        return ResponseCheck.CHECK_OK;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResponseCheck {
        CHECK_OK,
        CHECK_NOT_GRANTED,
        CHECK_WRONG_HASH,
        CHECK_WRONG_NONCE,
        CHECK_NO_TSACERT,
        CHECK_UNEXPECTED_TSACERT,
        CHECK_UNEXPECTED_EXT,
        CHECK_WRONG_POLICY,
        CHECK_UNACCEPTED_POLICY,
        CHECK_TOO_LATE_TIME,
        CHECK_INVALID_SIGNATURE,
        CHECK_INVALID_DATE;

    }
}

