/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.X509;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.Any;
import com.cryptomathic.ASN1.IA5String;
import com.cryptomathic.ASN1.OIDs;
import com.cryptomathic.ASN1.ObjectIdentifier;
import com.cryptomathic.ASN1.PrintableString;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.X509.AttributeValue;
import com.cryptomathic.X509.DirectoryString;
import com.cryptomathic.util.ByteArray;
import java.util.Vector;

public class AttributeTypeAndValue
extends Sequence {
    public ObjectIdentifier type;
    public AttributeValue value;

    protected void setMembers(Vector v) throws ASN1Exception {
        this.type = (ObjectIdentifier)v.get(0);
        this.value = (AttributeValue)v.get(1);
    }

    protected Vector getMembers() {
        Vector<ASN1Object> v = new Vector<ASN1Object>(2);
        v.add(this.type);
        v.add(this.value);
        return v;
    }

    public SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(ObjectIdentifier.class);
        template.addAnyDefinedByMember(AttributeValue.class, 0);
        return template;
    }

    public static AttributeTypeAndValue fromLdapString(String ldapString) {
        AttributeTypeAndValue res = new AttributeTypeAndValue();
        res.setFromLdapString(ldapString);
        return res;
    }

    public void setFromLdapString(String ldapString) {
        String[] components = ldapString.split("=");
        if (components.length != 2) {
            throw new IllegalArgumentException("Badly formed component: " + ldapString);
        }
        String type = components[0].trim();
        String value = components[1].trim();
        if ("CN".equals(type)) {
            this.type = new ObjectIdentifier(OIDs.id_at_commonName);
            this.value = new AttributeValue(new DirectoryString(value));
        } else if ("S".equals(type)) {
            this.type = new ObjectIdentifier(OIDs.id_at_surname);
            this.value = new AttributeValue(new DirectoryString(value));
        } else if ("SN".equals(type)) {
            this.type = new ObjectIdentifier(OIDs.id_at_serialNumber);
            this.value = new AttributeValue(new PrintableString(value));
        } else if ("C".equals(type)) {
            this.type = new ObjectIdentifier(OIDs.id_at_countryName);
            this.value = new AttributeValue(new PrintableString(value));
        } else if ("L".equals(type)) {
            this.type = new ObjectIdentifier(OIDs.id_at_localityName);
            this.value = new AttributeValue(new DirectoryString(value));
        } else if ("ST".equals(type)) {
            this.type = new ObjectIdentifier(OIDs.id_at_stateOrProvinceName);
            this.value = new AttributeValue(new DirectoryString(value));
        } else if ("O".equals(type)) {
            this.type = new ObjectIdentifier(OIDs.id_at_organizationName);
            this.value = new AttributeValue(new DirectoryString(value));
        } else if ("OU".equals(type)) {
            this.type = new ObjectIdentifier(OIDs.id_at_organizationalUnitName);
            this.value = new AttributeValue(new DirectoryString(value));
        } else if ("T".equals(type)) {
            this.type = new ObjectIdentifier(OIDs.id_at_title);
            this.value = new AttributeValue(new DirectoryString(value));
        } else if ("N".equals(type)) {
            this.type = new ObjectIdentifier(OIDs.id_at_name);
            this.value = new AttributeValue(new DirectoryString(value));
        } else if ("G".equals(type)) {
            this.type = new ObjectIdentifier(OIDs.id_at_givenName);
            this.value = new AttributeValue(new DirectoryString(value));
        } else if ("I".equals(type)) {
            this.type = new ObjectIdentifier(OIDs.id_at_initials);
            this.value = new AttributeValue(new DirectoryString(value));
        } else if ("Email".equals(type)) {
            this.type = new ObjectIdentifier(OIDs.pkcs9_emailAddress);
            this.value = new AttributeValue(new IA5String(value));
        } else {
            try {
                this.type = new ObjectIdentifier(type);
            }
            catch (ASN1Exception e) {
                throw new IllegalArgumentException(e);
            }
            this.value = new AttributeValue(new DirectoryString(value));
        }
    }

    public static final String type2string(ObjectIdentifier type) {
        byte[] value = type.value;
        if (ByteArray.equals(value, OIDs.id_at_commonName)) {
            return "CN";
        }
        if (ByteArray.equals(value, OIDs.id_at_surname)) {
            return "S";
        }
        if (ByteArray.equals(value, OIDs.id_at_serialNumber)) {
            return "SN";
        }
        if (ByteArray.equals(value, OIDs.id_at_countryName)) {
            return "C";
        }
        if (ByteArray.equals(value, OIDs.id_at_localityName)) {
            return "L";
        }
        if (ByteArray.equals(value, OIDs.id_at_stateOrProvinceName)) {
            return "ST";
        }
        if (ByteArray.equals(value, OIDs.id_at_organizationName)) {
            return "O";
        }
        if (ByteArray.equals(value, OIDs.id_at_organizationalUnitName)) {
            return "OU";
        }
        if (ByteArray.equals(value, OIDs.id_at_title)) {
            return "T";
        }
        if (ByteArray.equals(value, OIDs.id_at_name)) {
            return "N";
        }
        if (ByteArray.equals(value, OIDs.id_at_givenName)) {
            return "G";
        }
        if (ByteArray.equals(value, OIDs.id_at_initials)) {
            return "I";
        }
        if (ByteArray.equals(value, OIDs.pkcs9_emailAddress)) {
            return "Email";
        }
        return type.toString();
    }

    public String toString() {
        if (this.value.value instanceof Any) {
            Any any = (Any)this.value.value;
            return AttributeTypeAndValue.type2string(this.type) + "=" + new String(any.value);
        }
        return AttributeTypeAndValue.type2string(this.type) + "=" + this.value.toString();
    }
}

