/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.X509;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.BitString;
import com.cryptomathic.ASN1.OIDs;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.PKCS1.RSAPublicKey;
import com.cryptomathic.misc.AlgorithmIdentifier;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Vector;

public class SubjectPublicKeyInfo
extends Sequence {
    public AlgorithmIdentifier algorithm;
    public BitString subjectPublicKey;

    protected void setMembers(Vector v) throws ASN1Exception {
        this.algorithm = (AlgorithmIdentifier)v.get(0);
        this.subjectPublicKey = (BitString)v.get(1);
    }

    protected Vector getMembers() {
        Vector<ASN1Object> v = new Vector<ASN1Object>(2);
        v.add(this.algorithm);
        v.add(this.subjectPublicKey);
        return v;
    }

    public SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(AlgorithmIdentifier.class);
        template.addOptionalMember(BitString.class);
        return template;
    }

    public PublicKey getKey() throws ASN1Exception {
        if (this.algorithm.algorithm.equals(OIDs.rsaEncryption)) {
            PublicKey key;
            RSAPublicKey ASN1Key = new RSAPublicKey();
            ASN1Key.decode(this.subjectPublicKey.getAsByteString());
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(ASN1Key.modulus.getBigInteger(), ASN1Key.publicExponent.getBigInteger());
            try {
                key = KeyFactory.getInstance("RSA").generatePublic(keySpec);
            }
            catch (InvalidKeySpecException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            return key;
        }
        throw new ASN1Exception("Unknown keytype (" + this.algorithm.algorithm + ")");
    }
}

