/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.common.utils;

public abstract class ByteArrays {
    public static byte[] extract(byte[] byArray, int n, int n2) {
        if (n < 0) {
            n2 += n;
            n = 0;
        }
        if (n > byArray.length) {
            n = byArray.length;
        }
        byte[] byArray2 = new byte[Math.min(byArray.length - n, n2)];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public static byte[] extract(byte[] byArray, int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > byArray.length) {
            n = byArray.length;
        }
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public static byte[] resize(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, n));
        return byArray2;
    }

    public static byte[] padAtLeft(byte[] byArray, int n) {
        if (byArray.length >= n) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, byArray2.length - byArray.length, byArray.length);
        return byArray2;
    }

    public static byte[] copy(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static byte[] concat(byte[] ... byArray) {
        int n = 0;
        for (byte[] byArray2 : byArray) {
            if (byArray2 == null) continue;
            n += byArray2.length;
        }
        byte[] byArray3 = new byte[n];
        int n2 = 0;
        for (byte[] byArray4 : byArray) {
            if (byArray4 == null) continue;
            System.arraycopy(byArray4, 0, byArray3, n2, byArray4.length);
            n2 += byArray4.length;
        }
        return byArray3;
    }

    public static byte[] xor(byte[] byArray, byte[] ... byArray2) throws IllegalArgumentException {
        byte[] byArray3 = ByteArrays.copy(byArray);
        for (byte[] byArray4 : byArray2) {
            if (byArray4.length != byArray3.length) {
                throw new IllegalArgumentException("Cannot XOR byte-arrays of different lengths: " + byArray3.length + " and " + byArray4.length);
            }
            for (int i = 0; i < byArray4.length; ++i) {
                int n = i;
                byArray3[n] = (byte)(byArray3[n] ^ byArray4[i]);
            }
        }
        return byArray3;
    }
}

