/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.common.utils;

import com.cryptomathic.common.utils.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;

public class ProcessRunner {
    private final String executableFilePath;
    private Process process = null;
    private String fixedArgs = null;
    private InputStream processOut = null;
    private InputStream processErr = null;
    private ProcessStreamReader processOutReader = null;
    private ProcessStreamReader processErrReader = null;
    private boolean verboseOutput = false;

    public ProcessRunner(String string, String ... stringArray) {
        this.executableFilePath = string;
        this.fixedArgs = StringUtils.join(Arrays.asList(stringArray), " ");
    }

    public void setVerboseOutput(boolean bl) {
        this.verboseOutput = bl;
    }

    private void printMessage(String string) {
        if (this.verboseOutput) {
            System.out.println(string);
        }
    }

    public void start(String ... stringArray) throws Exception {
        this.start(5, stringArray);
    }

    public void start(int n, String ... stringArray) throws Exception {
        DefaultProcessStreamProcessor defaultProcessStreamProcessor = new DefaultProcessStreamProcessor("Process stdout: ");
        DefaultProcessStreamProcessor defaultProcessStreamProcessor2 = new DefaultProcessStreamProcessor("Process stderr: ");
        this.start(n, defaultProcessStreamProcessor, defaultProcessStreamProcessor2, stringArray);
    }

    public void start(int n, ProcessStreamProcessor processStreamProcessor, ProcessStreamProcessor processStreamProcessor2, String ... stringArray) throws Exception {
        String string = StringUtils.join(Arrays.asList(stringArray), " ");
        String string2 = this.executableFilePath + " " + this.fixedArgs + " " + string;
        this.printMessage("ProcessRunner commandline: " + string2);
        this.process = Runtime.getRuntime().exec(string2);
        this.processOut = this.process.getInputStream();
        this.processOutReader = new ProcessStreamReader(this.processOut, processStreamProcessor);
        this.processOutReader.setVerboseOutput(this.verboseOutput);
        this.processOutReader.start();
        this.processErr = this.process.getErrorStream();
        this.processErrReader = new ProcessStreamReader(this.processErr, processStreamProcessor2);
        this.processOutReader.setVerboseOutput(this.verboseOutput);
        this.processErrReader.start();
        if (n > 0) {
            this.printMessage("Process started - sleeping " + n + " seconds");
            Thread.sleep(n * 1000);
            this.printMessage("Sleep over");
        } else {
            this.printMessage("Process started - no delay");
        }
    }

    public void stop() {
        this.printMessage("Stopping process");
        if (this.isRunning()) {
            this.kill();
        }
        this.printMessage("Process stopped");
    }

    public boolean isRunning() {
        try {
            int n = this.process.exitValue();
            this.printMessage("Process stopped with exit code: " + n);
            this.processOut.close();
            this.processErr.close();
            return false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
        catch (IOException iOException) {
            this.printMessage("Failed to close process readers after process has stopped");
            return false;
        }
    }

    public void kill() {
        this.process.destroy();
        try {
            this.process.waitFor();
            this.processOut.close();
            this.processErr.close();
        }
        catch (InterruptedException interruptedException) {
            this.printMessage("Shutdown of process was interrupted");
        }
        catch (IOException iOException) {
            this.printMessage("Failed to close process readers");
        }
    }

    public int run() throws Exception {
        return this.run("");
    }

    public int run(String ... stringArray) throws Exception {
        DefaultProcessStreamProcessor defaultProcessStreamProcessor = new DefaultProcessStreamProcessor("Process stdout: ");
        DefaultProcessStreamProcessor defaultProcessStreamProcessor2 = new DefaultProcessStreamProcessor("Process stderr: ");
        return this.run(defaultProcessStreamProcessor, defaultProcessStreamProcessor2, stringArray);
    }

    public int run(ProcessStreamProcessor processStreamProcessor, ProcessStreamProcessor processStreamProcessor2, String ... stringArray) throws Exception {
        this.start(0, processStreamProcessor, processStreamProcessor2, stringArray);
        int n = this.process.waitFor();
        this.processOut.close();
        this.processErr.close();
        this.printMessage("Process stopped with exit code: " + n);
        return n;
    }

    private static class ProcessStreamReader
    extends Thread {
        private final BufferedReader reader;
        private final ProcessStreamProcessor processor;
        private boolean verboseOutput = false;

        public void setVerboseOutput(boolean bl) {
            this.verboseOutput = bl;
        }

        private void printMessage(String string) {
            if (this.verboseOutput) {
                System.out.println(string);
            }
        }

        public ProcessStreamReader(InputStream inputStream, ProcessStreamProcessor processStreamProcessor) {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            this.reader = new BufferedReader(inputStreamReader);
            this.processor = processStreamProcessor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String string = null;
            this.printMessage("ProcessStreamReader started");
            try {
                while ((string = this.reader.readLine()) != null) {
                    this.processor.processLine(string);
                }
            }
            catch (IOException iOException) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                iOException.printStackTrace(printWriter);
                this.printMessage(stringWriter.toString());
            }
            finally {
                this.printMessage("ProcessStreamReader stopped");
            }
        }
    }

    public static class SimpleProcessStreamProcessor
    implements ProcessStreamProcessor {
        private String output;

        public void processLine(String string) {
            this.output = this.output + "\n" + string;
        }

        public String getOutput() {
            return this.output;
        }
    }

    public static class DefaultProcessStreamProcessor
    implements ProcessStreamProcessor {
        private final String prefix;

        public DefaultProcessStreamProcessor(String string) {
            this.prefix = string;
        }

        public void processLine(String string) {
            DefaultProcessStreamProcessor.copyToOutput(this.prefix, string);
        }

        private static synchronized void copyToOutput(String string, String string2) {
            System.out.print(string);
            System.out.println(string2);
        }
    }

    public static interface ProcessStreamProcessor {
        public void processLine(String var1);
    }
}

