/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.common.utils;

import com.cryptomathic.common.utils.FileUtils;
import com.cryptomathic.common.utils.Hex;
import com.cryptomathic.common.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyReader {
    private final Properties props;
    private final String propsKind;

    public PropertyReader(String string, Class<? extends Object> clazz) throws IllegalArgumentException {
        block4: {
            this.props = new Properties();
            try {
                File file = new File(string);
                InputStream inputStream = clazz.getResourceAsStream("/" + string);
                if (file.exists()) {
                    this.props.load(new FileInputStream(file));
                    this.propsKind = "Properties read from local file: " + string;
                    break block4;
                }
                if (inputStream != null) {
                    this.props.load(inputStream);
                    this.propsKind = "Properties read from resources: /" + string;
                    break block4;
                }
                throw new Exception("");
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Cannot find or load properties from local file or resource: " + string + " [" + exception.getMessage() + "]");
            }
        }
    }

    public PropertyReader(File file) {
        this.props = new Properties();
        try {
            this.props.load(new FileInputStream(file));
            this.propsKind = "Properties read from file: " + file.getName();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot find or load properties from file: " + file.getName() + " [" + exception.getMessage() + "]");
        }
    }

    public PropertyReader(Properties properties) {
        this.props = properties;
        this.propsKind = "Properties provided in constructor";
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getPropertiesMessage() {
        return this.propsKind;
    }

    public String readAsString(String string, String string2) {
        return this.props.getProperty(string, string2);
    }

    public int readAsInteger(String string, int n) throws IllegalArgumentException {
        String string2 = this.props.getProperty(string, "" + n);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Failed to read property '" + string + "' as an integer: " + string2);
        }
    }

    public boolean readAsBoolean(String string, boolean bl) throws IllegalArgumentException {
        String string2 = this.props.getProperty(string, "" + bl);
        return Boolean.parseBoolean(string2);
    }

    public byte[] readAsHex(String string, String string2) throws IllegalArgumentException {
        String string3 = this.props.getProperty(string, string2);
        try {
            return Hex.decode(string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Failed to read property '" + string + "' as a hex string: " + string3);
        }
    }

    public int readAsDuration(String string, String string2) throws IllegalArgumentException {
        int n;
        int n2;
        String string3 = this.props.getProperty(string, string2);
        if (string3.equals("0")) {
            return 0;
        }
        if (string3.endsWith("s")) {
            n2 = 1;
        } else if (string3.endsWith("m")) {
            n2 = 60;
        } else if (string3.endsWith("h")) {
            n2 = 3600;
        } else if (string3.endsWith("d")) {
            n2 = 86400;
        } else {
            throw new IllegalArgumentException("Failed to read property '" + string + "' as a duration (bad unit): " + string3);
        }
        String string4 = StringUtils.truncate(string3, string3.length() - 1);
        try {
            n = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Failed to read property '" + string + "' as a duration (bad integer): " + string3);
        }
        return n * n2;
    }

    public byte[] readAsBinaryFile(String string, String string2) throws IllegalArgumentException {
        String string3 = this.props.getProperty(string, string2);
        try {
            return FileUtils.readFileAsBytes(string3);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Failed to read property '" + string + "' as a binary file: " + string3);
        }
    }

    public String readAsTextFile(String string, String string2) throws IllegalArgumentException {
        String string3 = this.props.getProperty(string, string2);
        try {
            return FileUtils.readFileAsString(string3, "UTF-8");
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Failed to read property '" + string + "' as a text file: " + string3);
        }
    }

    public File readAsFolder(String string, String string2, boolean bl) throws IllegalArgumentException {
        String string3 = this.props.getProperty(string, string2);
        File file = new File(string3);
        if (!file.exists()) {
            if (!bl) {
                throw new IllegalArgumentException("Folder in property '" + string + "' does not exists: " + string3);
            }
            if (!file.mkdirs()) {
                throw new IllegalArgumentException("Folder in property '" + string + "' does not exists and cannot be made: " + string3);
            }
        }
        return file;
    }
}

