/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.conv;

import com.cryptomathic.crypto.conv.ConvException;
import com.cryptomathic.crypto.conv.ConvMode;
import com.cryptomathic.crypto.conv.ConvState;
import com.cryptomathic.crypto.conv.ConvType;
import com.cryptomathic.crypto.pad.EBadPadding;
import com.cryptomathic.crypto.pad.Pad;
import com.cryptomathic.crypto.pad.PadMode;

public class ConvMech {
    private static int pad_length(int len, int blocksize, PadMode pmode) {
        int pad_length = 0;
        int ref = pmode.toInt();
        if (ref == PadMode.NOPAD.toInt()) {
            pad_length = len;
        } else if (ref == PadMode.ANSIX923.toInt() || ref == PadMode.ISO10126.toInt() || ref == PadMode.PADFF16.toInt() || ref == PadMode.PKCS5.toInt()) {
            pad_length = blocksize * ((len + blocksize) / blocksize);
        } else if (ref == PadMode.OPAD.toInt()) {
            pad_length = blocksize * ((len + blocksize - 1) / blocksize);
        }
        return pad_length;
    }

    private static int conv_length(int len, int blocksize, byte[] last, ConvMode mode, PadMode pmode) throws ConvException {
        int length = 0;
        int ref = mode.toInt();
        if (ref == ConvMode.ECBE.toInt() || ref == ConvMode.CBCE.toInt()) {
            length = ConvMech.pad_length(len, blocksize, pmode);
        } else if (ref == ConvMode.ECBD.toInt() || ref == ConvMode.CBCD.toInt()) {
            try {
                length = len - blocksize + Pad.unpad(last, blocksize, pmode);
            }
            catch (EBadPadding e) {
                throw new ConvException("Bad padding");
            }
        } else if (ref == ConvMode.CFBE.toInt()) {
            length = len;
        } else if (ref == ConvMode.CFBD.toInt()) {
            length = len;
        } else if (ref == ConvMode.OFB.toInt()) {
            length = len;
        } else if (ref == ConvMode.MAC.toInt()) {
            length = blocksize;
        }
        return length;
    }

    public static byte[] conv_mes(ConvType convtype, ConvMode mode, PadMode pmode, byte[] key, byte[] iv, byte[] imes) throws ConvException {
        int a = 1;
        int lb = 0;
        int lt = 0;
        boolean rlen = false;
        byte[] last = null;
        byte[] res = null;
        int len = imes.length;
        ConvState state = ConvState.conv_start_mode(convtype, mode, key, iv);
        int ref = mode.toInt();
        if (ref == ConvMode.ECBE.toInt() || ref == ConvMode.CBCE.toInt()) {
            if (pmode.toInt() == PadMode.NOPAD.toInt()) {
                lb = len;
                lt = 0;
            } else {
                lt = len % state.blocksize();
                lb = len - lt;
            }
        } else if (ref == ConvMode.ECBD.toInt() || ref == ConvMode.CBCD.toInt()) {
            if (len % state.blocksize() != 0) {
                throw new ConvException("Decryption message not divisible by blocksize");
            }
            if (ref == ConvMode.CBCD.toInt()) {
                last = state.decrypt(imes, len - state.blocksize());
                if (len == state.blocksize()) {
                    for (int t = 0; t < state.blocksize(); ++t) {
                        int n = t;
                        last[n] = (byte)(last[n] ^ iv[t]);
                    }
                } else {
                    for (int t = 0; t < state.blocksize(); ++t) {
                        int n = t;
                        last[n] = (byte)(last[n] ^ imes[len - 2 * state.blocksize() + t]);
                    }
                }
            } else if (ref == ConvMode.ECBD.toInt()) {
                last = state.decrypt(imes, len - state.blocksize());
            }
            lb = len;
            lt = 0;
            if (pmode.toInt() != PadMode.NOPAD.toInt()) {
                lb -= state.blocksize();
                lt = state.blocksize();
            }
        } else if (ref == ConvMode.CFBE.toInt() || ref == ConvMode.CFBD.toInt()) {
            lb = len;
            lt = 0;
        } else if (ref == ConvMode.OFB.toInt()) {
            lb = len;
            lt = 0;
        } else if (ref == ConvMode.MAC.toInt()) {
            a = 0;
            lb = len - len % state.blocksize();
            lt = len % state.blocksize();
        }
        res = new byte[ConvMech.conv_length(len, state.blocksize(), last, mode, pmode)];
        if (lb > 0) {
            state.conv_do_mode(imes, 0, lb, res, 0);
        }
        lt = state.conv_stop_mode(pmode, imes, lb, lt, res, lb * a);
        return res;
    }
}

