/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.conv;

import com.cryptomathic.crypto.conv.ConvException;
import com.cryptomathic.crypto.conv.ConvMode;
import com.cryptomathic.crypto.conv.ConvState3Des;
import com.cryptomathic.crypto.conv.ConvStateAes;
import com.cryptomathic.crypto.conv.ConvStateDes;
import com.cryptomathic.crypto.conv.ConvType;
import com.cryptomathic.crypto.pad.EBadPadding;
import com.cryptomathic.crypto.pad.Pad;
import com.cryptomathic.crypto.pad.PadMode;

public abstract class ConvState {
    protected ConvType convtype;
    protected ConvMode mode;
    protected int counter;
    protected byte[] iv;
    protected byte[] buffer;
    protected int buffer_size;
    private int blocksize;

    protected ConvState(ConvType convtype, ConvMode mode) {
        this.convtype = convtype;
        this.mode = mode;
        this.blocksize = this.blocksize();
        this.iv = new byte[this.blocksize];
        this.buffer = new byte[this.blocksize];
        this.buffer_size = 0;
    }

    public static ConvState conv_start_mode(ConvType convtype, ConvMode mode, byte[] key, byte[] iv) throws ConvException {
        ConvState state;
        int ref = convtype.toInt();
        if (ref == ConvType.DES3.toInt()) {
            state = new ConvState3Des(convtype, mode);
        } else if (ref == ConvType.DES.toInt()) {
            state = new ConvStateDes(convtype, mode);
        } else if (ref == ConvType.AES.toInt()) {
            state = new ConvStateAes(convtype, mode);
        } else if (ref == ConvType.AES192.toInt()) {
            state = new ConvStateAes(convtype, mode);
        } else if (ref == ConvType.AES256.toInt()) {
            state = new ConvStateAes(convtype, mode);
        } else {
            throw new ConvException("Unsupported type: " + convtype.toString());
        }
        ref = mode.toInt();
        if (ref != ConvMode.ECBE.toInt() && ref != ConvMode.ECBD.toInt()) {
            if (ref == ConvMode.CBCE.toInt() || ref == ConvMode.CBCD.toInt() || ref == ConvMode.CFBE.toInt() || ref == ConvMode.CFBD.toInt() || ref == ConvMode.OFB.toInt()) {
                if (iv.length < state.blocksize) {
                    throw new ConvException("Invalid initialization vector");
                }
                System.arraycopy(iv, 0, state.iv, 0, state.blocksize);
            } else if (ref == ConvMode.MAC.toInt()) {
                for (int i = 0; i < state.blocksize; ++i) {
                    state.iv[i] = 0;
                }
            } else {
                throw new ConvException("Unsupported mode : " + mode.toString());
            }
        }
        if (ref == ConvMode.ECBD.toInt() || ref == ConvMode.CBCD.toInt()) {
            state.makekeys_decrypt(key);
        } else {
            state.makekeys_encrypt(key);
        }
        return state;
    }

    public int conv_do_mode(byte[] input, int ioffset, int length, byte[] output, int ooffset) {
        int len = 0;
        int residue = 0;
        int ref = this.mode.toInt();
        if (ref == ConvMode.ECBE.toInt()) {
            len = this.buffer_size + length;
            residue = len % this.blocksize;
            input = this.buffer_append(input, ioffset, length);
            int j = 0;
            while (j + this.blocksize <= len) {
                this.encrypt(input, j, output, j + ooffset);
                j += this.blocksize;
            }
            this.buffer_update(input, len - residue, residue);
        } else if (ref == ConvMode.ECBD.toInt()) {
            len = this.buffer_size + length;
            residue = len % this.blocksize;
            input = this.buffer_append(input, ioffset, length);
            int j = 0;
            while (j + this.blocksize <= len) {
                this.decrypt(input, j, output, j + ooffset);
                j += this.blocksize;
            }
            this.buffer_update(input, len - residue, residue);
        } else if (ref == ConvMode.CBCE.toInt()) {
            len = this.buffer_size + length;
            residue = len % this.blocksize;
            input = this.buffer_append(input, ioffset, length);
            byte[] iv = new byte[this.blocksize];
            System.arraycopy(this.iv, 0, iv, 0, this.blocksize);
            int j = 0;
            while (j + this.blocksize <= len) {
                for (int i = 0; i < this.blocksize; ++i) {
                    output[j + ooffset + i] = (byte)(input[j + i] ^ iv[i]);
                }
                this.encrypt(output, j + ooffset, output, j + ooffset);
                System.arraycopy(output, j + ooffset, iv, 0, this.blocksize);
                j += this.blocksize;
            }
            System.arraycopy(iv, 0, this.iv, 0, this.blocksize);
            this.buffer_update(input, len - residue, residue);
        } else if (ref == ConvMode.CBCD.toInt()) {
            len = this.buffer_size + length;
            residue = len % this.blocksize;
            input = this.buffer_append(input, ioffset, length);
            byte[] iv = new byte[this.blocksize];
            byte[] tmp = new byte[this.blocksize];
            System.arraycopy(this.iv, 0, iv, 0, this.blocksize);
            int j = 0;
            while (j + this.blocksize <= len) {
                System.arraycopy(input, j, tmp, 0, this.blocksize);
                this.decrypt(input, j, output, j + ooffset);
                for (int i = 0; i < this.blocksize; ++i) {
                    int n = j + ooffset + i;
                    output[n] = (byte)(output[n] ^ iv[i]);
                }
                System.arraycopy(tmp, 0, iv, 0, this.blocksize);
                j += this.blocksize;
            }
            System.arraycopy(iv, 0, this.iv, 0, this.blocksize);
            this.buffer_update(input, len - residue, residue);
        } else if (ref == ConvMode.CFBE.toInt()) {
            byte[] tmp = new byte[this.blocksize];
            len = length;
            residue = 0;
            for (int j = 0; j < len; ++j) {
                this.encrypt(this.iv, 0, tmp, 0);
                output[j + ooffset] = (byte)(input[j + ioffset] ^ tmp[0]);
                for (int i = 0; i < this.blocksize - 1; ++i) {
                    this.iv[i] = this.iv[i + 1];
                }
                this.iv[this.blocksize - 1] = output[j + ooffset];
            }
        } else if (ref == ConvMode.CFBD.toInt()) {
            byte[] tmp = new byte[this.blocksize];
            len = length;
            residue = 0;
            for (int j = 0; j < len; ++j) {
                this.encrypt(this.iv, 0, tmp, 0);
                output[j + ooffset] = (byte)(input[j + ioffset] ^ tmp[0]);
                for (int i = 0; i < this.blocksize - 1; ++i) {
                    this.iv[i] = this.iv[i + 1];
                }
                this.iv[this.blocksize - 1] = input[j + ooffset];
            }
        } else if (ref == ConvMode.OFB.toInt()) {
            len = length;
            residue = 0;
            for (int j = 0; j < len; ++j) {
                this.encrypt(this.iv, 0, this.iv, 0);
                output[j + ooffset] = (byte)(this.iv[0] ^ input[j + ioffset]);
            }
        } else if (ref == ConvMode.MAC.toInt()) {
            len = this.buffer_size + length;
            residue = len % this.blocksize;
            input = this.buffer_append(input, ioffset, length);
            int j = 0;
            while (j + this.blocksize <= len) {
                for (int i = 0; i < this.blocksize; ++i) {
                    int n = i;
                    this.iv[n] = (byte)(this.iv[n] ^ input[j + i]);
                }
                this.encrypt(this.iv, 0, this.iv, 0);
                j += this.blocksize;
            }
            this.buffer_update(input, len - residue, residue);
        }
        return len - residue;
    }

    public int conv_stop_mode(PadMode pmode, byte[] output, int ooffset) throws ConvException {
        return this.conv_stop_mode(pmode, new byte[0], 0, 0, output, ooffset);
    }

    public int conv_stop_mode(PadMode pmode, byte[] input, int ioffset, int length, byte[] output, int ooffset) throws ConvException {
        int rlen = 0;
        byte[] tmp = new byte[2 * this.blocksize];
        int ref = this.mode.toInt();
        if (ref == ConvMode.ECBE.toInt()) {
            int len = this.buffer_size + length;
            int residue = len % this.blocksize;
            input = this.buffer_append(input, ioffset, length);
            this.buffer_size = 0;
            if (len >= this.blocksize) {
                this.conv_do_mode(input, 0, len - residue, output, ooffset);
                ooffset += len - residue;
                rlen += len - residue;
            }
            if (pmode.toInt() != PadMode.NOPAD.toInt()) {
                System.arraycopy(input, len - residue, tmp, 0, residue);
                if (Pad.pad(tmp, residue, this.blocksize, pmode) == 1) {
                    this.encrypt(tmp, 0, output, ooffset);
                    rlen += this.blocksize;
                }
            }
        } else if (ref == ConvMode.ECBD.toInt()) {
            int len = this.buffer_size + length;
            int residue = len % this.blocksize;
            if (residue != 0) {
                throw new ConvException("Number of bytes not a multiple of " + this.blocksize);
            }
            input = this.buffer_append(input, ioffset, length);
            this.buffer_size = 0;
            rlen = 0;
            if (len > 0) {
                if (len > this.blocksize) {
                    this.conv_do_mode(input, 0, len - this.blocksize, output, ooffset);
                    ooffset += len - this.blocksize;
                }
                this.decrypt(input, 0, tmp, 0);
                if (pmode.toInt() != PadMode.NOPAD.toInt()) {
                    try {
                        rlen = Pad.unpad(tmp, this.blocksize, pmode);
                    }
                    catch (EBadPadding e) {
                        throw new ConvException("Bad padding");
                    }
                } else {
                    rlen = this.blocksize;
                }
                System.arraycopy(tmp, 0, output, ooffset, rlen);
            } else {
                rlen = this.blocksize;
            }
            rlen = len - this.blocksize + rlen;
        } else if (ref == ConvMode.CBCE.toInt()) {
            int len = this.buffer_size + length;
            int residue = len % this.blocksize;
            input = this.buffer_append(input, ioffset, length);
            this.buffer_size = 0;
            rlen = 0;
            if (len >= this.blocksize) {
                this.conv_do_mode(input, 0, len - residue, output, ooffset);
                ooffset += len - residue;
                rlen += len - residue;
            }
            if (pmode.toInt() != PadMode.NOPAD.toInt()) {
                System.arraycopy(input, len - residue, tmp, 0, residue);
                if (Pad.pad(tmp, residue, this.blocksize, pmode) == 1) {
                    byte[] iv = this.iv;
                    for (int i = 0; i < this.blocksize; ++i) {
                        int n = i;
                        tmp[n] = (byte)(tmp[n] ^ iv[i]);
                    }
                    this.encrypt(tmp, 0, output, ooffset);
                    System.arraycopy(output, ooffset, iv, 0, this.blocksize);
                    rlen += this.blocksize;
                }
            }
        } else if (ref == ConvMode.CBCD.toInt()) {
            int len = this.buffer_size + length;
            int residue = len % this.blocksize;
            if (residue != 0) {
                throw new ConvException("Number of bytes not a multiple of " + this.blocksize);
            }
            input = this.buffer_append(input, ioffset, length);
            this.buffer_size = 0;
            rlen = 0;
            if (len > 0) {
                if (len > this.blocksize) {
                    this.conv_do_mode(input, 0, len - this.blocksize, output, ooffset);
                }
                ooffset += len;
                if (pmode.toInt() != PadMode.NOPAD.toInt()) {
                    this.decrypt(input, len - this.blocksize, tmp, 0);
                    for (int i = 0; i < this.blocksize; ++i) {
                        int n = i;
                        tmp[n] = (byte)(tmp[n] ^ this.iv[i]);
                    }
                    try {
                        rlen = Pad.unpad(tmp, this.blocksize, pmode);
                    }
                    catch (EBadPadding e) {
                        throw new ConvException("Bad padding");
                    }
                    System.arraycopy(tmp, 0, output, ooffset - this.blocksize, rlen);
                } else {
                    this.decrypt(input, len - this.blocksize, tmp, 0);
                    for (int i = 0; i < this.blocksize; ++i) {
                        int n = i;
                        tmp[n] = (byte)(tmp[n] ^ this.iv[i]);
                    }
                    System.arraycopy(tmp, 0, output, ooffset - this.blocksize, this.blocksize);
                    rlen = this.blocksize;
                }
                rlen = len - this.blocksize + rlen;
            } else {
                rlen = 0;
            }
        } else if (ref != ConvMode.CFBE.toInt() && ref != ConvMode.CFBD.toInt() && ref != ConvMode.OFB.toInt() && ref == ConvMode.MAC.toInt()) {
            int len = this.buffer_size + length;
            int residue = len % this.blocksize;
            input = this.buffer_append(input, ioffset, length);
            this.buffer_size = 0;
            if (len >= this.blocksize) {
                this.conv_do_mode(input, 0, len - residue, output, ooffset);
            }
            if (pmode.toInt() != PadMode.NOPAD.toInt()) {
                System.arraycopy(input, len - residue, tmp, 0, residue);
                if (Pad.pad(tmp, residue, this.blocksize, pmode) == 1) {
                    for (int i = 0; i < this.blocksize; ++i) {
                        int n = i;
                        tmp[n] = (byte)(tmp[n] ^ this.iv[i]);
                    }
                    this.encrypt(tmp, 0, output, ooffset);
                } else {
                    System.arraycopy(this.iv, 0, output, ooffset, this.blocksize);
                }
            }
            rlen = this.blocksize;
        }
        this.makekeys_zero();
        return rlen;
    }

    private byte[] buffer_append(byte[] m, int offset, int len) {
        byte[] res = new byte[len + this.buffer_size];
        System.arraycopy(this.buffer, 0, res, 0, this.buffer_size);
        System.arraycopy(m, offset, res, this.buffer_size, len);
        return res;
    }

    private void buffer_update(byte[] m, int offset, int len) {
        System.arraycopy(m, offset, this.buffer, 0, len);
        this.buffer_size = len;
    }

    public byte[] encrypt(byte[] input, int ioffset) {
        byte[] res = new byte[this.blocksize];
        this.encrypt(input, ioffset, res, 0);
        return res;
    }

    public byte[] decrypt(byte[] input, int ioffset) {
        byte[] res = new byte[this.blocksize];
        this.decrypt(input, ioffset, res, 0);
        return res;
    }

    abstract void makekeys_encrypt(byte[] var1) throws ConvException;

    abstract void makekeys_decrypt(byte[] var1) throws ConvException;

    abstract void encrypt(byte[] var1, int var2, byte[] var3, int var4);

    abstract void decrypt(byte[] var1, int var2, byte[] var3, int var4);

    abstract void makekeys_zero() throws ConvException;

    abstract int blocksize();
}

