/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.des;

public class DesKeyUtil {
    private static final byte[][] weak_keys = new byte[][]{{1, 1, 1, 1, 1, 1, 1, 1}, {-2, -2, -2, -2, -2, -2, -2, -2}, {31, 31, 31, 31, 14, 14, 14, 14}, {-32, -32, -32, -32, -15, -15, -15, -15}, {1, -2, 1, -2, 1, -2, 1, -2}, {-2, 1, -2, 1, -2, 1, -2, 1}, {31, -32, 31, -32, 14, -15, 14, -15}, {-32, 31, -32, 31, -15, 14, -15, 14}, {1, -32, 1, -32, 1, -15, 1, -15}, {-32, 1, -32, 1, -15, 1, -15, 1}, {31, -2, 31, -2, 14, -2, 14, -2}, {-2, 31, -2, 31, -2, 14, -2, 14}, {1, 31, 1, 31, 1, 14, 1, 14}, {31, 1, 31, 1, 14, 1, 14, 1}, {-32, -2, -32, -2, -15, -2, -15, -2}, {-2, -32, -2, -32, -2, -15, -2, -15}};

    private static byte oddParity(byte b) {
        return DesKeyUtil.haveOddParity(b) ? b : (byte)(b ^ 1);
    }

    private static boolean haveOddParity(byte b) {
        b = (byte)((b & 0xFF) >> 4 ^ b & 0xF);
        b = (byte)((b & 0xFF) >> 2 ^ b & 3);
        return (b = (byte)((b & 0xFF) >> 1 ^ b & 1)) == 1;
    }

    public static boolean isKeyStrong(byte[] key) {
        if (key.length != 8) {
            return false;
        }
        int i = 0;
        int j = 0;
        while (i < 16) {
            if (key[j] == weak_keys[i][j]) {
                if (++j != 8) continue;
                return false;
            }
            j = 0;
            ++i;
        }
        return true;
    }

    public static void forceOddParity(byte[] key) {
        for (int i = 0; i < key.length; ++i) {
            key[i] = DesKeyUtil.oddParity(key[i]);
        }
    }

    public static boolean haveOddParity(byte[] key) {
        if (key == null) {
            return false;
        }
        for (int i = 0; i < key.length; ++i) {
            if (DesKeyUtil.haveOddParity(key[i])) continue;
            return false;
        }
        return true;
    }
}

