/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.des;

import com.cryptomathic.crypto.des.DesException;
import com.cryptomathic.crypto.des.DesMode;
import com.cryptomathic.crypto.des.DesState;
import com.cryptomathic.crypto.des.DesType;
import com.cryptomathic.crypto.pad.EBadPadding;
import com.cryptomathic.crypto.pad.Pad;
import com.cryptomathic.crypto.pad.PadMode;

public class DesMech {
    private static int pad_length(int len, PadMode pmode) {
        int pad_length = 0;
        int ref = pmode.toInt();
        if (ref == PadMode.NOPAD.toInt()) {
            pad_length = len;
        } else if (ref == PadMode.ANSIX923.toInt() || ref == PadMode.ISO10126.toInt() || ref == PadMode.PADFF16.toInt()) {
            pad_length = 8 * ((len + 8) / 8);
        } else if (ref == PadMode.OPAD.toInt()) {
            pad_length = 8 * ((len + 7) / 8);
        }
        return pad_length;
    }

    private static int des_length(int len, byte[] last, DesMode mode, PadMode pmode) throws DesException {
        int length = 0;
        int ref = mode.toInt();
        if (ref == DesMode.ECBE.toInt() || ref == DesMode.CBCE.toInt()) {
            length = DesMech.pad_length(len, pmode);
        } else if (ref == DesMode.ECBD.toInt() || ref == DesMode.CBCD.toInt()) {
            try {
                length = len - 8 + Pad.unpad(last, 8, pmode);
            }
            catch (EBadPadding e) {
                throw new DesException("Bad padding");
            }
        } else if (ref == DesMode.CFBE.toInt()) {
            length = len;
        } else if (ref == DesMode.CFBD.toInt()) {
            length = len;
        } else if (ref == DesMode.OFB.toInt()) {
            length = len;
        } else if (ref == DesMode.CFB64E.toInt()) {
            length = len;
        } else if (ref == DesMode.CFB64D.toInt()) {
            length = len;
        } else if (ref == DesMode.MAC.toInt()) {
            length = 8;
        } else if (ref == DesMode.ANSIMAC.toInt()) {
            length = 8;
        } else if (ref == DesMode.ANSIMAC8.toInt()) {
            length = 8;
        } else if (ref == DesMode.RIPEMAC.toInt()) {
            length = 8;
        }
        return length;
    }

    public static byte[] des_mes(DesType destype, DesMode mode, PadMode pmode, byte[] key, byte[] iv, byte[] imes, int len) throws DesException {
        int a = 1;
        int lb = 0;
        int lt = 0;
        byte[] last = null;
        byte[] res = null;
        if (imes.length < len) {
            throw new DesException("Invalid length of message");
        }
        DesState state = DesState.des_start_mode(destype, mode, key, iv);
        int ref = mode.toInt();
        if (ref == DesMode.ECBE.toInt() || ref == DesMode.CBCE.toInt()) {
            if (pmode.toInt() == PadMode.NOPAD.toInt()) {
                lb = len;
                lt = 0;
            } else {
                lt = len % 8;
                lb = len - lt;
            }
        } else if (ref == DesMode.ECBD.toInt() || ref == DesMode.CBCD.toInt()) {
            if (len % 8 != 0) {
                throw new DesException("Decryption message not divisible by 8 bytes");
            }
            if (ref == DesMode.CBCD.toInt()) {
                last = state.decrypt(imes, len - 8);
                if (len == 8) {
                    for (int t = 0; t < 8; ++t) {
                        int n = t;
                        last[n] = (byte)(last[n] ^ iv[t]);
                    }
                } else {
                    for (int t = 0; t < 8; ++t) {
                        int n = t;
                        last[n] = (byte)(last[n] ^ imes[len - 16 + t]);
                    }
                }
            } else if (ref == DesMode.ECBD.toInt()) {
                last = state.decrypt(imes, len - 8);
            }
            lb = len;
            lt = 0;
            if (pmode.toInt() != PadMode.NOPAD.toInt()) {
                lb -= 8;
                lt = 8;
            }
        } else if (ref == DesMode.CFBE.toInt() || ref == DesMode.CFBD.toInt()) {
            lb = len;
            lt = 0;
        } else if (ref == DesMode.OFB.toInt()) {
            lb = len;
            lt = 0;
        } else if (ref == DesMode.CFB64E.toInt()) {
            lb = len - len % 8;
            lt = len % 8;
        } else if (ref == DesMode.CFB64D.toInt()) {
            lb = len - len % 8;
            lt = len % 8;
        } else if (ref == DesMode.MAC.toInt()) {
            a = 0;
            lb = len - len % 8;
            lt = len % 8;
        } else if (ref == DesMode.ANSIMAC.toInt()) {
            a = 0;
            lb = len - len % 8;
            lt = len % 8;
        } else if (ref == DesMode.ANSIMAC8.toInt()) {
            a = 0;
            lb = len - len % 8;
            lt = len % 8;
        } else if (ref == DesMode.RIPEMAC.toInt()) {
            a = 0;
            lb = len - len % 8;
            lt = len % 8;
        }
        res = new byte[DesMech.des_length(len, last, mode, pmode)];
        if (lb > 0) {
            state.des_do_mode(imes, res, 0, lb, 0);
        }
        lt = state.des_stop_mode(pmode, imes, res, lb, lt, lb * a);
        return res;
    }
}

