/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.des;

import com.cryptomathic.crypto.des.DesException;
import com.cryptomathic.crypto.des.DesKernel;
import com.cryptomathic.crypto.des.DesMode;
import com.cryptomathic.crypto.des.DesState;
import com.cryptomathic.crypto.des.DesType;

class DesState3Des
extends DesState {
    static byte[] zero16 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int[] key1;
    private int[] key2;

    protected DesState3Des(DesType destype, DesMode mode) {
        super(destype, mode);
    }

    protected void makekeys(byte[] keys) throws DesException {
        if (keys.length < 16) {
            throw new DesException("Invalid key triple DES");
        }
        byte[] tmp = new byte[8];
        System.arraycopy(keys, 0, tmp, 0, 8);
        this.key1 = DesKernel.des_make_keys(tmp);
        System.arraycopy(keys, 8, tmp, 0, 8);
        this.key2 = DesKernel.des_make_keys(tmp);
    }

    protected byte[] encrypt(byte[] in, int offs) {
        return DesKernel.des_encrypt(this.key1, DesKernel.des_decrypt(this.key2, DesKernel.des_encrypt(this.key1, in, offs), 0), 0);
    }

    protected byte[] decrypt(byte[] in, int offs) {
        return DesKernel.des_decrypt(this.key1, DesKernel.des_encrypt(this.key2, DesKernel.des_decrypt(this.key1, in, offs), 0), 0);
    }

    protected void makekeys_zero() throws DesException {
        this.makekeys(zero16);
    }

    protected void XORkeys() throws DesException {
        int i;
        byte[] tmp = new byte[16];
        byte[] key1 = new byte[128];
        byte[] key2 = new byte[128];
        System.arraycopy(this.key1, 0, key1, 0, 128);
        System.arraycopy(this.key2, 0, key2, 0, 128);
        for (i = 0; i < 16; ++i) {
            tmp[i] = -16;
        }
        this.makekeys(tmp);
        for (i = 0; i < 128; ++i) {
            int n = i;
            this.key1[n] = this.key1[n] ^ key1[i];
            int n2 = i;
            this.key2[n2] = this.key2[n2] ^ key2[i];
        }
    }

    protected byte[] getKeys() {
        byte[] res = new byte[256];
        System.arraycopy(this.key1, 0, res, 0, 128);
        System.arraycopy(this.key2, 0, res, 128, 128);
        return res;
    }

    protected void setKeys(byte[] keys) {
        System.arraycopy(keys, 0, this.key1, 0, 128);
        System.arraycopy(keys, 128, this.key2, 0, 128);
    }
}

