/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.hash;

import com.cryptomathic.crypto.hash.HashPad;
import com.cryptomathic.crypto.hash.HashPadMode;
import com.cryptomathic.crypto.hash.HashState;
import com.cryptomathic.crypto.hash.HashType;
import com.cryptomathic.crypto.util.Convert;

class StateMD4
extends HashState {
    private static int h1 = 1732584193;
    private static int h2 = -271733879;
    private static int h3 = -1732584194;
    private static int h4 = 271733878;
    private int H1;
    private int H2;
    private int H3;
    private int H4;

    protected StateMD4() {
        this.block_size = 64;
        this.buffer = new byte[2 * this.block_size];
        this.state = new byte[16];
        Convert.lendian_int2byte(this.state, 0, h1);
        Convert.lendian_int2byte(this.state, 4, h2);
        Convert.lendian_int2byte(this.state, 8, h3);
        Convert.lendian_int2byte(this.state, 12, h4);
        this.hash_size = 16;
        this.hashtype = HashType.MD4;
    }

    protected void hash(byte[] mes, int offset) {
        int[] w = new int[16];
        this.H1 = Convert.lendian_byte2int(this.state, 0);
        this.H2 = Convert.lendian_byte2int(this.state, 4);
        this.H3 = Convert.lendian_byte2int(this.state, 8);
        this.H4 = Convert.lendian_byte2int(this.state, 12);
        for (int i = 0; i < 16; ++i) {
            w[i] = Convert.lendian_byte2int(mes, 4 * i + offset);
        }
        int eax = this.H1;
        int ebx = this.H2;
        int ecx = this.H3;
        int edx = this.H4;
        eax += (ebx & ecx | ~ebx & edx) + w[0];
        eax = eax << 3 | eax >>> 29;
        edx += (eax & ebx | ~eax & ecx) + w[1];
        edx = edx << 7 | edx >>> 25;
        ecx += (edx & eax | ~edx & ebx) + w[2];
        ecx = ecx << 11 | ecx >>> 21;
        ebx += (ecx & edx | ~ecx & eax) + w[3];
        ebx = ebx << 19 | ebx >>> 13;
        eax += (ebx & ecx | ~ebx & edx) + w[4];
        eax = eax << 3 | eax >>> 29;
        edx += (eax & ebx | ~eax & ecx) + w[5];
        edx = edx << 7 | edx >>> 25;
        ecx += (edx & eax | ~edx & ebx) + w[6];
        ecx = ecx << 11 | ecx >>> 21;
        ebx += (ecx & edx | ~ecx & eax) + w[7];
        ebx = ebx << 19 | ebx >>> 13;
        eax += (ebx & ecx | ~ebx & edx) + w[8];
        eax = eax << 3 | eax >>> 29;
        edx += (eax & ebx | ~eax & ecx) + w[9];
        edx = edx << 7 | edx >>> 25;
        ecx += (edx & eax | ~edx & ebx) + w[10];
        ecx = ecx << 11 | ecx >>> 21;
        ebx += (ecx & edx | ~ecx & eax) + w[11];
        ebx = ebx << 19 | ebx >>> 13;
        eax += (ebx & ecx | ~ebx & edx) + w[12];
        eax = eax << 3 | eax >>> 29;
        edx += (eax & ebx | ~eax & ecx) + w[13];
        edx = edx << 7 | edx >>> 25;
        ecx += (edx & eax | ~edx & ebx) + w[14];
        ecx = ecx << 11 | ecx >>> 21;
        ebx += (ecx & edx | ~ecx & eax) + w[15];
        ebx = ebx << 19 | ebx >>> 13;
        eax += (ebx & ecx | ebx & edx | ecx & edx) + w[0] + 1518500249;
        eax = eax << 3 | eax >>> 29;
        edx += (eax & ebx | eax & ecx | ebx & ecx) + w[4] + 1518500249;
        edx = edx << 5 | edx >>> 27;
        ecx += (edx & eax | edx & ebx | eax & ebx) + w[8] + 1518500249;
        ecx = ecx << 9 | ecx >>> 23;
        ebx += (ecx & edx | ecx & eax | edx & eax) + w[12] + 1518500249;
        ebx = ebx << 13 | ebx >>> 19;
        eax += (ebx & ecx | ebx & edx | ecx & edx) + w[1] + 1518500249;
        eax = eax << 3 | eax >>> 29;
        edx += (eax & ebx | eax & ecx | ebx & ecx) + w[5] + 1518500249;
        edx = edx << 5 | edx >>> 27;
        ecx += (edx & eax | edx & ebx | eax & ebx) + w[9] + 1518500249;
        ecx = ecx << 9 | ecx >>> 23;
        ebx += (ecx & edx | ecx & eax | edx & eax) + w[13] + 1518500249;
        ebx = ebx << 13 | ebx >>> 19;
        eax += (ebx & ecx | ebx & edx | ecx & edx) + w[2] + 1518500249;
        eax = eax << 3 | eax >>> 29;
        edx += (eax & ebx | eax & ecx | ebx & ecx) + w[6] + 1518500249;
        edx = edx << 5 | edx >>> 27;
        ecx += (edx & eax | edx & ebx | eax & ebx) + w[10] + 1518500249;
        ecx = ecx << 9 | ecx >>> 23;
        ebx += (ecx & edx | ecx & eax | edx & eax) + w[14] + 1518500249;
        ebx = ebx << 13 | ebx >>> 19;
        eax += (ebx & ecx | ebx & edx | ecx & edx) + w[3] + 1518500249;
        eax = eax << 3 | eax >>> 29;
        edx += (eax & ebx | eax & ecx | ebx & ecx) + w[7] + 1518500249;
        edx = edx << 5 | edx >>> 27;
        ecx += (edx & eax | edx & ebx | eax & ebx) + w[11] + 1518500249;
        ecx = ecx << 9 | ecx >>> 23;
        ebx += (ecx & edx | ecx & eax | edx & eax) + w[15] + 1518500249;
        ebx = ebx << 13 | ebx >>> 19;
        eax += (ebx ^ ecx ^ edx) + w[0] + 1859775393;
        eax = eax << 3 | eax >>> 29;
        edx += (eax ^ ebx ^ ecx) + w[8] + 1859775393;
        edx = edx << 9 | edx >>> 23;
        ecx += (eax ^ ebx ^ edx) + w[4] + 1859775393;
        ecx = ecx << 11 | ecx >>> 21;
        ebx += (eax ^ ecx ^ edx) + w[12] + 1859775393;
        ebx = ebx << 15 | ebx >>> 17;
        eax += (ebx ^ ecx ^ edx) + w[2] + 1859775393;
        eax = eax << 3 | eax >>> 29;
        edx += (eax ^ ebx ^ ecx) + w[10] + 1859775393;
        edx = edx << 9 | edx >>> 23;
        ecx += (eax ^ ebx ^ edx) + w[6] + 1859775393;
        ecx = ecx << 11 | ecx >>> 21;
        ebx += (eax ^ ecx ^ edx) + w[14] + 1859775393;
        ebx = ebx << 15 | ebx >>> 17;
        eax += (ebx ^ ecx ^ edx) + w[1] + 1859775393;
        eax = eax << 3 | eax >>> 29;
        edx += (eax ^ ebx ^ ecx) + w[9] + 1859775393;
        edx = edx << 9 | edx >>> 23;
        ecx += (eax ^ ebx ^ edx) + w[5] + 1859775393;
        ecx = ecx << 11 | ecx >>> 21;
        ebx += (eax ^ ecx ^ edx) + w[13] + 1859775393;
        ebx = ebx << 15 | ebx >>> 17;
        eax += (ebx ^ ecx ^ edx) + w[3] + 1859775393;
        eax = eax << 3 | eax >>> 29;
        edx += (eax ^ ebx ^ ecx) + w[11] + 1859775393;
        edx = edx << 9 | edx >>> 23;
        ecx += (eax ^ ebx ^ edx) + w[7] + 1859775393;
        ecx = ecx << 11 | ecx >>> 21;
        ebx += (eax ^ ecx ^ edx) + w[15] + 1859775393;
        ebx = ebx << 15 | ebx >>> 17;
        Convert.lendian_int2byte(this.state, 0, this.H1 + eax);
        Convert.lendian_int2byte(this.state, 4, this.H2 + ebx);
        Convert.lendian_int2byte(this.state, 8, this.H3 + ecx);
        Convert.lendian_int2byte(this.state, 12, this.H4 + edx);
    }

    protected int pad(HashPadMode pmode) {
        HashPad.MD5Pad(this);
        return 1;
    }
}

