/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.hash;

import com.cryptomathic.crypto.des.DesKernel;
import com.cryptomathic.crypto.hash.HashException;
import com.cryptomathic.crypto.hash.HashPad;
import com.cryptomathic.crypto.hash.HashPadMode;
import com.cryptomathic.crypto.hash.HashState;
import com.cryptomathic.crypto.hash.HashType;

class StateMDC4
extends HashState {
    protected StateMDC4() {
        this.block_size = 8;
        this.buffer = new byte[2 * this.block_size];
        this.state = new byte[16];
        for (int i = 0; i < 8; ++i) {
            this.state[i] = 82;
            this.state[i + 8] = 37;
        }
        this.hash_size = 16;
        this.hashtype = HashType.MDC4;
    }

    protected void hash(byte[] mes, int offset) {
        int j;
        byte[] H0 = new byte[8];
        byte[] H1 = new byte[8];
        System.arraycopy(this.state, 0, H0, 0, 8);
        System.arraycopy(this.state, 8, H1, 0, 8);
        H0[0] = (byte)(H0[0] & 0xFFFFFF9F | 0x40);
        H1[0] = (byte)(H1[0] & 0xFFFFFF9F | 0x20);
        int[] key = DesKernel.des_make_keys(H0);
        byte[] T0 = DesKernel.des_encrypt(key, mes, offset);
        for (j = 0; j < 8; ++j) {
            int n = j;
            T0[n] = (byte)(T0[n] ^ mes[j + offset]);
        }
        key = DesKernel.des_make_keys(H1);
        byte[] T1 = DesKernel.des_encrypt(key, mes, offset);
        for (j = 0; j < 8; ++j) {
            int n = j;
            T1[n] = (byte)(T1[n] ^ mes[j + offset]);
        }
        for (j = 4; j < 8; ++j) {
            int n = j;
            T0[n] = (byte)(T0[n] ^ T1[j]);
            int n2 = j;
            T1[n2] = (byte)(T1[n2] ^ T0[j]);
            int n3 = j;
            T0[n3] = (byte)(T0[n3] ^ T1[j]);
        }
        System.arraycopy(this.state, 0, H0, 0, 8);
        System.arraycopy(this.state, 8, H1, 0, 8);
        T0[0] = (byte)(T0[0] & 0xFFFFFF9F | 0x40);
        T1[0] = (byte)(T1[0] & 0xFFFFFF9F | 0x20);
        key = DesKernel.des_make_keys(T0);
        T0 = DesKernel.des_encrypt(key, H1, 0);
        for (j = 0; j < 8; ++j) {
            int n = j;
            T0[n] = (byte)(T0[n] ^ H1[j]);
        }
        key = DesKernel.des_make_keys(T1);
        T1 = DesKernel.des_encrypt(key, H0, 0);
        for (j = 0; j < 8; ++j) {
            int n = j;
            T1[n] = (byte)(T1[n] ^ H0[j]);
        }
        for (j = 4; j < 8; ++j) {
            int n = j;
            T0[n] = (byte)(T0[n] ^ T1[j]);
            int n4 = j;
            T1[n4] = (byte)(T1[n4] ^ T0[j]);
            int n5 = j;
            T0[n5] = (byte)(T0[n5] ^ T1[j]);
        }
        System.arraycopy(T0, 0, this.state, 0, 8);
        System.arraycopy(T1, 0, this.state, 8, 8);
    }

    protected int pad(HashPadMode pmode) throws HashException {
        int res = 0;
        if (pmode.toInt() != HashPadMode.NOPAD.toInt()) {
            int ref = pmode.toInt();
            if (ref == HashPadMode.MDC.toInt()) {
                HashPad.MDCPad(this);
            } else if (ref == HashPadMode.MDCFF16.toInt()) {
                HashPad.MDCPadFF16(this);
            } else {
                throw new HashException("MDC");
            }
            res = 1;
        }
        return res;
    }
}

