/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.hash;

import com.cryptomathic.crypto.hash.HashPad;
import com.cryptomathic.crypto.hash.HashPadMode;
import com.cryptomathic.crypto.hash.HashState;
import com.cryptomathic.crypto.hash.HashType;
import com.cryptomathic.crypto.util.Convert;

class StateRIPEMD128
extends HashState {
    private static int h1 = 1732584193;
    private static int h2 = -271733879;
    private static int h3 = -1732584194;
    private static int h4 = 271733878;
    private int H1;
    private int H2;
    private int H3;
    private int H4;

    protected StateRIPEMD128() {
        this.block_size = 64;
        this.buffer = new byte[2 * this.block_size];
        this.state = new byte[16];
        Convert.lendian_int2byte(this.state, 0, h1);
        Convert.lendian_int2byte(this.state, 4, h2);
        Convert.lendian_int2byte(this.state, 8, h3);
        Convert.lendian_int2byte(this.state, 12, h4);
        this.hash_size = 16;
        this.hashtype = HashType.RIPEMD128;
    }

    protected void hash(byte[] mes, int offset) {
        int[] w = new int[16];
        this.H1 = Convert.lendian_byte2int(this.state, 0);
        this.H2 = Convert.lendian_byte2int(this.state, 4);
        this.H3 = Convert.lendian_byte2int(this.state, 8);
        this.H4 = Convert.lendian_byte2int(this.state, 12);
        for (int i = 0; i < 16; ++i) {
            w[i] = Convert.lendian_byte2int(mes, 4 * i + offset);
        }
        int eax = this.H1;
        int ebx = this.H2;
        int ecx = this.H3;
        int edx = this.H4;
        eax += (ebx ^ ecx ^ edx) + w[0];
        eax = eax << 11 | eax >>> 21;
        edx += (eax ^ ebx ^ ecx) + w[1];
        edx = edx << 14 | edx >>> 18;
        ecx += (edx ^ eax ^ ebx) + w[2];
        ecx = ecx << 15 | ecx >>> 17;
        ebx += (ecx ^ edx ^ eax) + w[3];
        ebx = ebx << 12 | ebx >>> 20;
        eax += (ebx ^ ecx ^ edx) + w[4];
        eax = eax << 5 | eax >>> 27;
        edx += (eax ^ ebx ^ ecx) + w[5];
        edx = edx << 8 | edx >>> 24;
        ecx += (edx ^ eax ^ ebx) + w[6];
        ecx = ecx << 7 | ecx >>> 25;
        ebx += (ecx ^ edx ^ eax) + w[7];
        ebx = ebx << 9 | ebx >>> 23;
        eax += (ebx ^ ecx ^ edx) + w[8];
        eax = eax << 11 | eax >>> 21;
        edx += (eax ^ ebx ^ ecx) + w[9];
        edx = edx << 13 | edx >>> 19;
        ecx += (edx ^ eax ^ ebx) + w[10];
        ecx = ecx << 14 | ecx >>> 18;
        ebx += (ecx ^ edx ^ eax) + w[11];
        ebx = ebx << 15 | ebx >>> 17;
        eax += (ebx ^ ecx ^ edx) + w[12];
        eax = eax << 6 | eax >>> 26;
        edx += (eax ^ ebx ^ ecx) + w[13];
        edx = edx << 7 | edx >>> 25;
        ecx += (edx ^ eax ^ ebx) + w[14];
        ecx = ecx << 9 | ecx >>> 23;
        ebx += (ecx ^ edx ^ eax) + w[15];
        ebx = ebx << 8 | ebx >>> 24;
        eax += (ebx & ecx | ~ebx & edx) + w[7] + 1518500249;
        eax = eax << 7 | eax >>> 25;
        edx += (eax & ebx | ~eax & ecx) + w[4] + 1518500249;
        edx = edx << 6 | edx >>> 26;
        ecx += (edx & eax | ~edx & ebx) + w[13] + 1518500249;
        ecx = ecx << 8 | ecx >>> 24;
        ebx += (ecx & edx | ~ecx & eax) + w[1] + 1518500249;
        ebx = ebx << 13 | ebx >>> 19;
        eax += (ebx & ecx | ~ebx & edx) + w[10] + 1518500249;
        eax = eax << 11 | eax >>> 21;
        edx += (eax & ebx | ~eax & ecx) + w[6] + 1518500249;
        edx = edx << 9 | edx >>> 23;
        ecx += (edx & eax | ~edx & ebx) + w[15] + 1518500249;
        ecx = ecx << 7 | ecx >>> 25;
        ebx += (ecx & edx | ~ecx & eax) + w[3] + 1518500249;
        ebx = ebx << 15 | ebx >>> 17;
        eax += (ebx & ecx | ~ebx & edx) + w[12] + 1518500249;
        eax = eax << 7 | eax >>> 25;
        edx += (eax & ebx | ~eax & ecx) + w[0] + 1518500249;
        edx = edx << 12 | edx >>> 20;
        ecx += (edx & eax | ~edx & ebx) + w[9] + 1518500249;
        ecx = ecx << 15 | ecx >>> 17;
        ebx += (ecx & edx | ~ecx & eax) + w[5] + 1518500249;
        ebx = ebx << 9 | ebx >>> 23;
        eax += (ebx & ecx | ~ebx & edx) + w[2] + 1518500249;
        eax = eax << 11 | eax >>> 21;
        edx += (eax & ebx | ~eax & ecx) + w[14] + 1518500249;
        edx = edx << 7 | edx >>> 25;
        ecx += (edx & eax | ~edx & ebx) + w[11] + 1518500249;
        ecx = ecx << 13 | ecx >>> 19;
        ebx += (ecx & edx | ~ecx & eax) + w[8] + 1518500249;
        ebx = ebx << 12 | ebx >>> 20;
        eax += ((ebx | ~ecx) ^ edx) + w[3] + 1859775393;
        eax = eax << 11 | eax >>> 21;
        edx += ((eax | ~ebx) ^ ecx) + w[10] + 1859775393;
        edx = edx << 13 | edx >>> 19;
        ecx += ((edx | ~eax) ^ ebx) + w[14] + 1859775393;
        ecx = ecx << 6 | ecx >>> 26;
        ebx += ((ecx | ~edx) ^ eax) + w[4] + 1859775393;
        ebx = ebx << 7 | ebx >>> 25;
        eax += ((ebx | ~ecx) ^ edx) + w[9] + 1859775393;
        eax = eax << 14 | eax >>> 18;
        edx += ((eax | ~ebx) ^ ecx) + w[15] + 1859775393;
        edx = edx << 9 | edx >>> 23;
        ecx += ((edx | ~eax) ^ ebx) + w[8] + 1859775393;
        ecx = ecx << 13 | ecx >>> 19;
        ebx += ((ecx | ~edx) ^ eax) + w[1] + 1859775393;
        ebx = ebx << 15 | ebx >>> 17;
        eax += ((ebx | ~ecx) ^ edx) + w[2] + 1859775393;
        eax = eax << 14 | eax >>> 18;
        edx += ((eax | ~ebx) ^ ecx) + w[7] + 1859775393;
        edx = edx << 8 | edx >>> 24;
        ecx += ((edx | ~eax) ^ ebx) + w[0] + 1859775393;
        ecx = ecx << 13 | ecx >>> 19;
        ebx += ((ecx | ~edx) ^ eax) + w[6] + 1859775393;
        ebx = ebx << 6 | ebx >>> 26;
        eax += ((ebx | ~ecx) ^ edx) + w[13] + 1859775393;
        eax = eax << 5 | eax >>> 27;
        edx += ((eax | ~ebx) ^ ecx) + w[11] + 1859775393;
        edx = edx << 12 | edx >>> 20;
        ecx += ((edx | ~eax) ^ ebx) + w[5] + 1859775393;
        ecx = ecx << 7 | ecx >>> 25;
        ebx += ((ecx | ~edx) ^ eax) + w[12] + 1859775393;
        ebx = ebx << 5 | ebx >>> 27;
        eax += (ebx & edx | ecx & ~edx) + w[1] + -1894007588;
        eax = eax << 11 | eax >>> 21;
        edx += (eax & ecx | ebx & ~ecx) + w[9] + -1894007588;
        edx = edx << 12 | edx >>> 20;
        ecx += (edx & ebx | eax & ~ebx) + w[11] + -1894007588;
        ecx = ecx << 14 | ecx >>> 18;
        ebx += (ecx & eax | edx & ~eax) + w[10] + -1894007588;
        ebx = ebx << 15 | ebx >>> 17;
        eax += (ebx & edx | ecx & ~edx) + w[0] + -1894007588;
        eax = eax << 14 | eax >>> 18;
        edx += (eax & ecx | ebx & ~ecx) + w[8] + -1894007588;
        edx = edx << 15 | edx >>> 17;
        ecx += (edx & ebx | eax & ~ebx) + w[12] + -1894007588;
        ecx = ecx << 9 | ecx >>> 23;
        ebx += (ecx & eax | edx & ~eax) + w[4] + -1894007588;
        ebx = ebx << 8 | ebx >>> 24;
        eax += (ebx & edx | ecx & ~edx) + w[13] + -1894007588;
        eax = eax << 9 | eax >>> 23;
        edx += (eax & ecx | ebx & ~ecx) + w[3] + -1894007588;
        edx = edx << 14 | edx >>> 18;
        ecx += (edx & ebx | eax & ~ebx) + w[7] + -1894007588;
        ecx = ecx << 5 | ecx >>> 27;
        ebx += (ecx & eax | edx & ~eax) + w[15] + -1894007588;
        ebx = ebx << 6 | ebx >>> 26;
        eax += (ebx & edx | ecx & ~edx) + w[14] + -1894007588;
        eax = eax << 8 | eax >>> 24;
        edx += (eax & ecx | ebx & ~ecx) + w[5] + -1894007588;
        edx = edx << 6 | edx >>> 26;
        ecx += (edx & ebx | eax & ~ebx) + w[6] + -1894007588;
        ecx = ecx << 5 | ecx >>> 27;
        ebx += (ecx & eax | edx & ~eax) + w[2] + -1894007588;
        ebx = ebx << 12 | ebx >>> 20;
        int EAX = this.H1;
        int EBX = this.H2;
        int ECX = this.H3;
        int EDX = this.H4;
        EAX += (EBX & EDX | ECX & ~EDX) + w[5] + 1352829926;
        EAX = EAX << 8 | EAX >>> 24;
        EDX += (EAX & ECX | EBX & ~ECX) + w[14] + 1352829926;
        EDX = EDX << 9 | EDX >>> 23;
        ECX += (EDX & EBX | EAX & ~EBX) + w[7] + 1352829926;
        ECX = ECX << 9 | ECX >>> 23;
        EBX += (ECX & EAX | EDX & ~EAX) + w[0] + 1352829926;
        EBX = EBX << 11 | EBX >>> 21;
        EAX += (EBX & EDX | ECX & ~EDX) + w[9] + 1352829926;
        EAX = EAX << 13 | EAX >>> 19;
        EDX += (EAX & ECX | EBX & ~ECX) + w[2] + 1352829926;
        EDX = EDX << 15 | EDX >>> 17;
        ECX += (EDX & EBX | EAX & ~EBX) + w[11] + 1352829926;
        ECX = ECX << 15 | ECX >>> 17;
        EBX += (ECX & EAX | EDX & ~EAX) + w[4] + 1352829926;
        EBX = EBX << 5 | EBX >>> 27;
        EAX += (EBX & EDX | ECX & ~EDX) + w[13] + 1352829926;
        EAX = EAX << 7 | EAX >>> 25;
        EDX += (EAX & ECX | EBX & ~ECX) + w[6] + 1352829926;
        EDX = EDX << 7 | EDX >>> 25;
        ECX += (EDX & EBX | EAX & ~EBX) + w[15] + 1352829926;
        ECX = ECX << 8 | ECX >>> 24;
        EBX += (ECX & EAX | EDX & ~EAX) + w[8] + 1352829926;
        EBX = EBX << 11 | EBX >>> 21;
        EAX += (EBX & EDX | ECX & ~EDX) + w[1] + 1352829926;
        EAX = EAX << 14 | EAX >>> 18;
        EDX += (EAX & ECX | EBX & ~ECX) + w[10] + 1352829926;
        EDX = EDX << 14 | EDX >>> 18;
        ECX += (EDX & EBX | EAX & ~EBX) + w[3] + 1352829926;
        ECX = ECX << 12 | ECX >>> 20;
        EBX += (ECX & EAX | EDX & ~EAX) + w[12] + 1352829926;
        EBX = EBX << 6 | EBX >>> 26;
        EAX += ((EBX | ~ECX) ^ EDX) + w[6] + 1548603684;
        EAX = EAX << 9 | EAX >>> 23;
        EDX += ((EAX | ~EBX) ^ ECX) + w[11] + 1548603684;
        EDX = EDX << 13 | EDX >>> 19;
        ECX += ((EDX | ~EAX) ^ EBX) + w[3] + 1548603684;
        ECX = ECX << 15 | ECX >>> 17;
        EBX += ((ECX | ~EDX) ^ EAX) + w[7] + 1548603684;
        EBX = EBX << 7 | EBX >>> 25;
        EAX += ((EBX | ~ECX) ^ EDX) + w[0] + 1548603684;
        EAX = EAX << 12 | EAX >>> 20;
        EDX += ((EAX | ~EBX) ^ ECX) + w[13] + 1548603684;
        EDX = EDX << 8 | EDX >>> 24;
        ECX += ((EDX | ~EAX) ^ EBX) + w[5] + 1548603684;
        ECX = ECX << 9 | ECX >>> 23;
        EBX += ((ECX | ~EDX) ^ EAX) + w[10] + 1548603684;
        EBX = EBX << 11 | EBX >>> 21;
        EAX += ((EBX | ~ECX) ^ EDX) + w[14] + 1548603684;
        EAX = EAX << 7 | EAX >>> 25;
        EDX += ((EAX | ~EBX) ^ ECX) + w[15] + 1548603684;
        EDX = EDX << 7 | EDX >>> 25;
        ECX += ((EDX | ~EAX) ^ EBX) + w[8] + 1548603684;
        ECX = ECX << 12 | ECX >>> 20;
        EBX += ((ECX | ~EDX) ^ EAX) + w[12] + 1548603684;
        EBX = EBX << 7 | EBX >>> 25;
        EAX += ((EBX | ~ECX) ^ EDX) + w[4] + 1548603684;
        EAX = EAX << 6 | EAX >>> 26;
        EDX += ((EAX | ~EBX) ^ ECX) + w[9] + 1548603684;
        EDX = EDX << 15 | EDX >>> 17;
        ECX += ((EDX | ~EAX) ^ EBX) + w[1] + 1548603684;
        ECX = ECX << 13 | ECX >>> 19;
        EBX += ((ECX | ~EDX) ^ EAX) + w[2] + 1548603684;
        EBX = EBX << 11 | EBX >>> 21;
        EAX += (EBX & ECX | ~EBX & EDX) + w[15] + 1836072691;
        EAX = EAX << 9 | EAX >>> 23;
        EDX += (EAX & EBX | ~EAX & ECX) + w[5] + 1836072691;
        EDX = EDX << 7 | EDX >>> 25;
        ECX += (EDX & EAX | ~EDX & EBX) + w[1] + 1836072691;
        ECX = ECX << 15 | ECX >>> 17;
        EBX += (ECX & EDX | ~ECX & EAX) + w[3] + 1836072691;
        EBX = EBX << 11 | EBX >>> 21;
        EAX += (EBX & ECX | ~EBX & EDX) + w[7] + 1836072691;
        EAX = EAX << 8 | EAX >>> 24;
        EDX += (EAX & EBX | ~EAX & ECX) + w[14] + 1836072691;
        EDX = EDX << 6 | EDX >>> 26;
        ECX += (EDX & EAX | ~EDX & EBX) + w[6] + 1836072691;
        ECX = ECX << 6 | ECX >>> 26;
        EBX += (ECX & EDX | ~ECX & EAX) + w[9] + 1836072691;
        EBX = EBX << 14 | EBX >>> 18;
        EAX += (EBX & ECX | ~EBX & EDX) + w[11] + 1836072691;
        EAX = EAX << 12 | EAX >>> 20;
        EDX += (EAX & EBX | ~EAX & ECX) + w[8] + 1836072691;
        EDX = EDX << 13 | EDX >>> 19;
        ECX += (EDX & EAX | ~EDX & EBX) + w[12] + 1836072691;
        ECX = ECX << 5 | ECX >>> 27;
        EBX += (ECX & EDX | ~ECX & EAX) + w[2] + 1836072691;
        EBX = EBX << 14 | EBX >>> 18;
        EAX += (EBX & ECX | ~EBX & EDX) + w[10] + 1836072691;
        EAX = EAX << 13 | EAX >>> 19;
        EDX += (EAX & EBX | ~EAX & ECX) + w[0] + 1836072691;
        EDX = EDX << 13 | EDX >>> 19;
        ECX += (EDX & EAX | ~EDX & EBX) + w[4] + 1836072691;
        ECX = ECX << 7 | ECX >>> 25;
        EBX += (ECX & EDX | ~ECX & EAX) + w[13] + 1836072691;
        EBX = EBX << 5 | EBX >>> 27;
        EAX += (EBX ^ ECX ^ EDX) + w[8];
        EAX = EAX << 15 | EAX >>> 17;
        EDX += (EAX ^ EBX ^ ECX) + w[6];
        EDX = EDX << 5 | EDX >>> 27;
        ECX += (EDX ^ EAX ^ EBX) + w[4];
        ECX = ECX << 8 | ECX >>> 24;
        EBX += (ECX ^ EDX ^ EAX) + w[1];
        EBX = EBX << 11 | EBX >>> 21;
        EAX += (EBX ^ ECX ^ EDX) + w[3];
        EAX = EAX << 14 | EAX >>> 18;
        EDX += (EAX ^ EBX ^ ECX) + w[11];
        EDX = EDX << 14 | EDX >>> 18;
        ECX += (EDX ^ EAX ^ EBX) + w[15];
        ECX = ECX << 6 | ECX >>> 26;
        EBX += (ECX ^ EDX ^ EAX) + w[0];
        EBX = EBX << 14 | EBX >>> 18;
        EAX += (EBX ^ ECX ^ EDX) + w[5];
        EAX = EAX << 6 | EAX >>> 26;
        EDX += (EAX ^ EBX ^ ECX) + w[12];
        EDX = EDX << 9 | EDX >>> 23;
        ECX += (EDX ^ EAX ^ EBX) + w[2];
        ECX = ECX << 12 | ECX >>> 20;
        EBX += (ECX ^ EDX ^ EAX) + w[13];
        EBX = EBX << 9 | EBX >>> 23;
        EAX += (EBX ^ ECX ^ EDX) + w[9];
        EAX = EAX << 12 | EAX >>> 20;
        EDX += (EAX ^ EBX ^ ECX) + w[7];
        EDX = EDX << 5 | EDX >>> 27;
        ECX += (EDX ^ EAX ^ EBX) + w[10];
        ECX = ECX << 15 | ECX >>> 17;
        EBX += (ECX ^ EDX ^ EAX) + w[14];
        EBX = EBX << 8 | EBX >>> 24;
        Convert.lendian_int2byte(this.state, 0, this.H2 + ecx + EDX);
        Convert.lendian_int2byte(this.state, 4, this.H3 + edx + EAX);
        Convert.lendian_int2byte(this.state, 8, this.H4 + eax + EBX);
        Convert.lendian_int2byte(this.state, 12, this.H1 + ebx + ECX);
    }

    protected int pad(HashPadMode pmode) {
        HashPad.RIPEMD128Pad(this);
        return 1;
    }
}

