/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.hash;

import com.cryptomathic.crypto.hash.HashPad;
import com.cryptomathic.crypto.hash.HashPadMode;
import com.cryptomathic.crypto.hash.HashState;
import com.cryptomathic.crypto.hash.HashType;
import com.cryptomathic.crypto.util.Convert;

class StateRIPEMD160
extends HashState {
    private static int h1 = 1732584193;
    private static int h2 = -271733879;
    private static int h3 = -1732584194;
    private static int h4 = 271733878;
    private static int h5 = -1009589776;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int H5;

    protected StateRIPEMD160() {
        this.block_size = 64;
        this.buffer = new byte[2 * this.block_size];
        this.state = new byte[20];
        Convert.lendian_int2byte(this.state, 0, h1);
        Convert.lendian_int2byte(this.state, 4, h2);
        Convert.lendian_int2byte(this.state, 8, h3);
        Convert.lendian_int2byte(this.state, 12, h4);
        Convert.lendian_int2byte(this.state, 16, h5);
        this.hash_size = 20;
        this.hashtype = HashType.RIPEMD160;
    }

    protected void hash(byte[] mes, int offset) {
        int[] w = new int[16];
        this.H1 = Convert.lendian_byte2int(this.state, 0);
        this.H2 = Convert.lendian_byte2int(this.state, 4);
        this.H3 = Convert.lendian_byte2int(this.state, 8);
        this.H4 = Convert.lendian_byte2int(this.state, 12);
        this.H5 = Convert.lendian_byte2int(this.state, 16);
        for (int i = 0; i < 16; ++i) {
            w[i] = Convert.lendian_byte2int(mes, 4 * i + offset);
        }
        int eax = this.H1;
        int ebx = this.H2;
        int ecx = this.H3;
        int edx = this.H4;
        int eex = this.H5;
        eax += (ebx ^ ecx ^ edx) + w[0];
        eax = (eax << 11 | eax >>> 21) + eex;
        ecx = ecx << 10 | ecx >>> 22;
        eex += (eax ^ ebx ^ ecx) + w[1];
        eex = (eex << 14 | eex >>> 18) + edx;
        ebx = ebx << 10 | ebx >>> 22;
        edx += (eex ^ eax ^ ebx) + w[2];
        edx = (edx << 15 | edx >>> 17) + ecx;
        eax = eax << 10 | eax >>> 22;
        ecx += (edx ^ eex ^ eax) + w[3];
        ecx = (ecx << 12 | ecx >>> 20) + ebx;
        eex = eex << 10 | eex >>> 22;
        ebx += (ecx ^ edx ^ eex) + w[4];
        ebx = (ebx << 5 | ebx >>> 27) + eax;
        edx = edx << 10 | edx >>> 22;
        eax += (ebx ^ ecx ^ edx) + w[5];
        eax = (eax << 8 | eax >>> 24) + eex;
        ecx = ecx << 10 | ecx >>> 22;
        eex += (eax ^ ebx ^ ecx) + w[6];
        eex = (eex << 7 | eex >>> 25) + edx;
        ebx = ebx << 10 | ebx >>> 22;
        edx += (eex ^ eax ^ ebx) + w[7];
        edx = (edx << 9 | edx >>> 23) + ecx;
        eax = eax << 10 | eax >>> 22;
        ecx += (edx ^ eex ^ eax) + w[8];
        ecx = (ecx << 11 | ecx >>> 21) + ebx;
        eex = eex << 10 | eex >>> 22;
        ebx += (ecx ^ edx ^ eex) + w[9];
        ebx = (ebx << 13 | ebx >>> 19) + eax;
        edx = edx << 10 | edx >>> 22;
        eax += (ebx ^ ecx ^ edx) + w[10];
        eax = (eax << 14 | eax >>> 18) + eex;
        ecx = ecx << 10 | ecx >>> 22;
        eex += (eax ^ ebx ^ ecx) + w[11];
        eex = (eex << 15 | eex >>> 17) + edx;
        ebx = ebx << 10 | ebx >>> 22;
        edx += (eex ^ eax ^ ebx) + w[12];
        edx = (edx << 6 | edx >>> 26) + ecx;
        eax = eax << 10 | eax >>> 22;
        ecx += (edx ^ eex ^ eax) + w[13];
        ecx = (ecx << 7 | ecx >>> 25) + ebx;
        eex = eex << 10 | eex >>> 22;
        ebx += (ecx ^ edx ^ eex) + w[14];
        ebx = (ebx << 9 | ebx >>> 23) + eax;
        edx = edx << 10 | edx >>> 22;
        eax += (ebx ^ ecx ^ edx) + w[15];
        eax = (eax << 8 | eax >>> 24) + eex;
        ecx = ecx << 10 | ecx >>> 22;
        eex += (eax & ebx | ~eax & ecx) + w[7] + 1518500249;
        eex = (eex << 7 | eex >>> 25) + edx;
        ebx = ebx << 10 | ebx >>> 22;
        edx += (eex & eax | ~eex & ebx) + w[4] + 1518500249;
        edx = (edx << 6 | edx >>> 26) + ecx;
        eax = eax << 10 | eax >>> 22;
        ecx += (edx & eex | ~edx & eax) + w[13] + 1518500249;
        ecx = (ecx << 8 | ecx >>> 24) + ebx;
        eex = eex << 10 | eex >>> 22;
        ebx += (ecx & edx | ~ecx & eex) + w[1] + 1518500249;
        ebx = (ebx << 13 | ebx >>> 19) + eax;
        edx = edx << 10 | edx >>> 22;
        eax += (ebx & ecx | ~ebx & edx) + w[10] + 1518500249;
        eax = (eax << 11 | eax >>> 21) + eex;
        ecx = ecx << 10 | ecx >>> 22;
        eex += (eax & ebx | ~eax & ecx) + w[6] + 1518500249;
        eex = (eex << 9 | eex >>> 23) + edx;
        ebx = ebx << 10 | ebx >>> 22;
        edx += (eex & eax | ~eex & ebx) + w[15] + 1518500249;
        edx = (edx << 7 | edx >>> 25) + ecx;
        eax = eax << 10 | eax >>> 22;
        ecx += (edx & eex | ~edx & eax) + w[3] + 1518500249;
        ecx = (ecx << 15 | ecx >>> 17) + ebx;
        eex = eex << 10 | eex >>> 22;
        ebx += (ecx & edx | ~ecx & eex) + w[12] + 1518500249;
        ebx = (ebx << 7 | ebx >>> 25) + eax;
        edx = edx << 10 | edx >>> 22;
        eax += (ebx & ecx | ~ebx & edx) + w[0] + 1518500249;
        eax = (eax << 12 | eax >>> 20) + eex;
        ecx = ecx << 10 | ecx >>> 22;
        eex += (eax & ebx | ~eax & ecx) + w[9] + 1518500249;
        eex = (eex << 15 | eex >>> 17) + edx;
        ebx = ebx << 10 | ebx >>> 22;
        edx += (eex & eax | ~eex & ebx) + w[5] + 1518500249;
        edx = (edx << 9 | edx >>> 23) + ecx;
        eax = eax << 10 | eax >>> 22;
        ecx += (edx & eex | ~edx & eax) + w[2] + 1518500249;
        ecx = (ecx << 11 | ecx >>> 21) + ebx;
        eex = eex << 10 | eex >>> 22;
        ebx += (ecx & edx | ~ecx & eex) + w[14] + 1518500249;
        ebx = (ebx << 7 | ebx >>> 25) + eax;
        edx = edx << 10 | edx >>> 22;
        eax += (ebx & ecx | ~ebx & edx) + w[11] + 1518500249;
        eax = (eax << 13 | eax >>> 19) + eex;
        ecx = ecx << 10 | ecx >>> 22;
        eex += (eax & ebx | ~eax & ecx) + w[8] + 1518500249;
        eex = (eex << 12 | eex >>> 20) + edx;
        ebx = ebx << 10 | ebx >>> 22;
        edx += ((eex | ~eax) ^ ebx) + w[3] + 1859775393;
        edx = (edx << 11 | edx >>> 21) + ecx;
        eax = eax << 10 | eax >>> 22;
        ecx += ((edx | ~eex) ^ eax) + w[10] + 1859775393;
        ecx = (ecx << 13 | ecx >>> 19) + ebx;
        eex = eex << 10 | eex >>> 22;
        ebx += ((ecx | ~edx) ^ eex) + w[14] + 1859775393;
        ebx = (ebx << 6 | ebx >>> 26) + eax;
        edx = edx << 10 | edx >>> 22;
        eax += ((ebx | ~ecx) ^ edx) + w[4] + 1859775393;
        eax = (eax << 7 | eax >>> 25) + eex;
        ecx = ecx << 10 | ecx >>> 22;
        eex += ((eax | ~ebx) ^ ecx) + w[9] + 1859775393;
        eex = (eex << 14 | eex >>> 18) + edx;
        ebx = ebx << 10 | ebx >>> 22;
        edx += ((eex | ~eax) ^ ebx) + w[15] + 1859775393;
        edx = (edx << 9 | edx >>> 23) + ecx;
        eax = eax << 10 | eax >>> 22;
        ecx += ((edx | ~eex) ^ eax) + w[8] + 1859775393;
        ecx = (ecx << 13 | ecx >>> 19) + ebx;
        eex = eex << 10 | eex >>> 22;
        ebx += ((ecx | ~edx) ^ eex) + w[1] + 1859775393;
        ebx = (ebx << 15 | ebx >>> 17) + eax;
        edx = edx << 10 | edx >>> 22;
        eax += ((ebx | ~ecx) ^ edx) + w[2] + 1859775393;
        eax = (eax << 14 | eax >>> 18) + eex;
        ecx = ecx << 10 | ecx >>> 22;
        eex += ((eax | ~ebx) ^ ecx) + w[7] + 1859775393;
        eex = (eex << 8 | eex >>> 24) + edx;
        ebx = ebx << 10 | ebx >>> 22;
        edx += ((eex | ~eax) ^ ebx) + w[0] + 1859775393;
        edx = (edx << 13 | edx >>> 19) + ecx;
        eax = eax << 10 | eax >>> 22;
        ecx += ((edx | ~eex) ^ eax) + w[6] + 1859775393;
        ecx = (ecx << 6 | ecx >>> 26) + ebx;
        eex = eex << 10 | eex >>> 22;
        ebx += ((ecx | ~edx) ^ eex) + w[13] + 1859775393;
        ebx = (ebx << 5 | ebx >>> 27) + eax;
        edx = edx << 10 | edx >>> 22;
        eax += ((ebx | ~ecx) ^ edx) + w[11] + 1859775393;
        eax = (eax << 12 | eax >>> 20) + eex;
        ecx = ecx << 10 | ecx >>> 22;
        eex += ((eax | ~ebx) ^ ecx) + w[5] + 1859775393;
        eex = (eex << 7 | eex >>> 25) + edx;
        ebx = ebx << 10 | ebx >>> 22;
        edx += ((eex | ~eax) ^ ebx) + w[12] + 1859775393;
        edx = (edx << 5 | edx >>> 27) + ecx;
        eax = eax << 10 | eax >>> 22;
        ecx += (edx & eax | eex & ~eax) + w[1] + -1894007588;
        ecx = (ecx << 11 | ecx >>> 21) + ebx;
        eex = eex << 10 | eex >>> 22;
        ebx += (ecx & eex | edx & ~eex) + w[9] + -1894007588;
        ebx = (ebx << 12 | ebx >>> 20) + eax;
        edx = edx << 10 | edx >>> 22;
        eax += (ebx & edx | ecx & ~edx) + w[11] + -1894007588;
        eax = (eax << 14 | eax >>> 18) + eex;
        ecx = ecx << 10 | ecx >>> 22;
        eex += (eax & ecx | ebx & ~ecx) + w[10] + -1894007588;
        eex = (eex << 15 | eex >>> 17) + edx;
        ebx = ebx << 10 | ebx >>> 22;
        edx += (eex & ebx | eax & ~ebx) + w[0] + -1894007588;
        edx = (edx << 14 | edx >>> 18) + ecx;
        eax = eax << 10 | eax >>> 22;
        ecx += (edx & eax | eex & ~eax) + w[8] + -1894007588;
        ecx = (ecx << 15 | ecx >>> 17) + ebx;
        eex = eex << 10 | eex >>> 22;
        ebx += (ecx & eex | edx & ~eex) + w[12] + -1894007588;
        ebx = (ebx << 9 | ebx >>> 23) + eax;
        edx = edx << 10 | edx >>> 22;
        eax += (ebx & edx | ecx & ~edx) + w[4] + -1894007588;
        eax = (eax << 8 | eax >>> 24) + eex;
        ecx = ecx << 10 | ecx >>> 22;
        eex += (eax & ecx | ebx & ~ecx) + w[13] + -1894007588;
        eex = (eex << 9 | eex >>> 23) + edx;
        ebx = ebx << 10 | ebx >>> 22;
        edx += (eex & ebx | eax & ~ebx) + w[3] + -1894007588;
        edx = (edx << 14 | edx >>> 18) + ecx;
        eax = eax << 10 | eax >>> 22;
        ecx += (edx & eax | eex & ~eax) + w[7] + -1894007588;
        ecx = (ecx << 5 | ecx >>> 27) + ebx;
        eex = eex << 10 | eex >>> 22;
        ebx += (ecx & eex | edx & ~eex) + w[15] + -1894007588;
        ebx = (ebx << 6 | ebx >>> 26) + eax;
        edx = edx << 10 | edx >>> 22;
        eax += (ebx & edx | ecx & ~edx) + w[14] + -1894007588;
        eax = (eax << 8 | eax >>> 24) + eex;
        ecx = ecx << 10 | ecx >>> 22;
        eex += (eax & ecx | ebx & ~ecx) + w[5] + -1894007588;
        eex = (eex << 6 | eex >>> 26) + edx;
        ebx = ebx << 10 | ebx >>> 22;
        edx += (eex & ebx | eax & ~ebx) + w[6] + -1894007588;
        edx = (edx << 5 | edx >>> 27) + ecx;
        eax = eax << 10 | eax >>> 22;
        ecx += (edx & eax | eex & ~eax) + w[2] + -1894007588;
        ecx = (ecx << 12 | ecx >>> 20) + ebx;
        eex = eex << 10 | eex >>> 22;
        ebx += (ecx ^ (edx | ~eex)) + w[4] + -1454113458;
        ebx = (ebx << 9 | ebx >>> 23) + eax;
        edx = edx << 10 | edx >>> 22;
        eax += (ebx ^ (ecx | ~edx)) + w[0] + -1454113458;
        eax = (eax << 15 | eax >>> 17) + eex;
        ecx = ecx << 10 | ecx >>> 22;
        eex += (eax ^ (ebx | ~ecx)) + w[5] + -1454113458;
        eex = (eex << 5 | eex >>> 27) + edx;
        ebx = ebx << 10 | ebx >>> 22;
        edx += (eex ^ (eax | ~ebx)) + w[9] + -1454113458;
        edx = (edx << 11 | edx >>> 21) + ecx;
        eax = eax << 10 | eax >>> 22;
        ecx += (edx ^ (eex | ~eax)) + w[7] + -1454113458;
        ecx = (ecx << 6 | ecx >>> 26) + ebx;
        eex = eex << 10 | eex >>> 22;
        ebx += (ecx ^ (edx | ~eex)) + w[12] + -1454113458;
        ebx = (ebx << 8 | ebx >>> 24) + eax;
        edx = edx << 10 | edx >>> 22;
        eax += (ebx ^ (ecx | ~edx)) + w[2] + -1454113458;
        eax = (eax << 13 | eax >>> 19) + eex;
        ecx = ecx << 10 | ecx >>> 22;
        eex += (eax ^ (ebx | ~ecx)) + w[10] + -1454113458;
        eex = (eex << 12 | eex >>> 20) + edx;
        ebx = ebx << 10 | ebx >>> 22;
        edx += (eex ^ (eax | ~ebx)) + w[14] + -1454113458;
        edx = (edx << 5 | edx >>> 27) + ecx;
        eax = eax << 10 | eax >>> 22;
        ecx += (edx ^ (eex | ~eax)) + w[1] + -1454113458;
        ecx = (ecx << 12 | ecx >>> 20) + ebx;
        eex = eex << 10 | eex >>> 22;
        ebx += (ecx ^ (edx | ~eex)) + w[3] + -1454113458;
        ebx = (ebx << 13 | ebx >>> 19) + eax;
        edx = edx << 10 | edx >>> 22;
        eax += (ebx ^ (ecx | ~edx)) + w[8] + -1454113458;
        eax = (eax << 14 | eax >>> 18) + eex;
        ecx = ecx << 10 | ecx >>> 22;
        eex += (eax ^ (ebx | ~ecx)) + w[11] + -1454113458;
        eex = (eex << 11 | eex >>> 21) + edx;
        ebx = ebx << 10 | ebx >>> 22;
        edx += (eex ^ (eax | ~ebx)) + w[6] + -1454113458;
        edx = (edx << 8 | edx >>> 24) + ecx;
        eax = eax << 10 | eax >>> 22;
        ecx += (edx ^ (eex | ~eax)) + w[15] + -1454113458;
        ecx = (ecx << 5 | ecx >>> 27) + ebx;
        eex = eex << 10 | eex >>> 22;
        ebx += (ecx ^ (edx | ~eex)) + w[13] + -1454113458;
        ebx = (ebx << 6 | ebx >>> 26) + eax;
        edx = edx << 10 | edx >>> 22;
        int EAX = this.H1;
        int EBX = this.H2;
        int ECX = this.H3;
        int EDX = this.H4;
        int EEX = this.H5;
        EAX += (EBX ^ (ECX | ~EDX)) + w[5] + 1352829926;
        EAX = (EAX << 8 | EAX >>> 24) + EEX;
        ECX = ECX << 10 | ECX >>> 22;
        EEX += (EAX ^ (EBX | ~ECX)) + w[14] + 1352829926;
        EEX = (EEX << 9 | EEX >>> 23) + EDX;
        EBX = EBX << 10 | EBX >>> 22;
        EDX += (EEX ^ (EAX | ~EBX)) + w[7] + 1352829926;
        EDX = (EDX << 9 | EDX >>> 23) + ECX;
        EAX = EAX << 10 | EAX >>> 22;
        ECX += (EDX ^ (EEX | ~EAX)) + w[0] + 1352829926;
        ECX = (ECX << 11 | ECX >>> 21) + EBX;
        EEX = EEX << 10 | EEX >>> 22;
        EBX += (ECX ^ (EDX | ~EEX)) + w[9] + 1352829926;
        EBX = (EBX << 13 | EBX >>> 19) + EAX;
        EDX = EDX << 10 | EDX >>> 22;
        EAX += (EBX ^ (ECX | ~EDX)) + w[2] + 1352829926;
        EAX = (EAX << 15 | EAX >>> 17) + EEX;
        ECX = ECX << 10 | ECX >>> 22;
        EEX += (EAX ^ (EBX | ~ECX)) + w[11] + 1352829926;
        EEX = (EEX << 15 | EEX >>> 17) + EDX;
        EBX = EBX << 10 | EBX >>> 22;
        EDX += (EEX ^ (EAX | ~EBX)) + w[4] + 1352829926;
        EDX = (EDX << 5 | EDX >>> 27) + ECX;
        EAX = EAX << 10 | EAX >>> 22;
        ECX += (EDX ^ (EEX | ~EAX)) + w[13] + 1352829926;
        ECX = (ECX << 7 | ECX >>> 25) + EBX;
        EEX = EEX << 10 | EEX >>> 22;
        EBX += (ECX ^ (EDX | ~EEX)) + w[6] + 1352829926;
        EBX = (EBX << 7 | EBX >>> 25) + EAX;
        EDX = EDX << 10 | EDX >>> 22;
        EAX += (EBX ^ (ECX | ~EDX)) + w[15] + 1352829926;
        EAX = (EAX << 8 | EAX >>> 24) + EEX;
        ECX = ECX << 10 | ECX >>> 22;
        EEX += (EAX ^ (EBX | ~ECX)) + w[8] + 1352829926;
        EEX = (EEX << 11 | EEX >>> 21) + EDX;
        EBX = EBX << 10 | EBX >>> 22;
        EDX += (EEX ^ (EAX | ~EBX)) + w[1] + 1352829926;
        EDX = (EDX << 14 | EDX >>> 18) + ECX;
        EAX = EAX << 10 | EAX >>> 22;
        ECX += (EDX ^ (EEX | ~EAX)) + w[10] + 1352829926;
        ECX = (ECX << 14 | ECX >>> 18) + EBX;
        EEX = EEX << 10 | EEX >>> 22;
        EBX += (ECX ^ (EDX | ~EEX)) + w[3] + 1352829926;
        EBX = (EBX << 12 | EBX >>> 20) + EAX;
        EDX = EDX << 10 | EDX >>> 22;
        EAX += (EBX ^ (ECX | ~EDX)) + w[12] + 1352829926;
        EAX = (EAX << 6 | EAX >>> 26) + EEX;
        ECX = ECX << 10 | ECX >>> 22;
        EEX += (EAX & ECX | EBX & ~ECX) + w[6] + 1548603684;
        EEX = (EEX << 9 | EEX >>> 23) + EDX;
        EBX = EBX << 10 | EBX >>> 22;
        EDX += (EEX & EBX | EAX & ~EBX) + w[11] + 1548603684;
        EDX = (EDX << 13 | EDX >>> 19) + ECX;
        EAX = EAX << 10 | EAX >>> 22;
        ECX += (EDX & EAX | EEX & ~EAX) + w[3] + 1548603684;
        ECX = (ECX << 15 | ECX >>> 17) + EBX;
        EEX = EEX << 10 | EEX >>> 22;
        EBX += (ECX & EEX | EDX & ~EEX) + w[7] + 1548603684;
        EBX = (EBX << 7 | EBX >>> 25) + EAX;
        EDX = EDX << 10 | EDX >>> 22;
        EAX += (EBX & EDX | ECX & ~EDX) + w[0] + 1548603684;
        EAX = (EAX << 12 | EAX >>> 20) + EEX;
        ECX = ECX << 10 | ECX >>> 22;
        EEX += (EAX & ECX | EBX & ~ECX) + w[13] + 1548603684;
        EEX = (EEX << 8 | EEX >>> 24) + EDX;
        EBX = EBX << 10 | EBX >>> 22;
        EDX += (EEX & EBX | EAX & ~EBX) + w[5] + 1548603684;
        EDX = (EDX << 9 | EDX >>> 23) + ECX;
        EAX = EAX << 10 | EAX >>> 22;
        ECX += (EDX & EAX | EEX & ~EAX) + w[10] + 1548603684;
        ECX = (ECX << 11 | ECX >>> 21) + EBX;
        EEX = EEX << 10 | EEX >>> 22;
        EBX += (ECX & EEX | EDX & ~EEX) + w[14] + 1548603684;
        EBX = (EBX << 7 | EBX >>> 25) + EAX;
        EDX = EDX << 10 | EDX >>> 22;
        EAX += (EBX & EDX | ECX & ~EDX) + w[15] + 1548603684;
        EAX = (EAX << 7 | EAX >>> 25) + EEX;
        ECX = ECX << 10 | ECX >>> 22;
        EEX += (EAX & ECX | EBX & ~ECX) + w[8] + 1548603684;
        EEX = (EEX << 12 | EEX >>> 20) + EDX;
        EBX = EBX << 10 | EBX >>> 22;
        EDX += (EEX & EBX | EAX & ~EBX) + w[12] + 1548603684;
        EDX = (EDX << 7 | EDX >>> 25) + ECX;
        EAX = EAX << 10 | EAX >>> 22;
        ECX += (EDX & EAX | EEX & ~EAX) + w[4] + 1548603684;
        ECX = (ECX << 6 | ECX >>> 26) + EBX;
        EEX = EEX << 10 | EEX >>> 22;
        EBX += (ECX & EEX | EDX & ~EEX) + w[9] + 1548603684;
        EBX = (EBX << 15 | EBX >>> 17) + EAX;
        EDX = EDX << 10 | EDX >>> 22;
        EAX += (EBX & EDX | ECX & ~EDX) + w[1] + 1548603684;
        EAX = (EAX << 13 | EAX >>> 19) + EEX;
        ECX = ECX << 10 | ECX >>> 22;
        EEX += (EAX & ECX | EBX & ~ECX) + w[2] + 1548603684;
        EEX = (EEX << 11 | EEX >>> 21) + EDX;
        EBX = EBX << 10 | EBX >>> 22;
        EDX += ((EEX | ~EAX) ^ EBX) + w[15] + 1836072691;
        EDX = (EDX << 9 | EDX >>> 23) + ECX;
        EAX = EAX << 10 | EAX >>> 22;
        ECX += ((EDX | ~EEX) ^ EAX) + w[5] + 1836072691;
        ECX = (ECX << 7 | ECX >>> 25) + EBX;
        EEX = EEX << 10 | EEX >>> 22;
        EBX += ((ECX | ~EDX) ^ EEX) + w[1] + 1836072691;
        EBX = (EBX << 15 | EBX >>> 17) + EAX;
        EDX = EDX << 10 | EDX >>> 22;
        EAX += ((EBX | ~ECX) ^ EDX) + w[3] + 1836072691;
        EAX = (EAX << 11 | EAX >>> 21) + EEX;
        ECX = ECX << 10 | ECX >>> 22;
        EEX += ((EAX | ~EBX) ^ ECX) + w[7] + 1836072691;
        EEX = (EEX << 8 | EEX >>> 24) + EDX;
        EBX = EBX << 10 | EBX >>> 22;
        EDX += ((EEX | ~EAX) ^ EBX) + w[14] + 1836072691;
        EDX = (EDX << 6 | EDX >>> 26) + ECX;
        EAX = EAX << 10 | EAX >>> 22;
        ECX += ((EDX | ~EEX) ^ EAX) + w[6] + 1836072691;
        ECX = (ECX << 6 | ECX >>> 26) + EBX;
        EEX = EEX << 10 | EEX >>> 22;
        EBX += ((ECX | ~EDX) ^ EEX) + w[9] + 1836072691;
        EBX = (EBX << 14 | EBX >>> 18) + EAX;
        EDX = EDX << 10 | EDX >>> 22;
        EAX += ((EBX | ~ECX) ^ EDX) + w[11] + 1836072691;
        EAX = (EAX << 12 | EAX >>> 20) + EEX;
        ECX = ECX << 10 | ECX >>> 22;
        EEX += ((EAX | ~EBX) ^ ECX) + w[8] + 1836072691;
        EEX = (EEX << 13 | EEX >>> 19) + EDX;
        EBX = EBX << 10 | EBX >>> 22;
        EDX += ((EEX | ~EAX) ^ EBX) + w[12] + 1836072691;
        EDX = (EDX << 5 | EDX >>> 27) + ECX;
        EAX = EAX << 10 | EAX >>> 22;
        ECX += ((EDX | ~EEX) ^ EAX) + w[2] + 1836072691;
        ECX = (ECX << 14 | ECX >>> 18) + EBX;
        EEX = EEX << 10 | EEX >>> 22;
        EBX += ((ECX | ~EDX) ^ EEX) + w[10] + 1836072691;
        EBX = (EBX << 13 | EBX >>> 19) + EAX;
        EDX = EDX << 10 | EDX >>> 22;
        EAX += ((EBX | ~ECX) ^ EDX) + w[0] + 1836072691;
        EAX = (EAX << 13 | EAX >>> 19) + EEX;
        ECX = ECX << 10 | ECX >>> 22;
        EEX += ((EAX | ~EBX) ^ ECX) + w[4] + 1836072691;
        EEX = (EEX << 7 | EEX >>> 25) + EDX;
        EBX = EBX << 10 | EBX >>> 22;
        EDX += ((EEX | ~EAX) ^ EBX) + w[13] + 1836072691;
        EDX = (EDX << 5 | EDX >>> 27) + ECX;
        EAX = EAX << 10 | EAX >>> 22;
        ECX += (EDX & EEX | ~EDX & EAX) + w[8] + 2053994217;
        ECX = (ECX << 15 | ECX >>> 17) + EBX;
        EEX = EEX << 10 | EEX >>> 22;
        EBX += (ECX & EDX | ~ECX & EEX) + w[6] + 2053994217;
        EBX = (EBX << 5 | EBX >>> 27) + EAX;
        EDX = EDX << 10 | EDX >>> 22;
        EAX += (EBX & ECX | ~EBX & EDX) + w[4] + 2053994217;
        EAX = (EAX << 8 | EAX >>> 24) + EEX;
        ECX = ECX << 10 | ECX >>> 22;
        EEX += (EAX & EBX | ~EAX & ECX) + w[1] + 2053994217;
        EEX = (EEX << 11 | EEX >>> 21) + EDX;
        EBX = EBX << 10 | EBX >>> 22;
        EDX += (EEX & EAX | ~EEX & EBX) + w[3] + 2053994217;
        EDX = (EDX << 14 | EDX >>> 18) + ECX;
        EAX = EAX << 10 | EAX >>> 22;
        ECX += (EDX & EEX | ~EDX & EAX) + w[11] + 2053994217;
        ECX = (ECX << 14 | ECX >>> 18) + EBX;
        EEX = EEX << 10 | EEX >>> 22;
        EBX += (ECX & EDX | ~ECX & EEX) + w[15] + 2053994217;
        EBX = (EBX << 6 | EBX >>> 26) + EAX;
        EDX = EDX << 10 | EDX >>> 22;
        EAX += (EBX & ECX | ~EBX & EDX) + w[0] + 2053994217;
        EAX = (EAX << 14 | EAX >>> 18) + EEX;
        ECX = ECX << 10 | ECX >>> 22;
        EEX += (EAX & EBX | ~EAX & ECX) + w[5] + 2053994217;
        EEX = (EEX << 6 | EEX >>> 26) + EDX;
        EBX = EBX << 10 | EBX >>> 22;
        EDX += (EEX & EAX | ~EEX & EBX) + w[12] + 2053994217;
        EDX = (EDX << 9 | EDX >>> 23) + ECX;
        EAX = EAX << 10 | EAX >>> 22;
        ECX += (EDX & EEX | ~EDX & EAX) + w[2] + 2053994217;
        ECX = (ECX << 12 | ECX >>> 20) + EBX;
        EEX = EEX << 10 | EEX >>> 22;
        EBX += (ECX & EDX | ~ECX & EEX) + w[13] + 2053994217;
        EBX = (EBX << 9 | EBX >>> 23) + EAX;
        EDX = EDX << 10 | EDX >>> 22;
        EAX += (EBX & ECX | ~EBX & EDX) + w[9] + 2053994217;
        EAX = (EAX << 12 | EAX >>> 20) + EEX;
        ECX = ECX << 10 | ECX >>> 22;
        EEX += (EAX & EBX | ~EAX & ECX) + w[7] + 2053994217;
        EEX = (EEX << 5 | EEX >>> 27) + EDX;
        EBX = EBX << 10 | EBX >>> 22;
        EDX += (EEX & EAX | ~EEX & EBX) + w[10] + 2053994217;
        EDX = (EDX << 15 | EDX >>> 17) + ECX;
        EAX = EAX << 10 | EAX >>> 22;
        ECX += (EDX & EEX | ~EDX & EAX) + w[14] + 2053994217;
        ECX = (ECX << 8 | ECX >>> 24) + EBX;
        EEX = EEX << 10 | EEX >>> 22;
        EBX += (ECX ^ EDX ^ EEX) + w[12];
        EBX = (EBX << 8 | EBX >>> 24) + EAX;
        EDX = EDX << 10 | EDX >>> 22;
        EAX += (EBX ^ ECX ^ EDX) + w[15];
        EAX = (EAX << 5 | EAX >>> 27) + EEX;
        ECX = ECX << 10 | ECX >>> 22;
        EEX += (EAX ^ EBX ^ ECX) + w[10];
        EEX = (EEX << 12 | EEX >>> 20) + EDX;
        EBX = EBX << 10 | EBX >>> 22;
        EDX += (EEX ^ EAX ^ EBX) + w[4];
        EDX = (EDX << 9 | EDX >>> 23) + ECX;
        EAX = EAX << 10 | EAX >>> 22;
        ECX += (EDX ^ EEX ^ EAX) + w[1];
        ECX = (ECX << 12 | ECX >>> 20) + EBX;
        EEX = EEX << 10 | EEX >>> 22;
        EBX += (ECX ^ EDX ^ EEX) + w[5];
        EBX = (EBX << 5 | EBX >>> 27) + EAX;
        EDX = EDX << 10 | EDX >>> 22;
        EAX += (EBX ^ ECX ^ EDX) + w[8];
        EAX = (EAX << 14 | EAX >>> 18) + EEX;
        ECX = ECX << 10 | ECX >>> 22;
        EEX += (EAX ^ EBX ^ ECX) + w[7];
        EEX = (EEX << 6 | EEX >>> 26) + EDX;
        EBX = EBX << 10 | EBX >>> 22;
        EDX += (EEX ^ EAX ^ EBX) + w[6];
        EDX = (EDX << 8 | EDX >>> 24) + ECX;
        EAX = EAX << 10 | EAX >>> 22;
        ECX += (EDX ^ EEX ^ EAX) + w[2];
        ECX = (ECX << 13 | ECX >>> 19) + EBX;
        EEX = EEX << 10 | EEX >>> 22;
        EBX += (ECX ^ EDX ^ EEX) + w[13];
        EBX = (EBX << 6 | EBX >>> 26) + EAX;
        EDX = EDX << 10 | EDX >>> 22;
        EAX += (EBX ^ ECX ^ EDX) + w[14];
        EAX = (EAX << 5 | EAX >>> 27) + EEX;
        ECX = ECX << 10 | ECX >>> 22;
        EEX += (EAX ^ EBX ^ ECX) + w[0];
        EEX = (EEX << 15 | EEX >>> 17) + EDX;
        EBX = EBX << 10 | EBX >>> 22;
        EDX += (EEX ^ EAX ^ EBX) + w[3];
        EDX = (EDX << 13 | EDX >>> 19) + ECX;
        EAX = EAX << 10 | EAX >>> 22;
        ECX += (EDX ^ EEX ^ EAX) + w[9];
        ECX = (ECX << 11 | ECX >>> 21) + EBX;
        EEX = EEX << 10 | EEX >>> 22;
        EBX += (ECX ^ EDX ^ EEX) + w[11];
        EBX = (EBX << 11 | EBX >>> 21) + EAX;
        EDX = EDX << 10 | EDX >>> 22;
        Convert.lendian_int2byte(this.state, 0, this.H2 + ecx + EDX);
        Convert.lendian_int2byte(this.state, 4, this.H3 + edx + EEX);
        Convert.lendian_int2byte(this.state, 8, this.H4 + eex + EAX);
        Convert.lendian_int2byte(this.state, 12, this.H5 + eax + EBX);
        Convert.lendian_int2byte(this.state, 16, this.H1 + ebx + ECX);
    }

    protected int pad(HashPadMode pmode) {
        HashPad.RIPEMD160Pad(this);
        return 1;
    }
}

