/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.hash;

import com.cryptomathic.crypto.hash.HashPad;
import com.cryptomathic.crypto.hash.HashPadMode;
import com.cryptomathic.crypto.hash.HashState;
import com.cryptomathic.crypto.hash.HashType;
import com.cryptomathic.crypto.util.Convert;

class StateSha
extends HashState {
    private static int h0 = 1732584193;
    private static int h1 = -271733879;
    private static int h2 = -1732584194;
    private static int h3 = 271733878;
    private static int h4 = -1009589776;
    private int H0;
    private int H1;
    private int H2;
    private int H3;
    private int H4;

    protected StateSha() {
        this.block_size = 64;
        this.buffer = new byte[2 * this.block_size];
        this.state = new byte[20];
        Convert.bendian_int2byte(this.state, 0, h0);
        Convert.bendian_int2byte(this.state, 4, h1);
        Convert.bendian_int2byte(this.state, 8, h2);
        Convert.bendian_int2byte(this.state, 12, h3);
        Convert.bendian_int2byte(this.state, 16, h4);
        this.hash_size = 20;
        this.hashtype = HashType.SHA;
    }

    protected void hash(byte[] mes, int offset) {
        int i;
        int[] w = new int[80];
        this.H0 = Convert.bendian_byte2int(this.state, 0);
        this.H1 = Convert.bendian_byte2int(this.state, 4);
        this.H2 = Convert.bendian_byte2int(this.state, 8);
        this.H3 = Convert.bendian_byte2int(this.state, 12);
        this.H4 = Convert.bendian_byte2int(this.state, 16);
        for (i = 0; i < 16; ++i) {
            w[i] = Convert.bendian_byte2int(mes, 4 * i + offset);
        }
        for (i = 16; i < 80; ++i) {
            w[i] = w[i - 3] ^ w[i - 8] ^ w[i - 14] ^ w[i - 16];
            w[i] = w[i] << 1 | w[i] >>> 31;
        }
        int eax = this.H0;
        int ebx = this.H1;
        int ecx = this.H2;
        int edx = this.H3;
        int esi = this.H4;
        int tmp = eax << 5 | eax >>> 27;
        esi = (int)((long)((edx ^ ebx & (ecx ^ edx)) + tmp + esi) + 1518500249L + (long)w[0]);
        ebx = ebx << 30 | ebx >>> 2;
        tmp = esi << 5 | esi >>> 27;
        edx = (int)((long)((ecx ^ eax & (ebx ^ ecx)) + tmp + edx) + 1518500249L + (long)w[1]);
        eax = eax << 30 | eax >>> 2;
        tmp = edx << 5 | edx >>> 27;
        ecx = (int)((long)((ebx ^ esi & (eax ^ ebx)) + tmp + ecx) + 1518500249L + (long)w[2]);
        esi = esi << 30 | esi >>> 2;
        tmp = ecx << 5 | ecx >>> 27;
        ebx = (int)((long)((eax ^ edx & (esi ^ eax)) + tmp + ebx) + 1518500249L + (long)w[3]);
        edx = edx << 30 | edx >>> 2;
        tmp = ebx << 5 | ebx >>> 27;
        eax = (int)((long)((esi ^ ecx & (edx ^ esi)) + tmp + eax) + 1518500249L + (long)w[4]);
        ecx = ecx << 30 | ecx >>> 2;
        tmp = eax << 5 | eax >>> 27;
        esi = (int)((long)((edx ^ ebx & (ecx ^ edx)) + tmp + esi) + 1518500249L + (long)w[5]);
        ebx = ebx << 30 | ebx >>> 2;
        tmp = esi << 5 | esi >>> 27;
        edx = (int)((long)((ecx ^ eax & (ebx ^ ecx)) + tmp + edx) + 1518500249L + (long)w[6]);
        eax = eax << 30 | eax >>> 2;
        tmp = edx << 5 | edx >>> 27;
        ecx = (int)((long)((ebx ^ esi & (eax ^ ebx)) + tmp + ecx) + 1518500249L + (long)w[7]);
        esi = esi << 30 | esi >>> 2;
        tmp = ecx << 5 | ecx >>> 27;
        ebx = (int)((long)((eax ^ edx & (esi ^ eax)) + tmp + ebx) + 1518500249L + (long)w[8]);
        edx = edx << 30 | edx >>> 2;
        tmp = ebx << 5 | ebx >>> 27;
        eax = (int)((long)((esi ^ ecx & (edx ^ esi)) + tmp + eax) + 1518500249L + (long)w[9]);
        ecx = ecx << 30 | ecx >>> 2;
        tmp = eax << 5 | eax >>> 27;
        esi = (int)((long)((edx ^ ebx & (ecx ^ edx)) + tmp + esi) + 1518500249L + (long)w[10]);
        ebx = ebx << 30 | ebx >>> 2;
        tmp = esi << 5 | esi >>> 27;
        edx = (int)((long)((ecx ^ eax & (ebx ^ ecx)) + tmp + edx) + 1518500249L + (long)w[11]);
        eax = eax << 30 | eax >>> 2;
        tmp = edx << 5 | edx >>> 27;
        ecx = (int)((long)((ebx ^ esi & (eax ^ ebx)) + tmp + ecx) + 1518500249L + (long)w[12]);
        esi = esi << 30 | esi >>> 2;
        tmp = ecx << 5 | ecx >>> 27;
        ebx = (int)((long)((eax ^ edx & (esi ^ eax)) + tmp + ebx) + 1518500249L + (long)w[13]);
        edx = edx << 30 | edx >>> 2;
        tmp = ebx << 5 | ebx >>> 27;
        eax = (int)((long)((esi ^ ecx & (edx ^ esi)) + tmp + eax) + 1518500249L + (long)w[14]);
        ecx = ecx << 30 | ecx >>> 2;
        tmp = eax << 5 | eax >>> 27;
        esi = (int)((long)((edx ^ ebx & (ecx ^ edx)) + tmp + esi) + 1518500249L + (long)w[15]);
        ebx = ebx << 30 | ebx >>> 2;
        tmp = esi << 5 | esi >>> 27;
        edx = (int)((long)((ecx ^ eax & (ebx ^ ecx)) + tmp + edx) + 1518500249L + (long)w[16]);
        eax = eax << 30 | eax >>> 2;
        tmp = edx << 5 | edx >>> 27;
        ecx = (int)((long)((ebx ^ esi & (eax ^ ebx)) + tmp + ecx) + 1518500249L + (long)w[17]);
        esi = esi << 30 | esi >>> 2;
        tmp = ecx << 5 | ecx >>> 27;
        ebx = (int)((long)((eax ^ edx & (esi ^ eax)) + tmp + ebx) + 1518500249L + (long)w[18]);
        edx = edx << 30 | edx >>> 2;
        tmp = ebx << 5 | ebx >>> 27;
        eax = (int)((long)((esi ^ ecx & (edx ^ esi)) + tmp + eax) + 1518500249L + (long)w[19]);
        ecx = ecx << 30 | ecx >>> 2;
        tmp = eax << 5 | eax >>> 27;
        esi = (int)((long)((ebx ^ ecx ^ edx) + tmp + esi) + 1859775393L + (long)w[20]);
        ebx = ebx << 30 | ebx >>> 2;
        tmp = esi << 5 | esi >>> 27;
        edx = (int)((long)((eax ^ ebx ^ ecx) + tmp + edx) + 1859775393L + (long)w[21]);
        eax = eax << 30 | eax >>> 2;
        tmp = edx << 5 | edx >>> 27;
        ecx = (int)((long)((esi ^ eax ^ ebx) + tmp + ecx) + 1859775393L + (long)w[22]);
        esi = esi << 30 | esi >>> 2;
        tmp = ecx << 5 | ecx >>> 27;
        ebx = (int)((long)((edx ^ esi ^ eax) + tmp + ebx) + 1859775393L + (long)w[23]);
        edx = edx << 30 | edx >>> 2;
        tmp = ebx << 5 | ebx >>> 27;
        eax = (int)((long)((ecx ^ edx ^ esi) + tmp + eax) + 1859775393L + (long)w[24]);
        ecx = ecx << 30 | ecx >>> 2;
        tmp = eax << 5 | eax >>> 27;
        esi = (int)((long)((ebx ^ ecx ^ edx) + tmp + esi) + 1859775393L + (long)w[25]);
        ebx = ebx << 30 | ebx >>> 2;
        tmp = esi << 5 | esi >>> 27;
        edx = (int)((long)((eax ^ ebx ^ ecx) + tmp + edx) + 1859775393L + (long)w[26]);
        eax = eax << 30 | eax >>> 2;
        tmp = edx << 5 | edx >>> 27;
        ecx = (int)((long)((esi ^ eax ^ ebx) + tmp + ecx) + 1859775393L + (long)w[27]);
        esi = esi << 30 | esi >>> 2;
        tmp = ecx << 5 | ecx >>> 27;
        ebx = (int)((long)((edx ^ esi ^ eax) + tmp + ebx) + 1859775393L + (long)w[28]);
        edx = edx << 30 | edx >>> 2;
        tmp = ebx << 5 | ebx >>> 27;
        eax = (int)((long)((ecx ^ edx ^ esi) + tmp + eax) + 1859775393L + (long)w[29]);
        ecx = ecx << 30 | ecx >>> 2;
        tmp = eax << 5 | eax >>> 27;
        esi = (int)((long)((ebx ^ ecx ^ edx) + tmp + esi) + 1859775393L + (long)w[30]);
        ebx = ebx << 30 | ebx >>> 2;
        tmp = esi << 5 | esi >>> 27;
        edx = (int)((long)((eax ^ ebx ^ ecx) + tmp + edx) + 1859775393L + (long)w[31]);
        eax = eax << 30 | eax >>> 2;
        tmp = edx << 5 | edx >>> 27;
        ecx = (int)((long)((esi ^ eax ^ ebx) + tmp + ecx) + 1859775393L + (long)w[32]);
        esi = esi << 30 | esi >>> 2;
        tmp = ecx << 5 | ecx >>> 27;
        ebx = (int)((long)((edx ^ esi ^ eax) + tmp + ebx) + 1859775393L + (long)w[33]);
        edx = edx << 30 | edx >>> 2;
        tmp = ebx << 5 | ebx >>> 27;
        eax = (int)((long)((ecx ^ edx ^ esi) + tmp + eax) + 1859775393L + (long)w[34]);
        ecx = ecx << 30 | ecx >>> 2;
        tmp = eax << 5 | eax >>> 27;
        esi = (int)((long)((ebx ^ ecx ^ edx) + tmp + esi) + 1859775393L + (long)w[35]);
        ebx = ebx << 30 | ebx >>> 2;
        tmp = esi << 5 | esi >>> 27;
        edx = (int)((long)((eax ^ ebx ^ ecx) + tmp + edx) + 1859775393L + (long)w[36]);
        eax = eax << 30 | eax >>> 2;
        tmp = edx << 5 | edx >>> 27;
        ecx = (int)((long)((esi ^ eax ^ ebx) + tmp + ecx) + 1859775393L + (long)w[37]);
        esi = esi << 30 | esi >>> 2;
        tmp = ecx << 5 | ecx >>> 27;
        ebx = (int)((long)((edx ^ esi ^ eax) + tmp + ebx) + 1859775393L + (long)w[38]);
        edx = edx << 30 | edx >>> 2;
        tmp = ebx << 5 | ebx >>> 27;
        eax = (int)((long)((ecx ^ edx ^ esi) + tmp + eax) + 1859775393L + (long)w[39]);
        ecx = ecx << 30 | ecx >>> 2;
        tmp = eax << 5 | eax >>> 27;
        esi = (int)((long)((ebx & ecx | edx & (ebx | ecx)) + tmp + esi) + 2400959708L + (long)w[40]);
        ebx = ebx << 30 | ebx >>> 2;
        tmp = esi << 5 | esi >>> 27;
        edx = (int)((long)((eax & ebx | ecx & (eax | ebx)) + tmp + edx) + 2400959708L + (long)w[41]);
        eax = eax << 30 | eax >>> 2;
        tmp = edx << 5 | edx >>> 27;
        ecx = (int)((long)((esi & eax | ebx & (esi | eax)) + tmp + ecx) + 2400959708L + (long)w[42]);
        esi = esi << 30 | esi >>> 2;
        tmp = ecx << 5 | ecx >>> 27;
        ebx = (int)((long)((edx & esi | eax & (edx | esi)) + tmp + ebx) + 2400959708L + (long)w[43]);
        edx = edx << 30 | edx >>> 2;
        tmp = ebx << 5 | ebx >>> 27;
        eax = (int)((long)((ecx & edx | esi & (ecx | edx)) + tmp + eax) + 2400959708L + (long)w[44]);
        ecx = ecx << 30 | ecx >>> 2;
        tmp = eax << 5 | eax >>> 27;
        esi = (int)((long)((ebx & ecx | edx & (ebx | ecx)) + tmp + esi) + 2400959708L + (long)w[45]);
        ebx = ebx << 30 | ebx >>> 2;
        tmp = esi << 5 | esi >>> 27;
        edx = (int)((long)((eax & ebx | ecx & (eax | ebx)) + tmp + edx) + 2400959708L + (long)w[46]);
        eax = eax << 30 | eax >>> 2;
        tmp = edx << 5 | edx >>> 27;
        ecx = (int)((long)((esi & eax | ebx & (esi | eax)) + tmp + ecx) + 2400959708L + (long)w[47]);
        esi = esi << 30 | esi >>> 2;
        tmp = ecx << 5 | ecx >>> 27;
        ebx = (int)((long)((edx & esi | eax & (edx | esi)) + tmp + ebx) + 2400959708L + (long)w[48]);
        edx = edx << 30 | edx >>> 2;
        tmp = ebx << 5 | ebx >>> 27;
        eax = (int)((long)((ecx & edx | esi & (ecx | edx)) + tmp + eax) + 2400959708L + (long)w[49]);
        ecx = ecx << 30 | ecx >>> 2;
        tmp = eax << 5 | eax >>> 27;
        esi = (int)((long)((ebx & ecx | edx & (ebx | ecx)) + tmp + esi) + 2400959708L + (long)w[50]);
        ebx = ebx << 30 | ebx >>> 2;
        tmp = esi << 5 | esi >>> 27;
        edx = (int)((long)((eax & ebx | ecx & (eax | ebx)) + tmp + edx) + 2400959708L + (long)w[51]);
        eax = eax << 30 | eax >>> 2;
        tmp = edx << 5 | edx >>> 27;
        ecx = (int)((long)((esi & eax | ebx & (esi | eax)) + tmp + ecx) + 2400959708L + (long)w[52]);
        esi = esi << 30 | esi >>> 2;
        tmp = ecx << 5 | ecx >>> 27;
        ebx = (int)((long)((edx & esi | eax & (edx | esi)) + tmp + ebx) + 2400959708L + (long)w[53]);
        edx = edx << 30 | edx >>> 2;
        tmp = ebx << 5 | ebx >>> 27;
        eax = (int)((long)((ecx & edx | esi & (ecx | edx)) + tmp + eax) + 2400959708L + (long)w[54]);
        ecx = ecx << 30 | ecx >>> 2;
        tmp = eax << 5 | eax >>> 27;
        esi = (int)((long)((ebx & ecx | edx & (ebx | ecx)) + tmp + esi) + 2400959708L + (long)w[55]);
        ebx = ebx << 30 | ebx >>> 2;
        tmp = esi << 5 | esi >>> 27;
        edx = (int)((long)((eax & ebx | ecx & (eax | ebx)) + tmp + edx) + 2400959708L + (long)w[56]);
        eax = eax << 30 | eax >>> 2;
        tmp = edx << 5 | edx >>> 27;
        ecx = (int)((long)((esi & eax | ebx & (esi | eax)) + tmp + ecx) + 2400959708L + (long)w[57]);
        esi = esi << 30 | esi >>> 2;
        tmp = ecx << 5 | ecx >>> 27;
        ebx = (int)((long)((edx & esi | eax & (edx | esi)) + tmp + ebx) + 2400959708L + (long)w[58]);
        edx = edx << 30 | edx >>> 2;
        tmp = ebx << 5 | ebx >>> 27;
        eax = (int)((long)((ecx & edx | esi & (ecx | edx)) + tmp + eax) + 2400959708L + (long)w[59]);
        ecx = ecx << 30 | ecx >>> 2;
        tmp = eax << 5 | eax >>> 27;
        esi = (int)((long)((ebx ^ ecx ^ edx) + tmp + esi) + 3395469782L + (long)w[60]);
        ebx = ebx << 30 | ebx >>> 2;
        tmp = esi << 5 | esi >>> 27;
        edx = (int)((long)((eax ^ ebx ^ ecx) + tmp + edx) + 3395469782L + (long)w[61]);
        eax = eax << 30 | eax >>> 2;
        tmp = edx << 5 | edx >>> 27;
        ecx = (int)((long)((esi ^ eax ^ ebx) + tmp + ecx) + 3395469782L + (long)w[62]);
        esi = esi << 30 | esi >>> 2;
        tmp = ecx << 5 | ecx >>> 27;
        ebx = (int)((long)((edx ^ esi ^ eax) + tmp + ebx) + 3395469782L + (long)w[63]);
        edx = edx << 30 | edx >>> 2;
        tmp = ebx << 5 | ebx >>> 27;
        eax = (int)((long)((ecx ^ edx ^ esi) + tmp + eax) + 3395469782L + (long)w[64]);
        ecx = ecx << 30 | ecx >>> 2;
        tmp = eax << 5 | eax >>> 27;
        esi = (int)((long)((ebx ^ ecx ^ edx) + tmp + esi) + 3395469782L + (long)w[65]);
        ebx = ebx << 30 | ebx >>> 2;
        tmp = esi << 5 | esi >>> 27;
        edx = (int)((long)((eax ^ ebx ^ ecx) + tmp + edx) + 3395469782L + (long)w[66]);
        eax = eax << 30 | eax >>> 2;
        tmp = edx << 5 | edx >>> 27;
        ecx = (int)((long)((esi ^ eax ^ ebx) + tmp + ecx) + 3395469782L + (long)w[67]);
        esi = esi << 30 | esi >>> 2;
        tmp = ecx << 5 | ecx >>> 27;
        ebx = (int)((long)((edx ^ esi ^ eax) + tmp + ebx) + 3395469782L + (long)w[68]);
        edx = edx << 30 | edx >>> 2;
        tmp = ebx << 5 | ebx >>> 27;
        eax = (int)((long)((ecx ^ edx ^ esi) + tmp + eax) + 3395469782L + (long)w[69]);
        ecx = ecx << 30 | ecx >>> 2;
        tmp = eax << 5 | eax >>> 27;
        esi = (int)((long)((ebx ^ ecx ^ edx) + tmp + esi) + 3395469782L + (long)w[70]);
        ebx = ebx << 30 | ebx >>> 2;
        tmp = esi << 5 | esi >>> 27;
        edx = (int)((long)((eax ^ ebx ^ ecx) + tmp + edx) + 3395469782L + (long)w[71]);
        eax = eax << 30 | eax >>> 2;
        tmp = edx << 5 | edx >>> 27;
        ecx = (int)((long)((esi ^ eax ^ ebx) + tmp + ecx) + 3395469782L + (long)w[72]);
        esi = esi << 30 | esi >>> 2;
        tmp = ecx << 5 | ecx >>> 27;
        ebx = (int)((long)((edx ^ esi ^ eax) + tmp + ebx) + 3395469782L + (long)w[73]);
        edx = edx << 30 | edx >>> 2;
        tmp = ebx << 5 | ebx >>> 27;
        eax = (int)((long)((ecx ^ edx ^ esi) + tmp + eax) + 3395469782L + (long)w[74]);
        ecx = ecx << 30 | ecx >>> 2;
        tmp = eax << 5 | eax >>> 27;
        esi = (int)((long)((ebx ^ ecx ^ edx) + tmp + esi) + 3395469782L + (long)w[75]);
        ebx = ebx << 30 | ebx >>> 2;
        tmp = esi << 5 | esi >>> 27;
        edx = (int)((long)((eax ^ ebx ^ ecx) + tmp + edx) + 3395469782L + (long)w[76]);
        eax = eax << 30 | eax >>> 2;
        tmp = edx << 5 | edx >>> 27;
        ecx = (int)((long)((esi ^ eax ^ ebx) + tmp + ecx) + 3395469782L + (long)w[77]);
        esi = esi << 30 | esi >>> 2;
        tmp = ecx << 5 | ecx >>> 27;
        ebx = (int)((long)((edx ^ esi ^ eax) + tmp + ebx) + 3395469782L + (long)w[78]);
        edx = edx << 30 | edx >>> 2;
        tmp = ebx << 5 | ebx >>> 27;
        eax = (int)((long)((ecx ^ edx ^ esi) + tmp + eax) + 3395469782L + (long)w[79]);
        ecx = ecx << 30 | ecx >>> 2;
        Convert.bendian_int2byte(this.state, 0, this.H0 + eax);
        Convert.bendian_int2byte(this.state, 4, this.H1 + ebx);
        Convert.bendian_int2byte(this.state, 8, this.H2 + ecx);
        Convert.bendian_int2byte(this.state, 12, this.H3 + edx);
        Convert.bendian_int2byte(this.state, 16, this.H4 + esi);
    }

    protected int pad(HashPadMode pmode) {
        HashPad.SHAPad(this);
        return 1;
    }
}

