/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.hash;

import com.cryptomathic.crypto.hash.HashException;
import com.cryptomathic.crypto.hash.HashPad;
import com.cryptomathic.crypto.hash.HashPadMode;
import com.cryptomathic.crypto.hash.HashState;
import com.cryptomathic.crypto.hash.HashType;
import com.cryptomathic.crypto.util.Convert;

public class StateSha256
extends HashState {
    private static int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private static int h0 = 1779033703;
    private static int h1 = -1150833019;
    private static int h2 = 1013904242;
    private static int h3 = -1521486534;
    private static int h4 = 1359893119;
    private static int h5 = -1694144372;
    private static int h6 = 528734635;
    private static int h7 = 1541459225;
    private int H0;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int H5;
    private int H6;
    private int H7;

    protected StateSha256() {
        this.block_size = 64;
        this.buffer = new byte[2 * this.block_size];
        this.state = new byte[32];
        Convert.bendian_int2byte(this.state, 0, h0);
        Convert.bendian_int2byte(this.state, 4, h1);
        Convert.bendian_int2byte(this.state, 8, h2);
        Convert.bendian_int2byte(this.state, 12, h3);
        Convert.bendian_int2byte(this.state, 16, h4);
        Convert.bendian_int2byte(this.state, 20, h5);
        Convert.bendian_int2byte(this.state, 24, h6);
        Convert.bendian_int2byte(this.state, 28, h7);
        this.hash_size = 32;
        this.hashtype = HashType.SHA256;
    }

    private int ROR(int w, int n) {
        return w << 32 - n | w >>> n;
    }

    private int sigma0_256(int x) {
        return this.ROR(x, 7) ^ this.ROR(x, 18) ^ x >>> 3;
    }

    private int sigma1_256(int x) {
        return this.ROR(x, 17) ^ this.ROR(x, 19) ^ x >>> 10;
    }

    private int Sigma0_256(int x) {
        return this.ROR(x, 2) ^ this.ROR(x, 13) ^ this.ROR(x, 22);
    }

    private int Sigma1_256(int x) {
        return this.ROR(x, 6) ^ this.ROR(x, 11) ^ this.ROR(x, 25);
    }

    private int Ch(int x, int y, int z) {
        return x & y ^ ~x & z;
    }

    private int Maj(int x, int y, int z) {
        return x & y ^ x & z ^ y & z;
    }

    void hash(byte[] mes, int offset) {
        int i;
        int[] W = new int[64];
        for (i = 0; i < 16; ++i) {
            W[i] = Convert.bendian_byte2int(mes, 4 * i + offset);
        }
        for (i = 16; i < 64; ++i) {
            W[i] = this.sigma1_256(W[i - 2]) + W[i - 7] + this.sigma0_256(W[i - 15]) + W[i - 16];
        }
        this.H0 = Convert.bendian_byte2int(this.state, 0);
        this.H1 = Convert.bendian_byte2int(this.state, 4);
        this.H2 = Convert.bendian_byte2int(this.state, 8);
        this.H3 = Convert.bendian_byte2int(this.state, 12);
        this.H4 = Convert.bendian_byte2int(this.state, 16);
        this.H5 = Convert.bendian_byte2int(this.state, 20);
        this.H6 = Convert.bendian_byte2int(this.state, 24);
        this.H7 = Convert.bendian_byte2int(this.state, 28);
        int A = this.H0;
        int B = this.H1;
        int C = this.H2;
        int D = this.H3;
        int E = this.H4;
        int F = this.H5;
        int G = this.H6;
        int H = this.H7;
        for (int j = 0; j < 8; ++j) {
            int T1 = H + this.Sigma1_256(E) + this.Ch(E, F, G) + K[8 * j + 0] + W[8 * j + 0];
            int T2 = this.Sigma0_256(A) + this.Maj(A, B, C);
            D += T1;
            H = T1 + T2;
            T1 = G + this.Sigma1_256(D) + this.Ch(D, E, F) + K[8 * j + 1] + W[8 * j + 1];
            T2 = this.Sigma0_256(H) + this.Maj(H, A, B);
            C += T1;
            G = T1 + T2;
            T1 = F + this.Sigma1_256(C) + this.Ch(C, D, E) + K[8 * j + 2] + W[8 * j + 2];
            T2 = this.Sigma0_256(G) + this.Maj(G, H, A);
            B += T1;
            F = T1 + T2;
            T1 = E + this.Sigma1_256(B) + this.Ch(B, C, D) + K[8 * j + 3] + W[8 * j + 3];
            T2 = this.Sigma0_256(F) + this.Maj(F, G, H);
            A += T1;
            E = T1 + T2;
            T1 = D + this.Sigma1_256(A) + this.Ch(A, B, C) + K[8 * j + 4] + W[8 * j + 4];
            T2 = this.Sigma0_256(E) + this.Maj(E, F, G);
            H += T1;
            D = T1 + T2;
            T1 = C + this.Sigma1_256(H) + this.Ch(H, A, B) + K[8 * j + 5] + W[8 * j + 5];
            T2 = this.Sigma0_256(D) + this.Maj(D, E, F);
            G += T1;
            C = T1 + T2;
            T1 = B + this.Sigma1_256(G) + this.Ch(G, H, A) + K[8 * j + 6] + W[8 * j + 6];
            T2 = this.Sigma0_256(C) + this.Maj(C, D, E);
            F += T1;
            B = T1 + T2;
            T1 = A + this.Sigma1_256(F) + this.Ch(F, G, H) + K[8 * j + 7] + W[8 * j + 7];
            T2 = this.Sigma0_256(B) + this.Maj(B, C, D);
            E += T1;
            A = T1 + T2;
        }
        Convert.bendian_int2byte(this.state, 0, this.H0 + A);
        Convert.bendian_int2byte(this.state, 4, this.H1 + B);
        Convert.bendian_int2byte(this.state, 8, this.H2 + C);
        Convert.bendian_int2byte(this.state, 12, this.H3 + D);
        Convert.bendian_int2byte(this.state, 16, this.H4 + E);
        Convert.bendian_int2byte(this.state, 20, this.H5 + F);
        Convert.bendian_int2byte(this.state, 24, this.H6 + G);
        Convert.bendian_int2byte(this.state, 28, this.H7 + H);
    }

    int pad(HashPadMode pmode) throws HashException {
        HashPad.SHAPad(this);
        return 1;
    }
}

