/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.hash;

import com.cryptomathic.crypto.hash.HashException;
import com.cryptomathic.crypto.hash.HashPad;
import com.cryptomathic.crypto.hash.HashPadMode;
import com.cryptomathic.crypto.hash.HashState;
import com.cryptomathic.crypto.hash.HashType;
import com.cryptomathic.crypto.util.Convert;

public class StateSha512
extends HashState {
    private static final long[] K512 = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};
    private static final long h0 = 7640891576956012808L;
    private static final long h1 = -4942790177534073029L;
    private static final long h2 = 4354685564936845355L;
    private static final long h3 = -6534734903238641935L;
    private static final long h4 = 5840696475078001361L;
    private static final long h5 = -7276294671716946913L;
    private static final long h6 = 2270897969802886507L;
    private static final long h7 = 6620516959819538809L;

    protected StateSha512() {
        this.block_size = 128;
        this.buffer = new byte[2 * this.block_size];
        this.state = new byte[64];
        Convert.bendian_long2byte(this.state, 0, 7640891576956012808L);
        Convert.bendian_long2byte(this.state, 8, -4942790177534073029L);
        Convert.bendian_long2byte(this.state, 16, 4354685564936845355L);
        Convert.bendian_long2byte(this.state, 24, -6534734903238641935L);
        Convert.bendian_long2byte(this.state, 32, 5840696475078001361L);
        Convert.bendian_long2byte(this.state, 40, -7276294671716946913L);
        Convert.bendian_long2byte(this.state, 48, 2270897969802886507L);
        Convert.bendian_long2byte(this.state, 56, 6620516959819538809L);
        this.hash_size = 64;
        this.hashtype = HashType.SHA512;
    }

    private long Ch(long x, long y, long z) {
        return x & y ^ (x ^ 0xFFFFFFFFFFFFFFFFL) & z;
    }

    private long Maj(long x, long y, long z) {
        return x & y ^ x & z ^ y & z;
    }

    private long Rotr(long x, int n) {
        return x >>> n | x << 64 - n;
    }

    private long Sum0_512(long x) {
        return this.Rotr(x, 28) ^ this.Rotr(x, 34) ^ this.Rotr(x, 39);
    }

    private long Sum1_512(long x) {
        return this.Rotr(x, 14) ^ this.Rotr(x, 18) ^ this.Rotr(x, 41);
    }

    private long Shr(long x, int n) {
        return x >>> n;
    }

    private long Sigma0_512(long x) {
        return this.Rotr(x, 1) ^ this.Rotr(x, 8) ^ this.Shr(x, 7);
    }

    private long Sigma1_512(long x) {
        return this.Rotr(x, 19) ^ this.Rotr(x, 61) ^ this.Shr(x, 6);
    }

    void hash(byte[] mes, int offset) {
        int t;
        long[] W = new long[80];
        for (t = 0; t < 16; ++t) {
            W[t] = Convert.bendian_byte2long(mes, 8 * t + offset);
        }
        for (t = 16; t < 80; ++t) {
            W[t] = this.Sigma1_512(W[t - 2]) + W[t - 7] + this.Sigma0_512(W[t - 15]) + W[t - 16];
        }
        long H0 = Convert.bendian_byte2long(this.state, 0);
        long H1 = Convert.bendian_byte2long(this.state, 8);
        long H2 = Convert.bendian_byte2long(this.state, 16);
        long H3 = Convert.bendian_byte2long(this.state, 24);
        long H4 = Convert.bendian_byte2long(this.state, 32);
        long H5 = Convert.bendian_byte2long(this.state, 40);
        long H6 = Convert.bendian_byte2long(this.state, 48);
        long H7 = Convert.bendian_byte2long(this.state, 56);
        long A = H0;
        long B = H1;
        long C = H2;
        long D = H3;
        long E = H4;
        long F = H5;
        long G = H6;
        long H = H7;
        for (t = 0; t < 80; ++t) {
            long T1 = H + this.Sum1_512(E) + this.Ch(E, F, G) + K512[t] + W[t];
            long T2 = this.Sum0_512(A) + this.Maj(A, B, C);
            H = G;
            G = F;
            F = E;
            E = D + T1;
            D = C;
            C = B;
            B = A;
            A = T1 + T2;
        }
        Convert.bendian_long2byte(this.state, 0, A + H0);
        Convert.bendian_long2byte(this.state, 8, B + H1);
        Convert.bendian_long2byte(this.state, 16, C + H2);
        Convert.bendian_long2byte(this.state, 24, D + H3);
        Convert.bendian_long2byte(this.state, 32, E + H4);
        Convert.bendian_long2byte(this.state, 40, F + H5);
        Convert.bendian_long2byte(this.state, 48, G + H6);
        Convert.bendian_long2byte(this.state, 56, H + H7);
    }

    int pad(HashPadMode pmode) throws HashException {
        HashPad.SHA512Pad(this);
        return 1;
    }
}

