/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.minimal;

import com.cryptomathic.crypto.minimal.DesKernel;

public final class MDC4 {
    private static byte[] h0 = new byte[]{82, 82, 82, 82, 82, 82, 82, 82};
    private static byte[] h1 = new byte[]{37, 37, 37, 37, 37, 37, 37, 37};
    private static byte[] H0 = new byte[8];
    private static byte[] H1 = new byte[8];

    public static byte[] digest(byte[] mes) {
        int i;
        byte[] tail_block;
        System.arraycopy(h0, 0, H0, 0, 8);
        System.arraycopy(h1, 0, H1, 0, 8);
        int full_blocks_part_one = mes.length >>> 3;
        int full_blocks_part_one_length = full_blocks_part_one << 3;
        int tail = mes.length - full_blocks_part_one_length;
        int pad_size = 8 - tail;
        if (mes.length < 8) {
            pad_size += 8;
            tail_block = new byte[16];
        } else {
            tail_block = new byte[8];
        }
        System.arraycopy(mes, full_blocks_part_one_length, tail_block, 0, tail);
        for (i = tail; i < tail_block.length - 1; ++i) {
            tail_block[i] = -1;
        }
        tail_block[tail_block.length - 1] = (byte)pad_size;
        for (i = 0; i < full_blocks_part_one; ++i) {
            MDC4.hash(mes, i * 8);
        }
        MDC4.hash(tail_block, 0);
        if (tail_block.length == 16) {
            MDC4.hash(tail_block, 8);
        }
        byte[] res = new byte[16];
        System.arraycopy(H0, 0, res, 0, 8);
        System.arraycopy(H1, 0, res, 8, 8);
        return res;
    }

    private static void hash(byte[] mes, int offset) {
        int j;
        byte[] T0 = new byte[8];
        byte[] T1 = new byte[8];
        byte[] HH0 = new byte[8];
        byte[] HH1 = new byte[8];
        System.arraycopy(H0, 0, HH0, 0, 8);
        System.arraycopy(H1, 0, HH1, 0, 8);
        MDC4.H0[0] = (byte)(H0[0] & 0xFFFFFF9F | 0x40);
        MDC4.H1[0] = (byte)(H1[0] & 0xFFFFFF9F | 0x20);
        int[] key = DesKernel.des_make_keys(H0);
        DesKernel.des_encrypt(key, mes, offset, T0, 0);
        for (j = 0; j < 8; ++j) {
            int n = j;
            T0[n] = (byte)(T0[n] ^ mes[j + offset]);
        }
        key = DesKernel.des_make_keys(H1);
        DesKernel.des_encrypt(key, mes, offset, T1, 0);
        for (j = 0; j < 8; ++j) {
            int n = j;
            T1[n] = (byte)(T1[n] ^ mes[j + offset]);
        }
        for (j = 4; j < 8; ++j) {
            int n = j;
            T0[n] = (byte)(T0[n] ^ T1[j]);
            int n2 = j;
            T1[n2] = (byte)(T1[n2] ^ T0[j]);
            int n3 = j;
            T0[n3] = (byte)(T0[n3] ^ T1[j]);
        }
        System.arraycopy(HH0, 0, H0, 0, 8);
        System.arraycopy(HH1, 0, H1, 0, 8);
        T0[0] = (byte)(T0[0] & 0xFFFFFF9F | 0x40);
        T1[0] = (byte)(T1[0] & 0xFFFFFF9F | 0x20);
        key = DesKernel.des_make_keys(T0);
        DesKernel.des_encrypt(key, H1, 0, T0, 0);
        for (j = 0; j < 8; ++j) {
            int n = j;
            T0[n] = (byte)(T0[n] ^ H1[j]);
        }
        key = DesKernel.des_make_keys(T1);
        DesKernel.des_encrypt(key, H0, 0, T1, 0);
        for (j = 0; j < 8; ++j) {
            int n = j;
            T1[n] = (byte)(T1[n] ^ H0[j]);
        }
        for (j = 4; j < 8; ++j) {
            int n = j;
            T0[n] = (byte)(T0[n] ^ T1[j]);
            int n4 = j;
            T1[n4] = (byte)(T1[n4] ^ T0[j]);
            int n5 = j;
            T0[n5] = (byte)(T0[n5] ^ T1[j]);
        }
        System.arraycopy(T0, 0, H0, 0, 8);
        System.arraycopy(T1, 0, H1, 0, 8);
    }
}

