/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.minimal;

import com.cryptomathic.crypto.minimal.PrimeInt;

public class PrimeExp {
    public static byte[] exp(byte[] p, byte[] q, byte[] q1p, byte[] p1q, byte[] dp, byte[] dq, byte[] ir) {
        PrimeInt complement;
        PrimeInt P_p = new PrimeInt(p);
        PrimeInt P_q = new PrimeInt(q);
        PrimeInt P_q1p = new PrimeInt(q1p);
        PrimeInt P_dp = new PrimeInt(dp);
        PrimeInt P_dq = new PrimeInt(dq);
        PrimeInt bi = new PrimeInt(ir);
        PrimeInt AA = bi.mod(P_p).modPow(P_dp, P_p);
        PrimeInt BB = bi.mod(P_q).modPow(P_dq, P_q);
        PrimeInt dec = null;
        dec = AA.add(P_p).subtract(BB).multiply(P_q1p).mod(P_p).multiply(P_q).add(BB);
        if (dec.compareTo(complement = P_p.multiply(P_q).subtract(dec)) > 0) {
            dec = complement;
        }
        return dec.toByteArray();
    }

    public static byte[] getModulus(byte[] p, byte[] q) {
        PrimeInt P_q = new PrimeInt(q);
        PrimeInt P_p = new PrimeInt(p);
        byte[] out = P_q.multiply(P_p).toByteArray();
        if (out[0] < 0) {
            byte[] temp = new byte[out.length + 1];
            System.arraycopy(out, 0, temp, 1, out.length);
            out = temp;
        }
        return out;
    }

    public static int getModulusbitLength(byte[] p, byte[] q) {
        PrimeInt P_p = new PrimeInt(p);
        PrimeInt P_q = new PrimeInt(q);
        PrimeInt aux = P_p.multiply(P_q);
        return aux.bitLength();
    }
}

