/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.minimal;

public final class Sboxp {
    public static int[][] SBOX = new int[8][64];
    static int[] inv_4 = new int[]{0, 8, 4, 12, 2, 10, 6, 14, 1, 9, 5, 13, 3, 11, 7, 15};
    static int[] inv_2 = new int[]{0, 2, 1, 3};
    static int[] p32i = new int[]{16, 7, 20, 21, 29, 12, 28, 17, 1, 15, 23, 26, 5, 18, 31, 10, 2, 8, 24, 14, 32, 27, 3, 9, 19, 13, 30, 6, 22, 11, 4, 25};

    private static byte char2byte(char c) {
        return (byte)Character.digit(c, 16);
    }

    private static int row(int b) {
        return inv_2[(b & 0x20) >> 4 | b & 1];
    }

    private static int col(int b) {
        return inv_4[(b & 0x1E) >> 1];
    }

    static {
        String si = "E4D12FB83A6C59070F74E2D1A6CB953841E8D62BFC973A50FC8249175B3EA06DF18E6B34972DC05A3D47F28EC01A69B50E7BA4D158C6932FD8A13F42B67C05E9A09E63F51DC7B428D709346A285ECBF1D6498F30B12C5AE71AD069874FE3B52C7DE3069A1285BC4FD8B56F03472C1AE9A690CB7DF13E52843F06A1D8945BC72E2C417AB6853FD0E9EB2C47D150FA3986421BAD78F9C5630EB8C71E2D6F09A453C1AF92680D34E75BAF427C9561DE0B389EF528C3704A1DB6432C95FABE17608D4B2EF08D3C975A61D0B7491AE35C2F8614BDC37EAF6805926BD814A7950FE23CD2846FB1A93E50C71FD8A374C56B0E927B419CE206ADF35821E74A8DFC90356B";
        int[] m = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        int[] m_16 = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768};
        for (int i = 0; i < 8; ++i) {
            for (int jj = 0; jj < 64; ++jj) {
                int Sij = inv_4[Sboxp.char2byte(si.charAt(i * 64 + (Sboxp.row(jj) << 4) + Sboxp.col(jj)))];
                for (int k = 0; k < 2; ++k) {
                    for (int a = 0; a < 16; ++a) {
                        int b = p32i[(16 * k + a + 1) % 32] - 1;
                        if (i != b / 4) continue;
                        int mi = m[b % 4];
                        int mo = m_16[a];
                        if ((mi & Sij) == 0) continue;
                        if (k == 1) {
                            int[] nArray = SBOX[i];
                            int n = jj;
                            nArray[n] = nArray[n] | mo << 16;
                            continue;
                        }
                        int[] nArray = SBOX[i];
                        int n = jj;
                        nArray[n] = nArray[n] | mo;
                    }
                }
            }
        }
    }
}

