/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.minimal;

public final class UByteArray {
    public static final byte[] _clearmask = new byte[]{-1, 127, 63, 31, 15, 7, 3, 1, 0};

    public static void clearBits(byte[] ubytearray, int bitNo, int length) {
        if (length == 0) {
            return;
        }
        int indexFirst = UByteArray.getByteIndex(ubytearray, bitNo);
        int indexLast = UByteArray.getByteIndex(ubytearray, bitNo + length - 1);
        int bitsInFirst = 8 - bitNo % 8;
        int bitsInLast = (length - bitsInFirst) % 8;
        int indexLastFull = indexFirst - (length - bitsInFirst) / 8;
        int n = indexFirst;
        ubytearray[n] = (byte)(ubytearray[n] & _clearmask[bitsInFirst]);
        for (int i = indexFirst - 1; i >= indexLastFull; --i) {
            ubytearray[i] = 0;
        }
        if (bitsInLast > 0) {
            int n2 = indexLast;
            ubytearray[n2] = (byte)(ubytearray[n2] & ~_clearmask[8 - bitsInLast]);
        }
    }

    public static void setBit(byte[] ubytearray, int bitNo) {
        int index = UByteArray.getByteIndex(ubytearray, bitNo);
        byte mask = (byte)(1 << bitNo % 8);
        int n = index;
        ubytearray[n] = (byte)(ubytearray[n] | mask);
    }

    public static int getByteIndex(byte[] ubytearray, int bitNo) {
        return ubytearray.length - 1 - bitNo / 8;
    }
}

