/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.minimal.keygeneration;

import com.cryptomathic.crypto.minimal.PrimeInt;
import com.cryptomathic.crypto.minimal.keygeneration.PrimeIntPlus;
import java.util.Random;

public class Primality {
    private static PrimeInt ONE = PrimeInt.valueOf(1);
    private static PrimeInt TWO = PrimeInt.valueOf(2);
    private static int SEEDLENGTH = 20;
    private Random _random;
    private int _defaultCertainty = 5;

    public Primality() {
        this._random = new Random();
    }

    public Primality(Random random) {
        this._random = random;
    }

    public boolean isProbablePrime(PrimeInt arg) {
        return this.isProbablePrime(arg, this._defaultCertainty);
    }

    public boolean isProbablePrime(PrimeInt arg, int certainty) {
        boolean composite = false;
        boolean stopBase = false;
        PrimeInt THREE = PrimeInt.valueOf(3);
        if (arg.compareTo(ONE) == 0) {
            return false;
        }
        if (arg.compareTo(TWO) == 0) {
            return true;
        }
        if (arg.compareTo(THREE) == 0) {
            return true;
        }
        if (arg.compareTo(PrimeInt.valueOf(5)) == 0) {
            return true;
        }
        if (arg.compareTo(PrimeInt.valueOf(7)) == 0) {
            return true;
        }
        PrimeInt arg_1 = arg.subtract(ONE);
        if (PrimeIntPlus.getLowestSetBit(arg) != 0) {
            return false;
        }
        int s = PrimeIntPlus.getLowestSetBit(arg_1);
        if (s == 0) {
            return false;
        }
        PrimeInt argOdd = PrimeIntPlus.shiftRight(arg_1, s);
        PrimeInt base = TWO;
        for (int i = 0; i <= certainty && !composite; ++i) {
            PrimeInt argTest = base.modPow(argOdd, arg);
            stopBase = argTest.equals(ONE);
            for (int j = 0; j < s && !stopBase; ++j) {
                boolean bl = stopBase = argTest.add(ONE).compareTo(arg) == 0;
                if (stopBase) continue;
                argTest = argTest.multiply(argTest);
                argTest = argTest.remainder(arg);
            }
            if (!stopBase) {
                composite = true;
                continue;
            }
            if (i >= certainty) continue;
            do {
                base = new PrimeInt(arg.bitLength(), this._random);
            } while ((base = base.remainder(arg)).compareTo(THREE) == -1 || base.compareTo(arg_1) == 0);
        }
        return !composite;
    }
}

