/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.minimal.keygeneration;

import com.cryptomathic.crypto.minimal.PrimeInt;
import com.cryptomathic.crypto.minimal.RSAPrivateKey;
import com.cryptomathic.crypto.minimal.keygeneration.EPrimeParameterException;
import com.cryptomathic.crypto.minimal.keygeneration.PrimeGenerator;
import com.cryptomathic.crypto.minimal.keygeneration.PrimeIntPlus;
import com.cryptomathic.crypto.minimal.keygeneration.RSAPublicKey;
import java.math.BigInteger;
import java.util.Random;

public class RSAKeyPair {
    public RSAPrivateKey privateKey;
    public RSAPublicKey publicKey;

    public RSAKeyPair(int bitsize, int pubexp, Random random) throws EPrimeParameterException {
        boolean UseBigInteger = RSAPrivateKey.bigIntegerCheck();
        if (UseBigInteger) {
            BigInteger m;
            BigInteger q_minus_one;
            BigInteger q;
            BigInteger p_minus_one;
            BigInteger p;
            BigInteger e = BigInteger.valueOf(pubexp);
            BigInteger ZERO = BigInteger.valueOf(0L);
            BigInteger ONE = BigInteger.valueOf(1L);
            while (true) {
                p = new BigInteger(bitsize / 2, 5, random);
                p_minus_one = p.subtract(ONE);
                if (p.bitLength() != bitsize / 2 || p_minus_one.mod(e).equals(ZERO)) continue;
                do {
                    q = new BigInteger(bitsize / 2, 5, random);
                    q_minus_one = q.subtract(ONE);
                } while (q.bitLength() != bitsize / 2 || q_minus_one.mod(e).equals(ZERO));
                if (p.compareTo(q) < 0) {
                    BigInteger temp = p;
                    p = q;
                    q = temp;
                    temp = p_minus_one;
                    p_minus_one = q_minus_one;
                    q_minus_one = temp;
                }
                if ((m = p.multiply(q)).bitLength() == bitsize) break;
            }
            BigInteger euler = p_minus_one.multiply(q_minus_one);
            BigInteger d = e.modInverse(euler);
            if (m.bitLength() != bitsize) {
                throw new ArithmeticException("Bad primes");
            }
            BigInteger ep = d.mod(p_minus_one);
            BigInteger eq = d.mod(q_minus_one);
            BigInteger pi = p.modInverse(q);
            BigInteger qi = q.modInverse(p);
            int size = bitsize / 8 / 2;
            this.privateKey = new RSAPrivateKey(this.BI2Bytes(p, size), this.BI2Bytes(q, size), this.BI2Bytes(qi, size), this.BI2Bytes(pi, size), this.BI2Bytes(ep, size), this.BI2Bytes(eq, size));
            this.publicKey = new RSAPublicKey(this.BI2Bytes(e, size), this.BI2Bytes(m, bitsize / 8));
        } else {
            PrimeInt m;
            PrimeInt q_minus_one;
            PrimeInt q;
            PrimeInt p_minus_one;
            PrimeInt p;
            PrimeGenerator primegen = new PrimeGenerator();
            PrimeInt e = PrimeInt.valueOf(pubexp);
            PrimeInt ZERO = PrimeInt.valueOf(0);
            PrimeInt ONE = PrimeInt.valueOf(1);
            while (true) {
                p = primegen.getPrime(bitsize / 2, 2, 1);
                p_minus_one = p.subtract(ONE);
                if (p.bitLength() != bitsize / 2 || p_minus_one.mod(e).equals(ZERO)) continue;
                do {
                    q = primegen.getPrime(bitsize / 2, 2, 1);
                    q_minus_one = q.subtract(ONE);
                } while (q.bitLength() != bitsize / 2 || q_minus_one.mod(e).equals(ZERO));
                if (p.compareTo(q) < 0) {
                    PrimeInt temp = p;
                    p = q;
                    q = temp;
                    temp = p_minus_one;
                    p_minus_one = q_minus_one;
                    q_minus_one = temp;
                }
                if ((m = p.multiply(q)).bitLength() == bitsize) break;
            }
            PrimeInt euler = p_minus_one.multiply(q_minus_one);
            PrimeInt d = PrimeIntPlus.modInverse(e, euler);
            PrimeInt ep = d.mod(p_minus_one);
            PrimeInt eq = d.mod(q_minus_one);
            PrimeInt pi = PrimeIntPlus.modInverse(p, q);
            PrimeInt qi = PrimeIntPlus.modInverse(q, p);
            int size = bitsize / 8 / 2;
            this.privateKey = new RSAPrivateKey(this.PI2Bytes(p, size), this.PI2Bytes(q, size), this.PI2Bytes(qi, size), this.PI2Bytes(pi, size), this.PI2Bytes(ep, size), this.PI2Bytes(eq, size));
            this.publicKey = new RSAPublicKey(this.PI2Bytes(e, size), this.PI2Bytes(m, bitsize / 8));
        }
    }

    byte[] BI2Bytes(BigInteger b, int size) {
        byte[] res2;
        byte[] res = b.toByteArray();
        if (res.length > size) {
            res2 = new byte[size];
            System.arraycopy(res, res.length - size, res2, 0, size);
            res = res2;
        }
        if (res.length < size) {
            res2 = new byte[size];
            System.arraycopy(res, 0, res2, size - res.length, res.length);
            res = res2;
        }
        return res;
    }

    byte[] PI2Bytes(PrimeInt b, int size) {
        byte[] res2;
        byte[] res = b.toByteArray();
        if (res.length > size) {
            res2 = new byte[size];
            System.arraycopy(res, res.length - size, res2, 0, size);
            res = res2;
        }
        if (res.length < size) {
            res2 = new byte[size];
            System.arraycopy(res, 0, res2, size - res.length, res.length);
            res = res2;
        }
        return res;
    }
}

