/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.minimal.keygeneration;

import com.cryptomathic.crypto.minimal.PrimeInt;
import com.cryptomathic.crypto.minimal.RSAPrivateKey;
import com.cryptomathic.crypto.minimal.keygeneration.PrimeIntPlus;
import java.math.BigInteger;

public class RSAPublicKey {
    private boolean UseBigInteger = RSAPrivateKey.bigIntegerCheck();
    private byte[] e;
    private byte[] m;

    public RSAPublicKey(byte[] e, byte[] m) {
        this.e = e;
        this.m = m;
    }

    public byte[] exp(byte[] data) {
        if (this.UseBigInteger) {
            BigInteger bi_a = new BigInteger(1, data);
            BigInteger bi_e = new BigInteger(1, this.e);
            BigInteger bi_m = new BigInteger(1, this.m);
            BigInteger res = bi_a.modPow(bi_e, bi_m);
            if (!(!res.testBit(0) && res.testBit(1) && res.testBit(2) && !res.testBit(3) || !(res = bi_m.subtract(res)).testBit(0) && res.testBit(1) && res.testBit(2) && !res.testBit(3))) {
                return new byte[0];
            }
            byte[] out = res.toByteArray();
            if (out[0] == 0 && (out[1] & 0x80) != 0) {
                byte[] temp = new byte[out.length - 1];
                System.arraycopy(out, 1, temp, 0, temp.length);
                out = temp;
            }
            return out;
        }
        PrimeInt pi_a = new PrimeInt(data);
        PrimeInt pi_e = new PrimeInt(this.e);
        PrimeInt pi_m = new PrimeInt(this.m);
        PrimeInt res = pi_a.modPow(pi_e, pi_m);
        if (!(!PrimeIntPlus.testBit(res, 0) && PrimeIntPlus.testBit(res, 1) && PrimeIntPlus.testBit(res, 2) && !PrimeIntPlus.testBit(res, 3) || !PrimeIntPlus.testBit(res = pi_m.subtract(res), 0) && PrimeIntPlus.testBit(res, 1) && PrimeIntPlus.testBit(res, 2) && !PrimeIntPlus.testBit(res, 3))) {
            return new byte[0];
        }
        return res.toByteArray();
    }

    public int getModulusbitLength() {
        if (this.UseBigInteger) {
            BigInteger Big_m = new BigInteger(1, this.m);
            return Big_m.bitLength();
        }
        PrimeInt pi_m = new PrimeInt(this.m);
        return pi_m.bitLength();
    }
}

