/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.minimal.keygeneration;

import com.cryptomathic.crypto.minimal.PrimeInt;
import com.cryptomathic.crypto.minimal.SHA1;
import java.math.BigInteger;
import java.util.Random;

public class SecureRandom
extends Random {
    private static final int LENGTH = 20;
    private static final int ROUND = 5;
    private byte[] _seed = new byte[20];

    public SecureRandom() {
        Random random = new Random();
        random.nextBytes(this._seed);
    }

    public SecureRandom(byte[] seed) throws NullPointerException {
        if (seed == null) {
            throw new NullPointerException("Seed is null");
        }
        this._seed = SHA1.digest(seed);
    }

    private synchronized void getBytes(byte[] bytes, int index) throws IndexOutOfBoundsException {
        int ratio = 4;
        if (index >= bytes.length) {
            throw new IndexOutOfBoundsException(index + ">=" + bytes.length);
        }
        int length = bytes.length - index;
        if (length == 0) {
            return;
        }
        if (length > 5) {
            length = 5;
        }
        this._seed = SHA1.digest(this._seed);
        for (int i = 0; i < length; ++i) {
            bytes[index + i] = 0;
            for (int j = 0; j < ratio; ++j) {
                int n = index + i;
                bytes[n] = (byte)(bytes[n] ^ this._seed[i * ratio + j]);
            }
        }
    }

    public synchronized void nextBytes(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        int q = bytes.length / 5;
        int r = bytes.length % 5;
        try {
            for (int i = 0; i < q; ++i) {
                this.getBytes(bytes, i * 5);
            }
            if (r > 0) {
                this.getBytes(bytes, q * 5);
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    protected int next(int bits) {
        byte[] randombytes = new byte[4];
        this.getBytes(randombytes, 0);
        long l = ((randombytes[0] & 0xFF) << 24) + ((randombytes[1] & 0xFF) << 16) + ((randombytes[2] & 0xFF) << 8) + (randombytes[3] & 0xFF);
        return (int)(l >>> 32 - bits);
    }

    public synchronized void setSeed(byte[] newSeed) {
        this._seed = SHA1.digest(newSeed);
    }

    public synchronized void mixSeed(byte[] seed) {
        byte[] concat = new byte[this._seed.length + seed.length];
        System.arraycopy(concat, 0, this._seed, 0, this._seed.length);
        System.arraycopy(concat, this._seed.length, seed, 0, seed.length);
        this._seed = SHA1.digest(concat);
    }

    public BigInteger nextBigInteger(int length) throws IllegalArgumentException {
        if (length < 0) {
            throw new IllegalArgumentException("Negative number of bits");
        }
        if (length == 0) {
            return BigInteger.valueOf(0L);
        }
        int no_of_bytes = length / 8;
        int remainder = length % 8;
        byte[] bytes = remainder == 0 ? new byte[no_of_bytes] : new byte[no_of_bytes + 1];
        this.nextBytes(bytes);
        if (remainder == 0) {
            return new BigInteger(1, bytes);
        }
        int blind = 0;
        for (int i = 0; i < remainder; ++i) {
            blind = (byte)(blind << 1);
            blind = (byte)(blind + 1);
        }
        bytes[0] = (byte)(bytes[0] & blind);
        return new BigInteger(1, bytes);
    }

    public PrimeInt nextPrimeInt(int length) throws IllegalArgumentException {
        if (length < 0) {
            throw new IllegalArgumentException("Negative number of bits");
        }
        if (length == 0) {
            return PrimeInt.valueOf(0);
        }
        int no_of_bytes = length / 8;
        int remainder = length % 8;
        byte[] bytes = remainder == 0 ? new byte[no_of_bytes] : new byte[no_of_bytes + 1];
        this.nextBytes(bytes);
        if (remainder == 0) {
            return new PrimeInt(bytes);
        }
        int blind = 0;
        for (int i = 0; i < remainder; ++i) {
            blind = (byte)(blind << 1);
            blind = (byte)(blind + 1);
        }
        bytes[0] = (byte)(bytes[0] & blind);
        return new PrimeInt(bytes);
    }
}

