/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.pad;

import com.cryptomathic.crypto.pad.EBadPadding;
import com.cryptomathic.crypto.pad.PadMode;

public class Pad {
    public static final int NOPAD = 0;
    public static final int ISO10126 = 1;
    public static final int ANSIX923 = 2;
    public static final int PADFF16 = 3;
    public static final int OPAD = 4;
    public static final int MDCPAD = 5;
    public static final int PKCS1_BT0 = 6;
    public static final int PKCS1_BT1 = 7;
    public static final int PKCS1_BT2 = 8;
    public static final int PKCS5 = 9;
    public static final int PKCS7 = 10;

    public static int pad(byte[] mes, int offset, int len, int blocksize, int pmode) {
        switch (pmode) {
            case 1: 
            case 2: {
                for (int i = len + offset; i < blocksize - 1; ++i) {
                    mes[i + offset] = 0;
                }
                mes[offset + blocksize - 1] = (byte)(blocksize - len);
                return 1;
            }
            case 3: {
                for (int i = len + offset; i < blocksize - 1; ++i) {
                    mes[i + offset] = -1;
                }
                mes[offset + blocksize - 1] = (byte)(blocksize - len);
                return 1;
            }
            case 4: {
                if (len > 0) {
                    for (int i = len + offset; i < blocksize; ++i) {
                        mes[i + offset] = 0;
                    }
                    return 1;
                }
                return 0;
            }
            case 5: {
                mes[len + offset] = -128;
                for (int i = len + 1; i < blocksize; ++i) {
                    mes[i + offset] = 0;
                }
                return 1;
            }
            case 9: 
            case 10: {
                for (int i = len; i < blocksize; ++i) {
                    mes[i + offset] = (byte)(blocksize - len);
                }
                return 1;
            }
        }
        throw new IllegalArgumentException("Unsupported padding mode");
    }

    public static int unpad(byte[] mes, int offset, int blocksize, int pmode) throws EBadPadding {
        switch (pmode) {
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: {
                int len = blocksize - mes[offset + blocksize - 1];
                if (0 > len || len > 7) {
                    throw new EBadPadding("Invalid length of padding");
                }
                return len;
            }
            case 4: {
                int len;
                for (len = blocksize; mes[len + offset - 1] == 0 && len > 0; --len) {
                }
                return len;
            }
            case 5: {
                int len;
                for (len = blocksize; mes[len + offset - 1] == 0 && len > 0; --len) {
                }
                if (mes[len + offset - 1] != -128) {
                    throw new EBadPadding("Last non zero byte not equal to 0x80");
                }
                return len - 1;
            }
        }
        throw new IllegalArgumentException("Unsupported padding mode");
    }

    public static int pad(byte[] m, int len, int blocksize, PadMode pmode) {
        int rtn = 0;
        int ref = pmode.toInt();
        if (ref == PadMode.ANSIX923.toInt() || ref == PadMode.ISO10126.toInt()) {
            for (int i = len; i < blocksize - 1; ++i) {
                m[i] = 0;
            }
            m[blocksize - 1] = (byte)(blocksize - len);
            rtn = 1;
        } else if (ref == PadMode.PADFF16.toInt()) {
            for (int i = len; i < blocksize - 1; ++i) {
                m[i] = -1;
            }
            m[blocksize - 1] = (byte)(blocksize - len);
            rtn = 1;
        } else if (ref == PadMode.OPAD.toInt()) {
            if (len > 0) {
                for (int i = len; i < blocksize; ++i) {
                    m[i] = 0;
                }
                rtn = 1;
            } else {
                rtn = 0;
            }
        } else if (ref == PadMode.MDCPAD.toInt()) {
            m[len] = -128;
            for (int i = len + 1; i < blocksize; ++i) {
                m[i] = 0;
            }
            rtn = 1;
        } else if (ref == PadMode.PKCS5.toInt()) {
            for (int i = len; i < blocksize; ++i) {
                m[i] = (byte)(blocksize - len);
            }
            rtn = 1;
        }
        return rtn;
    }

    public static int unpad(byte[] m, int blocksize, PadMode pmode) throws EBadPadding {
        int len = 0;
        int ref = pmode.toInt();
        if (ref == PadMode.PADFF16.toInt() || ref == PadMode.ANSIX923.toInt() || ref == PadMode.ISO10126.toInt() || ref == PadMode.PKCS5.toInt()) {
            len = blocksize - m[blocksize - 1];
            if (0 > len || len > blocksize - 1) {
                throw new EBadPadding("Invalid length of padding");
            }
        } else if (ref == PadMode.OPAD.toInt()) {
            for (len = blocksize; m[len - 1] == 0 && len > 0; --len) {
            }
        } else if (ref == PadMode.NOPAD.toInt()) {
            len = blocksize;
        }
        return len;
    }

    public static int pad16(byte[] m, int len, PadMode pmode) {
        int rtn = 0;
        int ref = pmode.toInt();
        if (ref == PadMode.ANSIX923.toInt() || ref == PadMode.ISO10126.toInt()) {
            for (int i = len; i < 15; ++i) {
                m[i] = 0;
            }
            m[15] = (byte)(16 - len);
            rtn = 1;
        } else if (ref == PadMode.PADFF16.toInt()) {
            for (int i = len; i < 15; ++i) {
                m[i] = -1;
            }
            m[15] = (byte)(16 - len);
            rtn = 1;
        } else if (ref == PadMode.OPAD.toInt()) {
            if (len > 0) {
                for (int i = len; i < 16; ++i) {
                    m[i] = 0;
                }
                rtn = 1;
            } else {
                rtn = 0;
            }
        } else if (ref == PadMode.MDCPAD.toInt()) {
            m[len] = -128;
            for (int i = len + 1; i < 16; ++i) {
                m[i] = 0;
            }
            rtn = 1;
        } else if (ref == PadMode.PKCS5.toInt()) {
            for (int i = len; i < 16; ++i) {
                m[i] = (byte)(16 - len);
            }
            rtn = 1;
        }
        return rtn;
    }

    public static int unpad16(byte[] m, PadMode pmode) throws EBadPadding {
        int len = 0;
        int ref = pmode.toInt();
        if (ref == PadMode.PADFF16.toInt() || ref == PadMode.ANSIX923.toInt() || ref == PadMode.ISO10126.toInt() || ref == PadMode.PKCS5.toInt()) {
            len = 16 - m[15];
            if (0 > len || len > 15) {
                throw new EBadPadding("Invalid length of padding");
            }
        } else if (ref == PadMode.OPAD.toInt()) {
            for (len = 16; m[len - 1] == 0 && len > 0; --len) {
            }
        } else if (ref == PadMode.NOPAD.toInt()) {
            len = 16;
        }
        return len;
    }
}

