/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.provider;

import com.cryptomathic.crypto.des.DesKernel;
import com.cryptomathic.crypto.provider.CipherBlockCBCBase;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public class Cipher3DesCBC
extends CipherBlockCBCBase {
    protected int[] _round_keys1;
    protected int[] _round_keys2;
    protected int[] _round_keys3;

    public Cipher3DesCBC() {
        super(8);
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this._encrypting = opmode == 1;
        this.__MAGIC_NUMBER = this._encrypting ? 0 : 1;
        byte[] temp = key.getEncoded();
        if (temp == null || temp.length != 16 && temp.length != 24) {
            throw new InvalidKeyException("key does not contain a valid 3des key");
        }
        byte[] temp2 = new byte[8];
        System.arraycopy(temp, 0, temp2, 0, 8);
        this._round_keys1 = DesKernel.des_make_keys(temp2);
        System.arraycopy(temp, 8, temp2, 0, 8);
        this._round_keys2 = DesKernel.des_make_keys(temp2);
        if (temp.length == 24) {
            System.arraycopy(temp, 16, temp2, 0, 8);
        } else {
            System.arraycopy(temp, 0, temp2, 0, 8);
        }
        this._round_keys3 = DesKernel.des_make_keys(temp2);
        this._sran = random;
        this._sran.nextBytes(this._iv);
        this.reset();
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters algParam, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this._encrypting = opmode == 1;
        this.__MAGIC_NUMBER = this._encrypting ? 0 : 1;
        byte[] temp = key.getEncoded();
        if (temp == null || temp.length != 16 && temp.length != 24) {
            throw new InvalidKeyException("key does not contain a valid 3des key");
        }
        byte[] temp2 = new byte[8];
        System.arraycopy(temp, 0, temp2, 0, 8);
        this._round_keys1 = DesKernel.des_make_keys(temp2);
        System.arraycopy(temp, 8, temp2, 0, 8);
        this._round_keys2 = DesKernel.des_make_keys(temp2);
        if (temp.length == 24) {
            System.arraycopy(temp, 16, temp2, 0, 8);
        } else {
            System.arraycopy(temp, 0, temp2, 0, 8);
        }
        this._round_keys3 = DesKernel.des_make_keys(temp2);
        this._sran = random;
        if (algParam != null) {
            throw new InvalidAlgorithmParameterException("Not supported");
        }
        this._sran.nextBytes(this._iv);
        this.reset();
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this._encrypting = opmode == 1;
        this.__MAGIC_NUMBER = this._encrypting ? 0 : 1;
        byte[] temp = key.getEncoded();
        if (temp == null || temp.length != 16 && temp.length != 24) {
            throw new InvalidKeyException("key does not contain a valid 3des key");
        }
        byte[] temp2 = new byte[8];
        System.arraycopy(temp, 0, temp2, 0, 8);
        this._round_keys1 = DesKernel.des_make_keys(temp2);
        System.arraycopy(temp, 8, temp2, 0, 8);
        this._round_keys2 = DesKernel.des_make_keys(temp2);
        if (temp.length == 24) {
            System.arraycopy(temp, 16, temp2, 0, 8);
        } else {
            System.arraycopy(temp, 0, temp2, 0, 8);
        }
        this._round_keys3 = DesKernel.des_make_keys(temp2);
        this._sran = random;
        if (params == null) {
            this._sran.nextBytes(this._iv);
        } else if (params instanceof IvParameterSpec) {
            IvParameterSpec ivspec = (IvParameterSpec)params;
            byte[] temp3 = ivspec.getIV();
            if (temp3 == null || temp3.length != this.BLOCK_SIZE) {
                throw new InvalidAlgorithmParameterException("IV not " + this.BLOCK_SIZE + " bytes");
            }
            System.arraycopy(temp3, 0, this._iv, 0, this.BLOCK_SIZE);
        } else {
            throw new InvalidAlgorithmParameterException("Not supported");
        }
        this.reset();
    }

    protected int engineGetKeySize(Key k) throws InvalidKeyException {
        return 112;
    }

    protected void decrypt(byte[] input, int ioffset, byte[] output, int ooffset) {
        DesKernel.des3_decrypt(this._round_keys1, this._round_keys2, this._round_keys3, input, ioffset, output, ooffset);
    }

    protected void encrypt(byte[] input, int ioffset, byte[] output, int ooffset) {
        DesKernel.des3_encrypt(this._round_keys1, this._round_keys2, this._round_keys3, input, ioffset, output, ooffset);
    }
}

