/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.provider;

import com.cryptomathic.crypto.pad.PadMode;
import com.cryptomathic.crypto.provider.SecretKey3Des;
import com.cryptomathic.crypto.provider.SecretKeyAes;
import com.cryptomathic.crypto.provider.SecretKeyDes;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.CipherSpi;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public abstract class CipherBlockBase
extends CipherSpi {
    protected final int BLOCK_SIZE;
    protected boolean _encrypting;
    protected int __MAGIC_NUMBER;
    protected PadMode _PadMode = PadMode.ISO10126;
    protected byte[] _iv;
    protected byte[] _residueBuffer;
    protected int _residueLength = 0;
    protected int _dataProcessed = 0;
    protected SecureRandom _sran;

    public CipherBlockBase(int block_size) {
        this.BLOCK_SIZE = block_size;
        this._iv = new byte[this.BLOCK_SIZE];
        this._residueBuffer = new byte[this.BLOCK_SIZE];
    }

    protected int engineGetBlockSize() {
        return this.BLOCK_SIZE;
    }

    protected byte[] engineGetIV() {
        byte[] temp = new byte[this.BLOCK_SIZE];
        System.arraycopy(this._iv, 0, temp, 0, this.BLOCK_SIZE);
        return temp;
    }

    protected int engineGetOutputSize(int inputLen) {
        int totalLength = this._residueLength + inputLen;
        if (this._PadMode.toInt() == PadMode.NOPAD.toInt()) {
            return totalLength & ~(this.BLOCK_SIZE - 1);
        }
        return totalLength + this.BLOCK_SIZE & ~(this.BLOCK_SIZE - 1);
    }

    protected int engineGetOutputSizeUpdate(int inputLen) {
        return this._residueLength + inputLen & ~(this.BLOCK_SIZE - 1);
    }

    protected int engineGetOutputSizeFinal(int inputLen) {
        int totalLength = this._residueLength + inputLen;
        if (this._PadMode.toInt() == PadMode.NOPAD.toInt()) {
            return totalLength & ~(this.BLOCK_SIZE - 1);
        }
        if (this._encrypting) {
            return totalLength + this.BLOCK_SIZE & ~(this.BLOCK_SIZE - 1);
        }
        return totalLength & ~(this.BLOCK_SIZE - 1);
    }

    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (padding.equalsIgnoreCase("NOPAD") || padding.equalsIgnoreCase("nopadding")) {
            this._PadMode = PadMode.NOPAD;
        } else if (padding.equalsIgnoreCase("OPAD") || padding.equalsIgnoreCase("0PAD")) {
            this._PadMode = PadMode.OPAD;
        } else if (padding.equalsIgnoreCase("ISO10126")) {
            this._PadMode = PadMode.ISO10126;
        } else if (padding.equalsIgnoreCase("PADFF16") || padding.equalsIgnoreCase("FF16")) {
            this._PadMode = PadMode.PADFF16;
        } else if (padding.equalsIgnoreCase("PKCS5") || padding.equalsIgnoreCase("PKCS5Padding")) {
            this._PadMode = PadMode.PKCS5;
        } else {
            throw new NoSuchPaddingException("No Such padding");
        }
    }

    protected int engineGetKeySize(Key k) throws InvalidKeyException {
        if (k instanceof SecretKeyDes) {
            return 56;
        }
        if (k instanceof SecretKey3Des) {
            return 112;
        }
        if (k instanceof SecretKeyAes) {
            return 128;
        }
        if (k instanceof SecretKey) {
            SecretKey sk = (SecretKey)k;
            int keybytes = sk.getEncoded().length;
            return keybytes << 3;
        }
        throw new InvalidKeyException("Key is not a SecretKey");
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void reset() {
        this._residueLength = 0;
        this._dataProcessed = 0;
    }
}

