/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.provider;

import com.cryptomathic.crypto.pad.EBadPadding;
import com.cryptomathic.crypto.pad.Pad;
import com.cryptomathic.crypto.pad.PadMode;
import com.cryptomathic.crypto.provider.CipherBlockBase;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public abstract class CipherBlockCBCBase
extends CipherBlockBase {
    protected byte[][] _temp_block = new byte[2][this.BLOCK_SIZE];
    protected int _tbi = 0;
    protected byte[] __padding_block = new byte[this.BLOCK_SIZE];
    protected byte[] __zero_block = new byte[this.BLOCK_SIZE];

    public CipherBlockCBCBase(int block_size) {
        super(block_size);
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        try {
            byte[] temp = new byte[this.engineGetOutputSizeFinal(inputLen)];
            int tempsize = this.engineDoFinal(input, inputOffset, inputLen, temp, 0);
            if (tempsize != temp.length) {
                byte[] temp2 = new byte[tempsize];
                System.arraycopy(temp, 0, temp2, 0, temp2.length);
                temp = temp2;
            }
            return temp;
        }
        catch (ShortBufferException sbe) {
            System.out.println("Serious problem in engineGetOutputSizeFinal()");
            return null;
        }
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        try {
            int _temp_tbi;
            if (!this._encrypting && (this._residueLength + inputLen & this.BLOCK_SIZE - 1) != 0) {
                throw new IllegalBlockSizeException("Decryption input not mul. of " + this.BLOCK_SIZE);
            }
            if (this._PadMode.toInt() == PadMode.NOPAD.toInt()) {
                if ((this._residueLength + inputLen & this.BLOCK_SIZE - 1) != 0) {
                    throw new IllegalBlockSizeException("NOPAD input not mul. of " + this.BLOCK_SIZE);
                }
                if (this._residueLength + inputLen + this._dataProcessed == 0) {
                    return 0;
                }
            } else if (!this._encrypting && this._residueLength + inputLen + this._dataProcessed == 0) {
                throw new IllegalBlockSizeException("Decrypting empty input in padded mode!");
            }
            int returnValue = 0;
            int i = 0;
            if (this._residueLength != 0) {
                if (this._residueLength + inputLen < this.BLOCK_SIZE) {
                    if (input != null) {
                        System.arraycopy(input, inputOffset, this._residueBuffer, this._residueLength, inputLen);
                    }
                    this._residueLength += inputLen;
                    inputLen = 0;
                    inputOffset += inputLen;
                    this._dataProcessed += inputLen;
                } else {
                    _temp_tbi = this._tbi & 1;
                    int temp = this.BLOCK_SIZE - this._residueLength;
                    if (input != null) {
                        System.arraycopy(input, inputOffset, this._residueBuffer, this._residueLength, temp);
                    }
                    if (this._encrypting) {
                        for (i = 0; i < this.BLOCK_SIZE; ++i) {
                            byte[] byArray = this._temp_block[_temp_tbi];
                            int n = i;
                            byArray[n] = (byte)(byArray[n] ^ this._residueBuffer[i]);
                        }
                        this.encrypt(this._temp_block[_temp_tbi], 0, output, outputOffset);
                        for (i = 0; i < this.BLOCK_SIZE; ++i) {
                            this._temp_block[_temp_tbi][i] = output[i + outputOffset];
                        }
                    } else {
                        this.decrypt(this._residueBuffer, 0, output, outputOffset);
                        for (i = 0; i < this.BLOCK_SIZE; ++i) {
                            int n = i + outputOffset;
                            output[n] = (byte)(output[n] ^ this._temp_block[_temp_tbi][i]);
                            this._temp_block[_temp_tbi][i] = this._residueBuffer[i];
                        }
                    }
                    outputOffset += this.BLOCK_SIZE;
                    this._dataProcessed += temp;
                    inputOffset += temp;
                    returnValue += this.BLOCK_SIZE;
                    this._residueLength = 0;
                    if ((inputLen -= temp) == 0 && !this._encrypting) {
                        try {
                            System.arraycopy(output, outputOffset - this.BLOCK_SIZE, this.__padding_block, 0, this.BLOCK_SIZE);
                            int temp_int = Pad.unpad(this.__padding_block, this.BLOCK_SIZE, this._PadMode);
                            this.reset();
                            return returnValue += temp_int - this.BLOCK_SIZE;
                        }
                        catch (EBadPadding ebp) {
                            this.reset();
                            throw new BadPaddingException(ebp.getMessage());
                        }
                    }
                }
            }
            while (inputLen > this.BLOCK_SIZE + this.__MAGIC_NUMBER) {
                if (this._encrypting) {
                    for (i = 0; i < this.BLOCK_SIZE; ++i) {
                        byte[] byArray = this._temp_block[0];
                        int n = i;
                        byArray[n] = (byte)(byArray[n] ^ input[i + inputOffset]);
                    }
                    this.encrypt(this._temp_block[0], 0, output, outputOffset);
                    System.arraycopy(output, outputOffset, this._temp_block[0], 0, this.BLOCK_SIZE);
                } else {
                    _temp_tbi = this._tbi & 1;
                    System.arraycopy(input, inputOffset, this._temp_block[_temp_tbi ^ 1], 0, this.BLOCK_SIZE);
                    this.decrypt(input, inputOffset, output, outputOffset);
                    for (i = 0; i < this.BLOCK_SIZE; ++i) {
                        int n = i + outputOffset;
                        output[n] = (byte)(output[n] ^ this._temp_block[_temp_tbi][i]);
                    }
                    ++this._tbi;
                }
                outputOffset += this.BLOCK_SIZE;
                this._dataProcessed += this.BLOCK_SIZE;
                inputOffset += this.BLOCK_SIZE;
                inputLen -= this.BLOCK_SIZE;
                returnValue += this.BLOCK_SIZE;
            }
            System.arraycopy(this.__zero_block, 0, this.__padding_block, 0, this.BLOCK_SIZE);
            if (this._encrypting) {
                if (inputLen == this.BLOCK_SIZE) {
                    _temp_tbi = this._tbi & 1;
                    for (i = 0; i < this.BLOCK_SIZE; ++i) {
                        byte[] byArray = this._temp_block[_temp_tbi];
                        int n = i;
                        byArray[n] = (byte)(byArray[n] ^ input[i + inputOffset]);
                    }
                    this.encrypt(this._temp_block[_temp_tbi], 0, output, outputOffset);
                    for (i = 0; i < this.BLOCK_SIZE; ++i) {
                        this._temp_block[_temp_tbi][i] = output[i + outputOffset];
                    }
                    outputOffset += this.BLOCK_SIZE;
                    this._dataProcessed += this.BLOCK_SIZE;
                    inputOffset += this.BLOCK_SIZE;
                    inputLen -= this.BLOCK_SIZE;
                    returnValue += this.BLOCK_SIZE;
                } else if (inputLen > 0) {
                    System.arraycopy(input, inputOffset, this.__padding_block, 0, inputLen);
                } else if (this._residueLength != 0) {
                    System.arraycopy(this._residueBuffer, 0, this.__padding_block, 0, this._residueLength);
                    inputLen = this._residueLength;
                }
                int temp_int = Pad.pad(this.__padding_block, inputLen, this.BLOCK_SIZE, this._PadMode);
                if (temp_int == 1) {
                    _temp_tbi = this._tbi & 1;
                    for (i = 0; i < this.BLOCK_SIZE; ++i) {
                        int n = i;
                        this.__padding_block[n] = (byte)(this.__padding_block[n] ^ this._temp_block[_temp_tbi][i]);
                    }
                    this.encrypt(this.__padding_block, 0, output, outputOffset);
                    returnValue += this.BLOCK_SIZE;
                }
            } else if (inputLen > 0) {
                _temp_tbi = this._tbi & 1;
                this.decrypt(input, inputOffset, this.__padding_block, 0);
                for (i = 0; i < this.BLOCK_SIZE; ++i) {
                    int n = i;
                    this.__padding_block[n] = (byte)(this.__padding_block[n] ^ this._temp_block[_temp_tbi][i]);
                }
                try {
                    int temp_int = Pad.unpad(this.__padding_block, this.BLOCK_SIZE, this._PadMode);
                    System.arraycopy(this.__padding_block, 0, output, outputOffset, temp_int);
                    returnValue += temp_int;
                }
                catch (EBadPadding ebp) {
                    this.reset();
                    throw new BadPaddingException(ebp.getMessage());
                }
            }
            this.reset();
            return returnValue;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this.reset();
            throw new ShortBufferException("The buffer was to small.");
        }
    }

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!mode.toUpperCase().equals("CBC")) {
            throw new NoSuchAlgorithmException("This class only supports CBC mode.");
        }
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        try {
            byte[] temp = new byte[this.engineGetOutputSizeUpdate(inputLen)];
            int tempsize = this.engineUpdate(input, inputOffset, inputLen, temp, 0);
            if (tempsize != temp.length) {
                byte[] temp2 = new byte[tempsize];
                System.arraycopy(temp, 0, temp2, 0, tempsize);
                temp = temp2;
            }
            if (temp.length != 0) {
                return temp;
            }
            return null;
        }
        catch (ShortBufferException sbe) {
            System.out.println("Something very wrong in engineGetOutputSizeUpdate()");
            return null;
        }
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        try {
            int _temp_tbi_plus_1;
            int _temp_tbi;
            int returnValue = 0;
            if (this._residueLength != 0) {
                int i;
                if (this._residueLength + inputLen < this.BLOCK_SIZE + this.__MAGIC_NUMBER) {
                    System.arraycopy(input, inputOffset, this._residueBuffer, this._residueLength, inputLen);
                    this._residueLength += inputLen;
                    inputLen = 0;
                    inputOffset += inputLen;
                    this._dataProcessed += inputLen;
                    return 0;
                }
                _temp_tbi = this._tbi & 1;
                _temp_tbi_plus_1 = this._tbi + 1 & 1;
                int temp = this.BLOCK_SIZE - this._residueLength;
                System.arraycopy(input, inputOffset, this._residueBuffer, this._residueLength, temp);
                if (this._encrypting) {
                    for (i = 0; i < this.BLOCK_SIZE; ++i) {
                        byte[] byArray = this._temp_block[_temp_tbi];
                        int n = i;
                        byArray[n] = (byte)(byArray[n] ^ this._residueBuffer[i]);
                    }
                    this.encrypt(this._temp_block[_temp_tbi], 0, output, outputOffset);
                    for (i = 0; i < this.BLOCK_SIZE; ++i) {
                        this._temp_block[_temp_tbi][i] = output[i + outputOffset];
                    }
                } else {
                    for (i = 0; i < this.BLOCK_SIZE; ++i) {
                        this._temp_block[_temp_tbi_plus_1][i] = this._residueBuffer[i];
                    }
                    this.decrypt(this._residueBuffer, 0, output, outputOffset);
                    for (i = 0; i < this.BLOCK_SIZE; ++i) {
                        int n = i + outputOffset;
                        output[n] = (byte)(output[n] ^ this._temp_block[_temp_tbi][i]);
                    }
                    ++this._tbi;
                }
                outputOffset += this.BLOCK_SIZE;
                this._dataProcessed += temp;
                inputOffset += temp;
                inputLen -= temp;
                returnValue += this.BLOCK_SIZE;
            }
            while (inputLen >= this.BLOCK_SIZE + this.__MAGIC_NUMBER) {
                int i;
                _temp_tbi = this._tbi & 1;
                _temp_tbi_plus_1 = this._tbi + 1 & 1;
                if (this._encrypting) {
                    for (i = 0; i < this.BLOCK_SIZE; ++i) {
                        byte[] byArray = this._temp_block[_temp_tbi];
                        int n = i;
                        byArray[n] = (byte)(byArray[n] ^ input[i + inputOffset]);
                    }
                    this.encrypt(this._temp_block[_temp_tbi], 0, output, outputOffset);
                    for (i = 0; i < this.BLOCK_SIZE; ++i) {
                        this._temp_block[_temp_tbi][i] = output[i + outputOffset];
                    }
                } else {
                    for (i = 0; i < this.BLOCK_SIZE; ++i) {
                        this._temp_block[_temp_tbi_plus_1][i] = input[i + inputOffset];
                    }
                    this.decrypt(input, inputOffset, output, outputOffset);
                    for (i = 0; i < this.BLOCK_SIZE; ++i) {
                        int n = i + outputOffset;
                        output[n] = (byte)(output[n] ^ this._temp_block[_temp_tbi][i]);
                    }
                    ++this._tbi;
                }
                outputOffset += this.BLOCK_SIZE;
                this._dataProcessed += this.BLOCK_SIZE;
                inputOffset += this.BLOCK_SIZE;
                inputLen -= this.BLOCK_SIZE;
                returnValue += this.BLOCK_SIZE;
            }
            if (inputLen != 0) {
                System.arraycopy(input, inputOffset, this._residueBuffer, 0, inputLen);
                this._residueLength = inputLen;
                this._dataProcessed += inputLen;
            } else {
                this._residueLength = 0;
            }
            return returnValue;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this.reset();
            throw new ShortBufferException("The buffer was to small.");
        }
    }

    protected void reset() {
        super.reset();
        System.arraycopy(this._iv, 0, this._temp_block[0], 0, this._iv.length);
        this._tbi = 0;
    }

    protected abstract void encrypt(byte[] var1, int var2, byte[] var3, int var4);

    protected abstract void decrypt(byte[] var1, int var2, byte[] var3, int var4);
}

