/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.provider;

import com.cryptomathic.crypto.pad.EBadPadding;
import com.cryptomathic.crypto.pad.Pad;
import com.cryptomathic.crypto.pad.PadMode;
import com.cryptomathic.crypto.provider.CipherBlockBase;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public abstract class CipherBlockECBBase
extends CipherBlockBase {
    protected byte[] __padding_block;
    protected byte[] __zero_block;

    public CipherBlockECBBase(int block_size) {
        super(block_size);
        this.__padding_block = new byte[this.BLOCK_SIZE];
        this.__zero_block = new byte[this.BLOCK_SIZE];
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        try {
            byte[] temp = new byte[this.engineGetOutputSizeFinal(inputLen)];
            int tempsize = this.engineDoFinal(input, inputOffset, inputLen, temp, 0);
            if (tempsize != temp.length) {
                byte[] temp2 = new byte[tempsize];
                System.arraycopy(temp, 0, temp2, 0, temp2.length);
                temp = temp2;
            }
            return temp;
        }
        catch (ShortBufferException sbe) {
            System.out.println("Serious problem in engineGetOutputSizeFinal()");
            return null;
        }
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        try {
            int temp_int;
            if (!this._encrypting && (this._residueLength + inputLen & this.BLOCK_SIZE - 1) != 0) {
                throw new IllegalBlockSizeException("Decryption input not mul. of " + this.BLOCK_SIZE);
            }
            if (this._PadMode.toInt() == PadMode.NOPAD.toInt()) {
                if ((this._residueLength + inputLen & this.BLOCK_SIZE - 1) != 0) {
                    throw new IllegalBlockSizeException("NOPAD input not mul. of " + this.BLOCK_SIZE);
                }
            } else if (!this._encrypting && this._residueLength + inputLen + this._dataProcessed == 0) {
                throw new IllegalBlockSizeException("Empty input not allowed for NOPAD");
            }
            int returnValue = 0;
            if (this._residueLength != 0) {
                if (this._residueLength + inputLen < this.BLOCK_SIZE) {
                    if (input != null) {
                        System.arraycopy(input, inputOffset, this._residueBuffer, this._residueLength, inputLen);
                    }
                    this._residueLength += inputLen;
                    inputLen = 0;
                    inputOffset += inputLen;
                    this._dataProcessed += inputLen;
                } else {
                    int temp = this.BLOCK_SIZE - this._residueLength;
                    if (input != null) {
                        System.arraycopy(input, inputOffset, this._residueBuffer, this._residueLength, temp);
                    }
                    if (this._encrypting) {
                        this.encrypt(this._residueBuffer, 0, output, outputOffset);
                    } else {
                        this.decrypt(this._residueBuffer, 0, output, outputOffset);
                    }
                    outputOffset += this.BLOCK_SIZE;
                    this._dataProcessed += temp;
                    inputOffset += temp;
                    returnValue += this.BLOCK_SIZE;
                    this._residueLength = 0;
                    if ((inputLen -= temp) == 0 && !this._encrypting) {
                        try {
                            System.arraycopy(output, outputOffset - this.BLOCK_SIZE, this.__padding_block, 0, this.BLOCK_SIZE);
                            int temp_int2 = Pad.unpad(this.__padding_block, this.BLOCK_SIZE, this._PadMode);
                            this.reset();
                            return returnValue += temp_int2 - this.BLOCK_SIZE;
                        }
                        catch (EBadPadding ebp) {
                            this.reset();
                            throw new BadPaddingException(ebp.getMessage());
                        }
                    }
                }
            }
            while (inputLen > this.BLOCK_SIZE + this.__MAGIC_NUMBER) {
                if (this._encrypting) {
                    this.encrypt(input, inputOffset, output, outputOffset);
                } else {
                    this.decrypt(input, inputOffset, output, outputOffset);
                }
                outputOffset += this.BLOCK_SIZE;
                this._dataProcessed += this.BLOCK_SIZE;
                inputOffset += this.BLOCK_SIZE;
                inputLen -= this.BLOCK_SIZE;
                returnValue += this.BLOCK_SIZE;
            }
            System.arraycopy(this.__zero_block, 0, this.__padding_block, 0, this.BLOCK_SIZE);
            if (this._encrypting) {
                if (inputLen == this.BLOCK_SIZE) {
                    this.encrypt(input, inputOffset, output, outputOffset);
                    outputOffset += this.BLOCK_SIZE;
                    this._dataProcessed += this.BLOCK_SIZE;
                    inputOffset += this.BLOCK_SIZE;
                    inputLen -= this.BLOCK_SIZE;
                    returnValue += this.BLOCK_SIZE;
                } else if (inputLen > 0) {
                    System.arraycopy(input, inputOffset, this.__padding_block, 0, inputLen);
                } else if (this._residueLength != 0) {
                    System.arraycopy(this._residueBuffer, 0, this.__padding_block, 0, this._residueLength);
                    inputLen = this._residueLength;
                }
                temp_int = Pad.pad(this.__padding_block, inputLen, this.BLOCK_SIZE, this._PadMode);
                if (temp_int == 1) {
                    this.encrypt(this.__padding_block, 0, output, outputOffset);
                    returnValue += this.BLOCK_SIZE;
                }
            } else if (inputLen > 0) {
                this.decrypt(input, inputOffset, this.__padding_block, 0);
                try {
                    temp_int = Pad.unpad(this.__padding_block, this.BLOCK_SIZE, this._PadMode);
                    System.arraycopy(this.__padding_block, 0, output, outputOffset, temp_int);
                    returnValue += temp_int;
                }
                catch (EBadPadding ebp) {
                    this.reset();
                    throw new BadPaddingException(ebp.getMessage());
                }
            }
            this.reset();
            return returnValue;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this.reset();
            throw new ShortBufferException("The buffer was to small.");
        }
    }

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!mode.toUpperCase().equals("ECB")) {
            throw new NoSuchAlgorithmException("This class only supports ECB mode.");
        }
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        try {
            byte[] temp = new byte[this.engineGetOutputSizeUpdate(inputLen)];
            int tempsize = this.engineUpdate(input, inputOffset, inputLen, temp, 0);
            if (tempsize != temp.length) {
                byte[] temp2 = new byte[tempsize];
                System.arraycopy(temp, 0, temp2, 0, tempsize);
                temp = temp2;
            }
            if (temp.length != 0) {
                return temp;
            }
            return null;
        }
        catch (ShortBufferException sbe) {
            System.out.println("Something very wrong in engineGetOutputSizeUpdate()");
            return null;
        }
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        try {
            int returnValue = 0;
            if (this._residueLength != 0) {
                if (this._residueLength + inputLen < this.BLOCK_SIZE + this.__MAGIC_NUMBER) {
                    System.arraycopy(input, inputOffset, this._residueBuffer, this._residueLength, inputLen);
                    this._residueLength += inputLen;
                    inputLen = 0;
                    inputOffset += inputLen;
                    this._dataProcessed += inputLen;
                } else {
                    int temp = this.BLOCK_SIZE - this._residueLength;
                    System.arraycopy(input, inputOffset, this._residueBuffer, this._residueLength, temp);
                    if (this._encrypting) {
                        this.encrypt(this._residueBuffer, 0, output, outputOffset);
                    } else {
                        this.decrypt(this._residueBuffer, 0, output, outputOffset);
                    }
                    outputOffset += this.BLOCK_SIZE;
                    this._dataProcessed += temp;
                    inputOffset += temp;
                    inputLen -= temp;
                    returnValue += this.BLOCK_SIZE;
                }
            }
            while (inputLen > this.BLOCK_SIZE + this.__MAGIC_NUMBER) {
                if (this._encrypting) {
                    this.encrypt(input, inputOffset, output, outputOffset);
                } else {
                    this.decrypt(input, inputOffset, output, outputOffset);
                }
                outputOffset += this.BLOCK_SIZE;
                this._dataProcessed += this.BLOCK_SIZE;
                inputOffset += this.BLOCK_SIZE;
                inputLen -= this.BLOCK_SIZE;
                returnValue += this.BLOCK_SIZE;
            }
            if (inputLen != 0) {
                System.arraycopy(input, inputOffset, this._residueBuffer, 0, inputLen);
                this._residueLength = inputLen;
                this._dataProcessed += inputLen;
            } else {
                this._residueLength = 0;
            }
            return returnValue;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this.reset();
            throw new ShortBufferException("The buffer was to small.");
        }
    }

    protected abstract void encrypt(byte[] var1, int var2, byte[] var3, int var4);

    protected abstract void decrypt(byte[] var1, int var2, byte[] var3, int var4);
}

