/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.provider;

import com.cryptomathic.crypto.des.DesKernel;
import com.cryptomathic.crypto.provider.CipherBlockCBCBase;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public class CipherDesCBC
extends CipherBlockCBCBase {
    protected int[] _round_keys;

    public CipherDesCBC() {
        super(8);
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this._encrypting = opmode == 1;
        this.__MAGIC_NUMBER = this._encrypting ? 0 : 1;
        byte[] temp = key.getEncoded();
        if (temp == null || temp.length != 8) {
            throw new InvalidKeyException("key does not contain a valid des key");
        }
        this._round_keys = DesKernel.des_make_keys(temp);
        this._sran = random;
        this._sran.nextBytes(this._iv);
        this.reset();
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters algParam, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this._encrypting = opmode == 1;
        this.__MAGIC_NUMBER = this._encrypting ? 0 : 1;
        byte[] temp = key.getEncoded();
        if (temp == null || temp.length != 8) {
            throw new InvalidKeyException("key does not contain a valid des key");
        }
        this._round_keys = DesKernel.des_make_keys(temp);
        this._sran = random;
        if (algParam != null) {
            throw new InvalidAlgorithmParameterException("Not supported");
        }
        this._sran.nextBytes(this._iv);
        this.reset();
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this._encrypting = opmode == 1;
        this.__MAGIC_NUMBER = this._encrypting ? 0 : 1;
        byte[] k = key.getEncoded();
        if (k == null || k.length != 8) {
            throw new InvalidKeyException("key does not contain a valid des key");
        }
        this._round_keys = DesKernel.des_make_keys(k);
        this._sran = random;
        if (params == null) {
            this._sran.nextBytes(this._iv);
        } else if (params instanceof IvParameterSpec) {
            IvParameterSpec ivspec = (IvParameterSpec)params;
            byte[] temp = ivspec.getIV();
            if (temp == null || temp.length != this.BLOCK_SIZE) {
                throw new InvalidAlgorithmParameterException("IV not " + this.BLOCK_SIZE + " bytes");
            }
            System.arraycopy(temp, 0, this._iv, 0, this.BLOCK_SIZE);
        } else {
            throw new InvalidAlgorithmParameterException("Not supported");
        }
        this.reset();
    }

    protected void decrypt(byte[] input, int ioffset, byte[] output, int ooffset) {
        DesKernel.des_decrypt(this._round_keys, input, ioffset, output, ooffset);
    }

    protected void encrypt(byte[] input, int ioffset, byte[] output, int ooffset) {
        DesKernel.des_encrypt(this._round_keys, input, ioffset, output, ooffset);
    }
}

