/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.provider;

import com.cryptomathic.crypto.pad.PadMode;
import com.cryptomathic.crypto.rsa.CorruptEncryptionBlockException;
import com.cryptomathic.crypto.rsa.ParameterOutOfBoundsException;
import com.cryptomathic.crypto.rsa.Pkcs1v1;
import com.cryptomathic.crypto.rsa.UnknownBlocktypeException;
import com.cryptomathic.security.RSAPublicKey;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class CipherRSA
extends CipherSpi {
    private RSAPublicKey _pubKey;
    private com.cryptomathic.security.RSAPrivateKey _priKey;
    private int _padding = 2;
    private byte[] _input;
    private int _inputLen;
    private int _modLen;
    private boolean _encrypt;
    public static final boolean _BWSmode = false;

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException {
        byte[] _output;
        this.engineUpdate(input, inputOffset, inputLen);
        if (this._inputLen == 0 || this._inputLen > this._modLen) {
            this._inputLen = 0;
            throw new IllegalBlockSizeException("Too much input");
        }
        byte[] temp = new byte[this._inputLen];
        System.arraycopy(this._input, 0, temp, 0, this._inputLen);
        try {
            _output = this._encrypt ? Pkcs1v1.encrypt(this._pubKey, (byte)this._padding, temp) : Pkcs1v1.decrypt(this._priKey, temp);
        }
        catch (ParameterOutOfBoundsException exc) {
            throw new IllegalBlockSizeException("PKCS1v1 Exception: Parameter out of bounds");
        }
        catch (UnknownBlocktypeException exc) {
            throw new IllegalBlockSizeException("PKCS1v1 Exception: Bad padding specified");
        }
        catch (CorruptEncryptionBlockException exc) {
            throw new IllegalBlockSizeException("PKCS1v1 Exception: Corrupt encryption block");
        }
        finally {
            this._inputLen = 0;
        }
        if (!this._encrypt) {
            // empty if block
        }
        return _output;
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException {
        if (output.length - outputOffset < this._modLen) {
            throw new ShortBufferException("Output buffer too small");
        }
        System.arraycopy(this.engineDoFinal(input, inputOffset, inputLen), 0, output, outputOffset, this._modLen);
        return this._modLen;
    }

    protected int engineGetBlockSize() {
        return 0;
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected int engineGetOutputSize(int inputLen) {
        if (!this._encrypt) {
            // empty if block
        }
        return this._modLen;
    }

    private void engineInit(int opmode, Key key) throws InvalidKeyException {
        if (key instanceof com.cryptomathic.security.RSAPrivateKey) {
            this._priKey = (com.cryptomathic.security.RSAPrivateKey)key;
            this._pubKey = new RSAPublicKey(this._priKey.getModulus(), this._priKey.getPrivateExponent());
        } else if (key instanceof RSAPublicKey) {
            this._pubKey = (RSAPublicKey)key;
            this._priKey = new com.cryptomathic.security.RSAPrivateKey(this._pubKey.getModulus(), this._pubKey.getPublicExponent());
        } else if (key instanceof java.security.interfaces.RSAPublicKey) {
            this._pubKey = new RSAPublicKey(((java.security.interfaces.RSAPublicKey)key).getModulus(), ((java.security.interfaces.RSAPublicKey)key).getPublicExponent());
            this._priKey = new com.cryptomathic.security.RSAPrivateKey(((java.security.interfaces.RSAPublicKey)key).getModulus(), ((java.security.interfaces.RSAPublicKey)key).getPublicExponent());
        } else if (key instanceof RSAPrivateKey) {
            this._pubKey = new RSAPublicKey(((RSAPrivateKey)key).getModulus(), ((RSAPrivateKey)key).getPrivateExponent());
            this._priKey = new com.cryptomathic.security.RSAPrivateKey(((RSAPrivateKey)key).getModulus(), ((RSAPrivateKey)key).getPrivateExponent());
        } else {
            throw new InvalidKeyException("Not a valid RSA key");
        }
        this._modLen = this._priKey.getModulus().toByteArray().length;
        this._encrypt = opmode == 1;
        this._input = null;
        this._inputLen = 0;
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this.engineInit(opmode, key);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters algParam, SecureRandom random) throws InvalidKeyException {
        this.engineInit(opmode, key);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException {
        this.engineInit(opmode, key);
    }

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
    }

    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (padding.equals(PadMode.PKCS1_BT0.toString())) {
            this._padding = 0;
        } else if (padding.equals(PadMode.PKCS1_BT1.toString())) {
            this._padding = 1;
        } else if (padding.equals(PadMode.PKCS1_BT2.toString())) {
            this._padding = 2;
        } else {
            throw new NoSuchPaddingException("No Such padding");
        }
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (input == null || inputOffset < 0 || inputLen < 0 || inputOffset + inputLen > input.length) {
            throw new InvalidParameterException("Null input buffer or bad offset or length parameters");
        }
        if (this._input == null) {
            this._input = new byte[inputLen];
            System.arraycopy(input, inputOffset, this._input, 0, inputLen);
            this._inputLen = inputLen;
        } else if (this._inputLen + inputLen < this._input.length) {
            System.arraycopy(input, inputOffset, this._input, this._inputLen, inputLen);
            this._inputLen += inputLen;
        } else {
            byte[] temp = 2 * this._input.length < this._input.length + inputLen ? new byte[this._input.length + inputLen] : new byte[2 * this._input.length];
            System.arraycopy(this._input, 0, temp, 0, this._inputLen);
            System.arraycopy(input, 0, temp, this._inputLen, inputLen);
            this._input = temp;
            this._inputLen += inputLen;
        }
        return null;
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (output == null || outputOffset < 0 || outputOffset > output.length) {
            throw new InvalidParameterException("Null output buffer or bad offset or length parameters");
        }
        if (output.length < this._modLen) {
            throw new ShortBufferException("Outputbuffer too short");
        }
        this.engineUpdate(input, inputOffset, inputLen);
        return 0;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected int engineGetKeySize(Key k) throws InvalidKeyException {
        if (k instanceof java.security.interfaces.RSAPublicKey) {
            java.security.interfaces.RSAPublicKey pk = (java.security.interfaces.RSAPublicKey)k;
            return pk.getModulus().bitLength();
        }
        if (k instanceof RSAPrivateKey) {
            RSAPrivateKey pk = (RSAPrivateKey)k;
            return pk.getModulus().bitLength();
        }
        throw new InvalidKeyException("Not an RSA key");
    }
}

